
(in-package :translator-test)

(def-test-method file-check-access-test ((test fs-test))
  (let ((file (concatenate-string +translator-root+
                                  "/root/a")))
    (with-testport (p (file-name-lookup file))
      (let ((stat (io-stat p)))
        (let ((mode (stat-get stat 'st-mode)))
          (with-cleanup (file-chmod p (stat-get stat 'st-mode))
            (set-perms mode :write)
            (assert-equal '(:write :read)
                          (file-check-access p))))
        (let ((mode (stat-get stat 'st-mode)))
          (with-cleanup (file-chmod p (stat-get stat 'st-mode))
            (set-perms mode :exec)
            (file-chmod p mode)
            (assert-equal '(:exec :write :read)
                          (file-check-access p))))
        (let ((mode (stat-get stat 'st-mode)))
          (with-cleanup (file-chmod p (stat-get stat 'st-mode))
            (set-perms mode :exec)
            (set-perms mode :write)
            (file-chmod p mode)
            (assert-equal '(:exec :write :read)
                          (file-check-access p))))))))
