; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
define i8 @flip_add_of_shift_neg(i8 %v, i8 %sh, i8 %x) {
; CHECK-LABEL: define i8 @flip_add_of_shift_neg
; CHECK-SAME: (i8 [[V:%.*]], i8 [[SH:%.*]], i8 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = shl i8 [[V]], [[SH]]
; CHECK-NEXT:    [[R:%.*]] = sub i8 [[X]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %nv = sub i8 0, %v
  %sv = shl nuw nsw i8 %nv, %sh
  %r = add i8 %sv, %x
  ret i8 %r
}

define <2 x i8> @flip_add_of_shift_neg_vec(<2 x i8> %v, <2 x i8> %sh, <2 x i8> %xx) {
; CHECK-LABEL: define <2 x i8> @flip_add_of_shift_neg_vec
; CHECK-SAME: (<2 x i8> [[V:%.*]], <2 x i8> [[SH:%.*]], <2 x i8> [[XX:%.*]]) {
; CHECK-NEXT:    [[X:%.*]] = mul <2 x i8> [[XX]], [[XX]]
; CHECK-NEXT:    [[TMP1:%.*]] = shl <2 x i8> [[V]], [[SH]]
; CHECK-NEXT:    [[R:%.*]] = sub <2 x i8> [[X]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %x = mul <2 x i8> %xx, %xx
  %nv = sub <2 x i8> zeroinitializer, %v
  %sv = shl <2 x i8> %nv, %sh
  %r = add <2 x i8> %x, %sv
  ret <2 x i8> %r
}

define i8 @flip_add_of_shift_neg_fail_shr(i8 %v, i8 %sh, i8 %x) {
; CHECK-LABEL: define i8 @flip_add_of_shift_neg_fail_shr
; CHECK-SAME: (i8 [[V:%.*]], i8 [[SH:%.*]], i8 [[X:%.*]]) {
; CHECK-NEXT:    [[NV:%.*]] = sub i8 0, [[V]]
; CHECK-NEXT:    [[SV:%.*]] = lshr i8 [[NV]], [[SH]]
; CHECK-NEXT:    [[R:%.*]] = add i8 [[SV]], [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %nv = sub i8 0, %v
  %sv = lshr i8 %nv, %sh
  %r = add i8 %sv, %x
  ret i8 %r
}

declare void @use.v2i8(<2 x i8>)
define <2 x i8> @flip_add_of_shift_neg_vec_fail_multiuse_neg(<2 x i8> %v, <2 x i8> %sh, <2 x i8> %xx) {
; CHECK-LABEL: define <2 x i8> @flip_add_of_shift_neg_vec_fail_multiuse_neg
; CHECK-SAME: (<2 x i8> [[V:%.*]], <2 x i8> [[SH:%.*]], <2 x i8> [[XX:%.*]]) {
; CHECK-NEXT:    [[X:%.*]] = mul <2 x i8> [[XX]], [[XX]]
; CHECK-NEXT:    [[NV:%.*]] = sub <2 x i8> zeroinitializer, [[V]]
; CHECK-NEXT:    [[SV:%.*]] = shl <2 x i8> [[NV]], [[SH]]
; CHECK-NEXT:    call void @use.v2i8(<2 x i8> [[NV]])
; CHECK-NEXT:    [[R:%.*]] = add <2 x i8> [[X]], [[SV]]
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %x = mul <2 x i8> %xx, %xx
  %nv = sub <2 x i8> zeroinitializer, %v
  %sv = shl <2 x i8> %nv, %sh
  call void @use.v2i8(<2 x i8> %nv)
  %r = add <2 x i8> %x, %sv
  ret <2 x i8> %r
}

define <2 x i8> @flip_add_of_shift_neg_vec_fail_multiuse_shift(<2 x i8> %v, <2 x i8> %sh, <2 x i8> %xx) {
; CHECK-LABEL: define <2 x i8> @flip_add_of_shift_neg_vec_fail_multiuse_shift
; CHECK-SAME: (<2 x i8> [[V:%.*]], <2 x i8> [[SH:%.*]], <2 x i8> [[XX:%.*]]) {
; CHECK-NEXT:    [[X:%.*]] = mul <2 x i8> [[XX]], [[XX]]
; CHECK-NEXT:    [[NV:%.*]] = sub <2 x i8> zeroinitializer, [[V]]
; CHECK-NEXT:    [[SV:%.*]] = shl <2 x i8> [[NV]], [[SH]]
; CHECK-NEXT:    call void @use.v2i8(<2 x i8> [[SV]])
; CHECK-NEXT:    [[R:%.*]] = add <2 x i8> [[X]], [[SV]]
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %x = mul <2 x i8> %xx, %xx
  %nv = sub <2 x i8> zeroinitializer, %v
  %sv = shl <2 x i8> %nv, %sh
  call void @use.v2i8(<2 x i8> %sv)
  %r = add <2 x i8> %x, %sv
  ret <2 x i8> %r
}
