; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; This test checks that we do not outline functions that are marked as returns
; twice, since these can alter the frame of the function and affect how the
; outliner behaves, causing miscompiles.

; Function Attrs: optsize returns_twice
declare i32 @setjmp(ptr) local_unnamed_addr #1
@tmp_jmpb = global [37 x i32] zeroinitializer, align 16

define void @function1() {
; CHECK-LABEL: @function1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 2, ptr [[A]], align 4
; CHECK-NEXT:    store i32 3, ptr [[B]], align 4
; CHECK-NEXT:    store i32 4, ptr [[C]], align 4
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @setjmp(ptr @tmp_jmpb)
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[A]], ptr [[B]], ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  store i32 4, ptr %c, align 4
  %call = call i32 @setjmp(ptr @tmp_jmpb)
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

define void @function2() {
; CHECK-LABEL: @function2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 2, ptr [[A]], align 4
; CHECK-NEXT:    store i32 3, ptr [[B]], align 4
; CHECK-NEXT:    store i32 4, ptr [[C]], align 4
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @setjmp(ptr @tmp_jmpb)
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[A]], ptr [[B]], ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  store i32 4, ptr %c, align 4
  %call = call i32 @setjmp(ptr @tmp_jmpb)
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

attributes #1 = { optsize returns_twice }
