# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Callout dialog primary button to advance to next screen
callout-primary-advance-button-label = Next
# Callout dialog primary button to complete the feature tour
callout-primary-complete-button-label = Got it!

## Firefox View feature tour strings

# "Tab pickup" refers to the section in Firefox View that displays open
# tabs from other devices
callout-firefox-view-tab-pickup-title = Hop between devices with tab pickup
callout-firefox-view-tab-pickup-subtitle = Quickly grab open tabs from your phone and open them here for maximum flow.
callout-firefox-view-recently-closed-title = Get back your closed tabs in a snap
callout-firefox-view-recently-closed-subtitle = All your closed tabs will magically show up here. Never worry about accidentally closing a site again.
callout-firefox-view-colorways-title = Add a splash of colour
# "Shade" refer to different color options in each colorway.
callout-firefox-view-colorways-subtitle = Choose the shade that speaks to you with colourways. Only in { -brand-product-name }.
callout-firefox-view-colorways-reminder-title = Explore our latest colourways
# “Shades” refers to the different color options in each colorways
callout-firefox-view-colorways-reminder-subtitle = Colour your browser with these iconic shades, inspired by independent voices. Only in { -brand-product-name }.

## Continuous Onboarding - Firefox View: Tab pick up

# “Boost your browsing” refers to the added benefit the user receives from having
# access to the same browsing experience when moving from one browser to another.
# Alternative: ”Improve your browsing experience with tab pickup”
continuous-onboarding-firefox-view-tab-pickup-title = Boost your browsing with tab pickup
continuous-onboarding-firefox-view-tab-pickup-subtitle = Access your open tabs from any device. Plus synchronise your bookmarks, passwords and more.
continuous-onboarding-firefox-view-tab-pickup-primary-button-label = Get started

## PDF.js Feature Tour Strings

callout-pdfjs-edit-title = Edit PDFs with our new text tool
callout-pdfjs-edit-body-a = Fill out forms, add comments, or take notes directly in { -brand-short-name }.
callout-pdfjs-edit-body-b = Skip the search for free online editors. Fill out forms, add comments, or take notes directly in { -brand-short-name }.
callout-pdfjs-edit-button = Next
callout-pdfjs-draw-title = Sign documents with our new draw tool
# “Mark up” refers to the process of “annotating” or adding free hand text or diagramming to the document.
callout-pdfjs-draw-body-a = Mark up PDFs, then save your changes.
# “Mark up” refers to the process of “annotating” or adding free hand text or diagramming to the document.
callout-pdfjs-draw-body-b = No more printing and scanning. Mark up PDFs, then save your changes.
callout-pdfjs-draw-button = Got it!

## Firefox View Discoverability Strings

fx-view-discoverability-title = Didn’t mean to close that tab?
fx-view-discoverability-subtitle = Find and reopen it quickly here. We keep a history of your recently closed tabs for you.
fx-view-discoverability-primary-button-label = Open { -firefoxview-brand-name }
fx-view-discoverability-secondary-button-label = Dismiss

## Split Dismiss Button Labels

# Blocks the message from showing again
split-dismiss-button-dont-show-option =
    .label = Don’t show this recommendation again
# Dismisses message and reduces frequency of message
split-dismiss-button-show-fewer-option =
    .label = Show fewer recommendations
# Opens about:preferences#general-cfrfeatures
split-dismiss-button-manage-settings-option =
    .label = Manage settings
# Accessibility label for dropdown menu button
split-dismiss-button-default-label =
    .title = More options

## Sidebar Strings

sidebar-button-callout-title = Show tab titles in the sidebar
sidebar-button-callout-subtitle = Use the sidebar button to expand the sidebar, so you can see tab titles.
sidebar-button-callout-vertical-tabs = To show your tabs, select the sidebar button in the toolbar.

## Sidebar Vertical Tabs Strings

vertical-tabs-callout-1-title = Overwhelmed by too many tabs?
vertical-tabs-callout-1-subtitle = Try our new vertical tabs layout to quickly scan your list of tabs. Early testers report this layout helps them feel more organised. Switch anytime.
vertical-tabs-callout-1-cta-button = Try vertical tabs
vertical-tabs-callout-2-cta-button = Try now
vertical-tabs-callout-2-title = Keep a lot of tabs open? Try vertical tabs.
vertical-tabs-callout-2-subtitle = This layout makes it easy to quickly scan your list of tabs. Plus, you can adjust the width to see more or less of your tab titles.

## Sidebar Vertical Tabs Pinning Strings

sidebar-pins-callout-title = Losing track of your important tabs?
sidebar-pins-callout-subtitle = Try pinning them, which keeps them at the top of your list of tabs. Right-click on a tab you want to pin, then choose Pin Tab.
sidebar-pins-callout-cta-button = Pin tab

## Sidebar Onboarding Strings

sidebar-customization-callout-1-title = Sidebar: your spot for tools and tabs
sidebar-customization-callout-1-subtitle = The { -brand-product-name } sidebar gives you quick access to your browsing history, tabs from other devices, and an AI chatbot — all without leaving your main view.
sidebar-customization-callout-callout-button = Customise sidebar
sidebar-customization-callout-dismiss-button = Hide sidebar
sidebar-customization-callout-2-title = Make the { -brand-product-name } sidebar your own
sidebar-customization-callout-2-subtitle = Add and remove tools. Place your tabs in the sidebar. Give an AI chatbot a try. How you customise your sidebar is up to you.

## Sidebar Callout Survey Strings

sidebar-callout-survey-title = Help improve { -brand-short-name }
sidebar-callout-survey-satisfaction-question = How satisfied are you with the sidebar experience in { -brand-short-name }?
sidebar-callout-survey-privacy-notice-link = Privacy Notice
sidebar-callout-survey-very-satisfied = Very satisfied
sidebar-callout-survey-satisfied = Satisfied
sidebar-callout-survey-neutral = Neutral
sidebar-callout-survey-dissatisfied-2 = Dissatisfied
sidebar-callout-survey-very-dissatisfied-2 = Very dissatisfied
sidebar-callout-survey-dont-use-it = I don’t use it
sidebar-callout-survey-productive-question =
    To what extent do you agree or disagree with this statement:<br/>
    “The { -brand-short-name } sidebar helps me be more productive”?
sidebar-callout-survey-strongly-agree = Strongly agree
sidebar-callout-survey-agree = Agree
sidebar-callout-survey-disagree = Disagree
sidebar-callout-survey-strongly-disagree = Strongly disagree
sidebar-callout-survey-features-question = The following are potential sidebar features. Which would improve your productivity in { -brand-short-name } the most?
sidebar-callout-survey-split-view = View any two web sites at once, in a side-by-side split view
sidebar-callout-survey-keep-website-open = Keep a web site, like email or calendar, open in the sidebar as you browse
sidebar-callout-survey-saved-websites-2 = Quick access to your bookmarks
sidebar-callout-survey-none-of-above = None of the above
sidebar-callout-survey-submit = Submit
sidebar-callout-survey-thank-you = Thank you for your feedback!
sidebar-genai-survey-satisfaction-question = How satisfied are you with having access to an AI chatbot in the sidebar?
sidebar-genai-survey-productive-question =
    To what extent do you agree or disagree with this statement:<br/>
    “The AI chatbot in the sidebar helps me be more productive”?
unified-search-callout-title = Switch between search engines
unified-search-callout-subtitle = Choose what works best for your specific search.
unified-search-callout-primary-label = Next
unified-search-callout-secondary-label = Dismiss
unified-search-engines-callout-title = Search with a shortcut
unified-search-engines-callout-subtitle = Type “@” followed by a keyword to search your history, bookmarks, tabs, or with another search engine.
unified-search-engines-callout-primary-label = Got it
actions-callout-title = Complete common tasks or access basic settings
# The user can type "print" and "clear" and a button will appear in the
# search bar (e.g. Print page) the user can click to initiate the action.
# These example text inputs correlate to the the following strings
# (either matching the whole string, or the first word of the string).
# "print" - quickactions-cmd-print
# "clear" - quickactions-cmd-clearrecenthistory
# When localizing, ensure the translations match to ensure the action button appears as expected.
actions-callout-subtitle = Try typing an action like “print” to print a page, or “clear” to clear your history.
