#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Before Your Eyes
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240906.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='before-your-eyes'
GAME_NAME='Before Your Eyes'

ARCHIVE_BASE_0_NAME='setup_before_your_eyes_1.2.6.9_(61649).exe'
ARCHIVE_BASE_0_MD5='4da11b5113be696a0dc0764e19e06a99'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_before_your_eyes_1.2.6.9_(61649)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='c0ecc5986194e1c090662a25c25b8eb7'
ARCHIVE_BASE_0_SIZE='5100000'
ARCHIVE_BASE_0_VERSION='1.2.6.9-gog61649'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/before_your_eyes'

UNITY3D_NAME='before your eyes'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Goodbye World/Before Your Eyes'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
