/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 17:44:19 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JCheckBox;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.QualifierPanel;
import uk.ac.sanger.artemis.components.SelectionViewer;
import uk.ac.sanger.artemis.components.TransferAnnotationTool;
import uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class TransferAnnotationTool_ESTest extends TransferAnnotationTool_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier();
      StringVector stringVector0 = SelectionViewer.getBaseSummary("1MlH#A-R5M");
      // Undeclared exception!
      try { 
        TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.TransferAnnotationTool", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      TransferAnnotationTool transferAnnotationTool0 = null;
      try {
        transferAnnotationTool0 = new TransferAnnotationTool((Feature) null, simpleEntryGroup0, (MatchPanel) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.TransferAnnotationTool", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("h&Rg%{`\"},'?", "}(x}T@:\"u");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry(")ECV'\"a?9ph");
      Feature feature0 = entry0.createFeature();
      MatchPanel matchPanel0 = new MatchPanel(feature0, (DocumentEntry) null);
      TransferAnnotationTool transferAnnotationTool0 = null;
      try {
        transferAnnotationTool0 = new TransferAnnotationTool(feature0, simpleEntryGroup0, matchPanel0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("history", "(1O5");
      StringVector stringVector0 = StringVector.getStrings("history");
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
      assertNull(qualifier1);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier(" 3atres", " 3atres");
      StringVector stringVector0 = StringVector.getStrings(" 3atres");
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
      assertNotNull(qualifier1);
      assertNotSame(qualifier1, qualifier0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("I`[ON+8I");
      qualifier0.addValue("I`[ON+8I");
      StringVector stringVector0 = qualifier0.getValues();
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
      assertNull(qualifier1);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier();
      StringVector stringVector0 = StringVector.getStrings("", "hE@Ihe'ZXqkdXN;Q", false);
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
      assertNull(qualifier1.getName());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("I`[ON+8I");
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, (StringVector) null);
      assertSame(qualifier0, qualifier1);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Feature feature0 = new Feature(genbankStreamFeature0);
      QualifierPanel qualifierPanel0 = new QualifierPanel(feature0, "blastn_file");
      Hashtable<JCheckBox, Vector<JCheckBox>> hashtable0 = qualifierPanel0.getQualifierCheckBoxes();
      JCheckBox jCheckBox0 = new JCheckBox();
      Stack<JCheckBox> stack0 = new Stack<JCheckBox>();
      stack0.add(jCheckBox0);
      StringBuffer stringBuffer0 = new StringBuffer();
      JCheckBox jCheckBox1 = new JCheckBox("blastn_file", true);
      stack0.add(jCheckBox1);
      // Undeclared exception!
      try { 
        TransferAnnotationTool.transferAnnotation(hashtable0, stack0, feature0, simpleEntryGroup0, true, true, true, stringBuffer0, stringBuffer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.TransferAnnotationTool", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Feature feature0 = new Feature(genbankStreamFeature0);
      QualifierPanel qualifierPanel0 = new QualifierPanel(feature0, "blastn_file");
      Hashtable<JCheckBox, Vector<JCheckBox>> hashtable0 = qualifierPanel0.getQualifierCheckBoxes();
      JCheckBox jCheckBox0 = new JCheckBox();
      Stack<JCheckBox> stack0 = new Stack<JCheckBox>();
      stack0.add(jCheckBox0);
      StringBuffer stringBuffer0 = new StringBuffer();
      // Undeclared exception!
      try { 
        TransferAnnotationTool.transferAnnotation(hashtable0, stack0, feature0, simpleEntryGroup0, true, true, true, stringBuffer0, stringBuffer0);
      
      } catch(Exception e) {
    	  	fail("Expecting exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Feature feature0 = new Feature(genbankStreamFeature0);
      QualifierPanel qualifierPanel0 = new QualifierPanel(feature0, "blastn_file");
      Hashtable<JCheckBox, Vector<JCheckBox>> hashtable0 = qualifierPanel0.getQualifierCheckBoxes();
      JCheckBox jCheckBox0 = new JCheckBox("blastn_file", true);
      Vector<JCheckBox> vector0 = new Vector<JCheckBox>();
      hashtable0.put(jCheckBox0, vector0);
      Stack<JCheckBox> stack0 = new Stack<JCheckBox>();
      StringBuffer stringBuffer0 = new StringBuffer();
      // Undeclared exception!
      try { 
        TransferAnnotationTool.transferAnnotation(hashtable0, stack0, feature0, simpleEntryGroup0, true, true, true, stringBuffer0, stringBuffer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.TransferAnnotationTool", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Feature feature0 = new Feature(genbankStreamFeature0);
      QualifierPanel qualifierPanel0 = new QualifierPanel(feature0, "blastn_file");
      Hashtable<JCheckBox, Vector<JCheckBox>> hashtable0 = qualifierPanel0.getQualifierCheckBoxes();
      JCheckBox jCheckBox0 = new JCheckBox();
      Vector<JCheckBox> vector0 = new Vector<JCheckBox>();
      hashtable0.put(jCheckBox0, vector0);
      Stack<JCheckBox> stack0 = new Stack<JCheckBox>();
      StringBuffer stringBuffer0 = new StringBuffer();
      // Undeclared exception!
      try { 
        TransferAnnotationTool.transferAnnotation(hashtable0, stack0, feature0, simpleEntryGroup0, true, true, true, stringBuffer0, stringBuffer0);
        
      } catch(Exception e) {
    	  	fail("Expecting exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      boolean boolean0 = TransferAnnotationTool.isNonTransferable("Derives_from");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      boolean boolean0 = TransferAnnotationTool.isNonTransferable("0>%4SATt|C{$");
      assertFalse(boolean0);
  }
}
