/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __globals
#define __globals

#include "tokenizer.h"

#include <cstring>
#include <string>

struct load_globals {
  std::string ignore;
  bool load_intervals (const std::string& fname);
  void load_note_colors (const std::string& fname);
  load_globals ();
};


void calc_volume_vars (int height);
void calc_tonic_limits ();

template <class T> struct pusher {
  virtual T& operator<< (const std::string& s)=0;
  virtual T& operator<< (char c)=0;
};

#include <iostream>

template<class T> void into_lines (const std::string& str, pusher<T>& push) {

  static tokenizer tz;
  static const std::string newline = "\n";
  static const char endln = '\n';

  if (str.length()) {
    tz.set (str, newline);
    std::string ln;
    while (1) {
      std::string ln; tz >> ln;
      if (ln == "") break; else { push << ln << endln; }
    }
  }
}

#endif
