/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.EloRating;
import friendless.games.filler.PlayerRating;
import friendless.games.filler.PlayerWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PlayerRatings
implements Serializable {
    public static final String RATINGS_FILENAME = "ratings.ser";
    static final long serialVersionUID = -5410208778282312709L;
    static PlayerRatings theInstance;
    List ratings = new ArrayList();

    static PlayerRating search(PlayerWrapper playerWrapper) {
        String string = playerWrapper.getFullName();
        int n = 0;
        while (n < PlayerRatings.theInstance.ratings.size()) {
            PlayerRating playerRating = (PlayerRating)PlayerRatings.theInstance.ratings.get(n);
            if (playerRating.name.equals(string)) {
                return playerRating;
            }
            ++n;
        }
        return null;
    }

    static PlayerRating includePlayer(PlayerWrapper playerWrapper) {
        PlayerRating playerRating = PlayerRatings.search(playerWrapper);
        if (playerRating == null) {
            playerRating = new PlayerRating(playerWrapper.getFullName());
            PlayerRatings.theInstance.ratings.add(playerRating);
        }
        return playerRating;
    }

    public static int[] getRatings(PlayerWrapper playerWrapper, PlayerWrapper playerWrapper2) {
        PlayerRating playerRating = PlayerRatings.includePlayer(playerWrapper);
        PlayerRating playerRating2 = PlayerRatings.includePlayer(playerWrapper2);
        int[] nArray = new int[]{playerRating.rating, playerRating2.rating};
        return nArray;
    }

    public static String getHeadToHead(PlayerWrapper[] playerWrapperArray) {
        PlayerRating playerRating = PlayerRatings.includePlayer(playerWrapperArray[0]);
        PlayerRating playerRating2 = PlayerRatings.includePlayer(playerWrapperArray[1]);
        return playerRating.getHeadToHead(playerWrapperArray[0].getName(), playerWrapperArray[1]);
    }

    public static void setRatings(PlayerWrapper[] playerWrapperArray, int[] nArray, int n) {
        PlayerRating[] playerRatingArray = new PlayerRating[]{PlayerRatings.search(playerWrapperArray[0]), PlayerRatings.search(playerWrapperArray[1])};
        int n2 = 1 - n;
        playerRatingArray[n].result(playerWrapperArray[n2], true);
        playerRatingArray[n2].result(playerWrapperArray[n], false);
        int n3 = EloRating.adjust(nArray, n);
        int n4 = 0;
        while (n4 < 2) {
            playerRatingArray[n4].rating = nArray[n4];
            ++n4;
        }
        int n5 = playerRatingArray[n].rating;
        int n6 = playerRatingArray[n2].rating;
        int n7 = playerRatingArray[n].games;
        int n8 = playerRatingArray[n2].games;
        if (n7 < 20 && n5 < n6) {
            playerRatingArray[n].rating = (n7 * n5 + (20 - n7) * n6) / 20;
        }
        if (n8 < 20 && n6 > n5) {
            playerRatingArray[n2].rating = (n8 * n6 + (20 - n8) * n5) / 20;
        }
    }

    public void printRatings() {
        int n = 0;
        while (n < this.ratings.size()) {
            System.out.println(this.ratings.get(n).toString());
            ++n;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void retrieve() {
        FileInputStream fileInputStream = null;
        File file = new File(System.getProperty("user.dir") + File.separator + RATINGS_FILENAME);
        fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        theInstance = (PlayerRatings)objectInputStream.readObject();
        objectInputStream.close();
        fileInputStream.close();
        Object var4_4 = null;
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                System.out.println("In PlayerRatings.retrieve");
                exception.printStackTrace();
                theInstance = new PlayerRatings();
                Object var4_5 = null;
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void save() {
        try {
            File file = new File(System.getProperty("user.dir") + File.separator + RATINGS_FILENAME);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(theInstance);
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("In PlayerRatings.save");
            System.out.println(System.getProperty("user.dir"));
            exception.printStackTrace();
        }
    }
}

