---
stage: none
group: unassigned
info: Any user with at least the Maintainer role can merge updates to this content. For details, see https://docs.gitlab.com/ee/development/development_processes.html#development-guidelines-review.
---

# RSpec metadata for end-to-end tests

This is a partial list of the [RSpec metadata](https://rspec.info/features/3-12/rspec-core/metadata/user-defined/)
(a.k.a. tags) that are used in our end-to-end tests.

<!-- Please keep the tags in alphabetical order -->

| Tag                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
|--------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `:elasticsearch`               | The test requires an Elasticsearch service. It is used by the [instance-level scenario](https://gitlab.com/gitlab-org/gitlab-qa#definitions) [`Test::Integration::Elasticsearch`](https://gitlab.com/gitlab-org/gitlab/-/blob/72b62b51bdf513e2936301cb6c7c91ec27c35b4d/qa/qa/ee/scenario/test/integration/elasticsearch.rb) to include only tests that require Elasticsearch.                                                                                                                                    |
| `:except`                      | The test is to be run in their typical execution contexts _except_ as specified. See [test execution context selection](execution_context_selection.md) for more information.                                                                                                                                                                                                                                                                                                                                    |
| `:external_api_calls`          | The test requires interaction with a network external to the Docker network.                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `:external_ai_provider`        | The test requires an environment that is integrated with a real external AI provider.                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `:feature_flag`                | The test uses a feature flag and therefore requires an administrator account to run. When `scope` is set to `:global`, the test will be skipped on all live .com environments. Otherwise, it will be skipped only on Canary, Production, and Pre-production. See [testing with feature flags](../../../../development/testing_guide/end_to_end/best_practices/feature_flags.md) for more details.                                                                                                                                  |
| `:geo`                         | The test requires two GitLab Geo instances - a primary and a secondary - to be spun up.                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `:gitaly_cluster`              | The test runs against a GitLab instance where repositories are stored on redundant Gitaly nodes behind a Praefect node. All nodes are [separate containers](../../../../administration/gitaly/praefect.md#requirements). Tests that use this tag have a longer setup time since there are three additional containers that need to be started.                                                                                                                                                                      |
| `:github`                      | The test requires a GitHub personal access token.                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `:group_saml`                  | The test requires a GitLab instance that has SAML SSO enabled for the group. Interacts with an external SAML identity provider. Paired with the `:orchestrated` tag.                                                                                                                                                                                                                                                                                                                                        |
| `:instance_saml`               | The test requires a GitLab instance that has SAML SSO enabled for the instance. Interacts with an external SAML identity provider. Paired with the `:orchestrated` tag.                                                                                                                                                                                                                                                                                                                                     |
| `:integrations`                | This aims to test the available [integrations](../../../../user/project/integrations/index.md#available-integrations). The test requires Docker to be installed in the run context. It will provision the containers and can be run against a local instance or using the `gitlab-qa` scenario `Test::Integration::Integrations`.                                                                                                                                                                                   |
| `:issue`, `:issue_${num}`      | Optional links to issues which might be related to the spec. Helps keep track of related issues and can also be used by tools that create test reports. Currently added automatically to `Allure` test report. Multiple tags can be used by adding an optional numeric suffix like `issue_1`, `issue_2` etc.                                                                                                                                                                                                     |
| `:service_ping_disabled`       | The test interacts with the GitLab configuration service ping at the instance level to turn **Admin** area setting service ping checkbox on or off. This tag will have the test run only in the `service_ping_disabled` job and must be paired with the `:orchestrated` and `:requires_admin` tags.                                                                                                                                                                                                                  |
| `:jira`                        | The test requires a Jira Server. [GitLab-QA](https://gitlab.com/gitlab-org/gitlab-qa) provisions the Jira Server in a Docker container when the `Test::Integration::Jira` test scenario is run.                                                                                                                                                                                                                                                                                                                  |
| `:kubernetes`                  | The test includes a GitLab instance that is configured to be run behind an SSH tunnel, allowing a TLS-accessible GitLab. This test also includes provisioning of at least one Kubernetes cluster to test against. _This tag is often be paired with `:orchestrated`._                                                                                                                                                                                                                                            |
| `:ldap_no_server`              | The test requires a GitLab instance to be configured to use LDAP. To be used with the `:orchestrated` tag. It does not spin up an LDAP server at orchestration time. Instead, it creates the LDAP server at runtime.                                                                                                                                                                                                                                                                                             |
| `:ldap_no_tls`                 | The test requires a GitLab instance to be configured to use an external LDAP server with TLS not enabled.                                                                                                                                                                                                                                                                                                                                                                                                        |
| `:ldap_tls`                    | The test requires a GitLab instance to be configured to use an external LDAP server with TLS enabled.                                                                                                                                                                                                                                                                                                                                                                                                            |
| `:mattermost`                  | The test requires a GitLab Mattermost service on the GitLab instance.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `:metrics`                     | The test requires a GitLab instance where [dedicated metrics exporters](../../../../administration/monitoring/prometheus/web_exporter.md) are running alongside Puma and Sidekiq.                                                                                                                                                                                                                                                                                                                                   |
| `:mixed_env`                   | The test should only be executed in environments that have a paired canary version available through traffic routing based on the existence of the `gitlab_canary=true` cookie. Tests in this category are switching the cookie mid-test to validate mixed deployment environments.                                                                                                                                                                                                                              |
| `:oauth`                       | The test uses and external OmniAuth provider to sign in to GitLab.                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `:object_storage`              | The test requires a GitLab instance to be configured to use multiple [object storage types](../../../../administration/object_storage.md). Uses MinIO as the object storage server.                                                                                                                                                                                                                                                                                                                                 |
| `:only`                        | The test is only to be run in specific execution contexts. See [test execution context selection](execution_context_selection.md) for more information.                                                                                                                                                                                                                                                                                                                                                          |
| `:orchestrated`                | The GitLab instance under test may be [configured by `gitlab-qa`](https://gitlab.com/gitlab-org/gitlab-qa/-/blob/master/docs/what_tests_can_be_run.md#orchestrated-tests) to be different to the default GitLab configuration, or `gitlab-qa` may launch additional services in separate Docker containers, or both. Tests tagged with `:orchestrated` are excluded when testing environments where we can't dynamically modify the GitLab configuration (for example, Staging).                                 |
| `:product_group`               | Specifies what product group the test belongs to. See [Product sections, stages, groups, and categories](https://handbook.gitlab.com/handbook/product/categories/) for the comprehensive groups list.                                                                                                                                                                                                                                                                                                            |
| `:quarantine`                  | The test has been [quarantined](https://handbook.gitlab.com/handbook/engineering/infrastructure/test-platform/debugging-qa-test-failures/#quarantining-tests), runs in a separate job that only includes quarantined tests, and is allowed to fail. The test is skipped in its regular job so that if it fails it doesn't hold up the pipeline. Note that you can also [quarantine a test only when it runs in a specific context](execution_context_selection.md#quarantine-a-test-for-a-specific-environment). |
| `:relative_url`                | The test requires a GitLab instance to be installed under a [relative URL](../../../../install/relative_url.md).                                                                                                                                                                                                                                                                                                                                                                                                    |
| `:blocking`                    | Tag for tests running in `e2e:test-on-gdk` pipeline and not allowed to fail. Only tests that pass consistently should have this tag.                                                                                                                                                                                                                                                                                                                                                                             |
| `:repository_storage`          | The test requires a GitLab instance to be configured to use multiple [repository storage paths](../../../../administration/repository_storage_paths.md). Paired with the `:orchestrated` tag.                                                                                                                                                                                                                                                                                                                       |
| `:requires_admin`              | The test requires an administrator account. Tests with the tag are excluded when run against Canary and Production environments.                                                                                                                                                                                                                                                                                                                                                                                 |
| `:requires_git_protocol_v2`    | The test requires that Git protocol version 2 is enabled on the server. It's assumed to be enabled by default but if not the test can be skipped by setting `QA_CAN_TEST_GIT_PROTOCOL_V2` to `false`.                                                                                                                                                                                                                                                                                                            |
| `:requires_praefect`           | The test requires that the GitLab instance uses [Gitaly Cluster](../../../../administration/gitaly/praefect.md) (a.k.a. Praefect) as the repository storage. It's assumed to be used by default but if not the test can be skipped by setting `QA_CAN_TEST_PRAEFECT` to `false`.                                                                                                                                                                                                                                    |
| `:runner`                      | The test depends on and sets up a GitLab Runner instance, typically to run a pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `:skip_live_env`               | The test is excluded when run against live deployed environments such as Staging, Canary, and Production.                                                                                                                                                                                                                                                                                                                                                                                                        |
| `:skip_fips_env`               | The test is excluded when run against an environment in FIPS mode.                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `:skip_signup_disabled`        | The test uses UI to sign up a new user and is skipped in any environment that does not allow new user registration via the UI.                                                                                                                                                                                                                                                                                                                                                                                   |
| `:smoke`                       | The test belongs to the test suite which verifies basic functionality of a GitLab instance.                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `:health_check`                | The test belongs to the smallest test suite, a subset of smoke. Used to monitor the status and health of the application                                                                                                                                                                                                                                                                                                                                                                                         |
| `:smtp`                        | The test requires a GitLab instance to be configured to use an SMTP server. Tests SMTP notification email delivery from GitLab by using MailHog.                                                                                                                                                                                                                                                                                                                                                                 |
| `:testcase`                    | The link to the test case issue in the [GitLab Project test cases](https://gitlab.com/gitlab-org/gitlab/-/quality/test_cases).                                                                                                                                                                                                                                                                                                                                                                                   |
| `:transient`                   | The test tests transient bugs. It is excluded by default.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `:ai_gateway`                  | The test requires a GitLab instance configured to use a local [AI Gateway](https://gitlab.com/gitlab-org/modelops/applied-ml/code-suggestions/ai-assist) with a valid cloud license, Duo Pro add-on and Duo Pro seat assigned to the administrator user. Paired with the `:orchestrated` tag.                                                                                                                                                                                                                                                                                                                              |
| `:ai_gateway_no_seat_assigned` | The test requires a GitLab instance configured to use a local [AI Gateway](https://gitlab.com/gitlab-org/modelops/applied-ml/code-suggestions/ai-assist) where there is no seat assigned to the administrator user. Paired with the `:orchestrated` tag.                                                                                                                                                                                                                                                                                                                                         |
| `:ai_gateway_no_license`       | The test requires a GitLab instance configured to use a local [AI Gateway](https://gitlab.com/gitlab-org/modelops/applied-ml/code-suggestions/ai-assist) without a valid cloud license. Paired with the `:orchestrated` tag.                                                                                                                                                                                                                                                                                                                                                                     |
| `:ai_gateway_no_add_on`        | The test requires a GitLab instance configured to use a local [AI Gateway](https://gitlab.com/gitlab-org/modelops/applied-ml/code-suggestions/ai-assist) with a valid cloud license, but with no Duo Pro add-on assigned. Paired with the `:orchestrated` tag.                                                                                                                                                                                                                                                                                                                                   |
