// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/group"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/entc/integration/edgeschema/ent/user"
	"entgo.io/ent/entc/integration/edgeschema/ent/usergroup"
	"entgo.io/ent/schema/field"
)

// UserGroupUpdate is the builder for updating UserGroup entities.
type UserGroupUpdate struct {
	config
	hooks    []Hook
	mutation *UserGroupMutation
}

// Where appends a list predicates to the UserGroupUpdate builder.
func (ugu *UserGroupUpdate) Where(ps ...predicate.UserGroup) *UserGroupUpdate {
	ugu.mutation.Where(ps...)
	return ugu
}

// SetJoinedAt sets the "joined_at" field.
func (ugu *UserGroupUpdate) SetJoinedAt(t time.Time) *UserGroupUpdate {
	ugu.mutation.SetJoinedAt(t)
	return ugu
}

// SetNillableJoinedAt sets the "joined_at" field if the given value is not nil.
func (ugu *UserGroupUpdate) SetNillableJoinedAt(t *time.Time) *UserGroupUpdate {
	if t != nil {
		ugu.SetJoinedAt(*t)
	}
	return ugu
}

// SetUserID sets the "user_id" field.
func (ugu *UserGroupUpdate) SetUserID(i int) *UserGroupUpdate {
	ugu.mutation.SetUserID(i)
	return ugu
}

// SetGroupID sets the "group_id" field.
func (ugu *UserGroupUpdate) SetGroupID(i int) *UserGroupUpdate {
	ugu.mutation.SetGroupID(i)
	return ugu
}

// SetUser sets the "user" edge to the User entity.
func (ugu *UserGroupUpdate) SetUser(u *User) *UserGroupUpdate {
	return ugu.SetUserID(u.ID)
}

// SetGroup sets the "group" edge to the Group entity.
func (ugu *UserGroupUpdate) SetGroup(g *Group) *UserGroupUpdate {
	return ugu.SetGroupID(g.ID)
}

// Mutation returns the UserGroupMutation object of the builder.
func (ugu *UserGroupUpdate) Mutation() *UserGroupMutation {
	return ugu.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (ugu *UserGroupUpdate) ClearUser() *UserGroupUpdate {
	ugu.mutation.ClearUser()
	return ugu
}

// ClearGroup clears the "group" edge to the Group entity.
func (ugu *UserGroupUpdate) ClearGroup() *UserGroupUpdate {
	ugu.mutation.ClearGroup()
	return ugu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ugu *UserGroupUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(ugu.hooks) == 0 {
		if err = ugu.check(); err != nil {
			return 0, err
		}
		affected, err = ugu.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*UserGroupMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = ugu.check(); err != nil {
				return 0, err
			}
			ugu.mutation = mutation
			affected, err = ugu.sqlSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(ugu.hooks) - 1; i >= 0; i-- {
			if ugu.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = ugu.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, ugu.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (ugu *UserGroupUpdate) SaveX(ctx context.Context) int {
	affected, err := ugu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ugu *UserGroupUpdate) Exec(ctx context.Context) error {
	_, err := ugu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ugu *UserGroupUpdate) ExecX(ctx context.Context) {
	if err := ugu.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ugu *UserGroupUpdate) check() error {
	if _, ok := ugu.mutation.UserID(); ugu.mutation.UserCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "UserGroup.user"`)
	}
	if _, ok := ugu.mutation.GroupID(); ugu.mutation.GroupCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "UserGroup.group"`)
	}
	return nil
}

func (ugu *UserGroupUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   usergroup.Table,
			Columns: usergroup.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: usergroup.FieldID,
			},
		},
	}
	if ps := ugu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ugu.mutation.JoinedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: usergroup.FieldJoinedAt,
		})
	}
	if ugu.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.UserTable,
			Columns: []string{usergroup.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: user.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.UserTable,
			Columns: []string{usergroup.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: user.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ugu.mutation.GroupCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.GroupTable,
			Columns: []string{usergroup.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: group.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ugu.mutation.GroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.GroupTable,
			Columns: []string{usergroup.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: group.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, ugu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{usergroup.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	return n, nil
}

// UserGroupUpdateOne is the builder for updating a single UserGroup entity.
type UserGroupUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *UserGroupMutation
}

// SetJoinedAt sets the "joined_at" field.
func (uguo *UserGroupUpdateOne) SetJoinedAt(t time.Time) *UserGroupUpdateOne {
	uguo.mutation.SetJoinedAt(t)
	return uguo
}

// SetNillableJoinedAt sets the "joined_at" field if the given value is not nil.
func (uguo *UserGroupUpdateOne) SetNillableJoinedAt(t *time.Time) *UserGroupUpdateOne {
	if t != nil {
		uguo.SetJoinedAt(*t)
	}
	return uguo
}

// SetUserID sets the "user_id" field.
func (uguo *UserGroupUpdateOne) SetUserID(i int) *UserGroupUpdateOne {
	uguo.mutation.SetUserID(i)
	return uguo
}

// SetGroupID sets the "group_id" field.
func (uguo *UserGroupUpdateOne) SetGroupID(i int) *UserGroupUpdateOne {
	uguo.mutation.SetGroupID(i)
	return uguo
}

// SetUser sets the "user" edge to the User entity.
func (uguo *UserGroupUpdateOne) SetUser(u *User) *UserGroupUpdateOne {
	return uguo.SetUserID(u.ID)
}

// SetGroup sets the "group" edge to the Group entity.
func (uguo *UserGroupUpdateOne) SetGroup(g *Group) *UserGroupUpdateOne {
	return uguo.SetGroupID(g.ID)
}

// Mutation returns the UserGroupMutation object of the builder.
func (uguo *UserGroupUpdateOne) Mutation() *UserGroupMutation {
	return uguo.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (uguo *UserGroupUpdateOne) ClearUser() *UserGroupUpdateOne {
	uguo.mutation.ClearUser()
	return uguo
}

// ClearGroup clears the "group" edge to the Group entity.
func (uguo *UserGroupUpdateOne) ClearGroup() *UserGroupUpdateOne {
	uguo.mutation.ClearGroup()
	return uguo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (uguo *UserGroupUpdateOne) Select(field string, fields ...string) *UserGroupUpdateOne {
	uguo.fields = append([]string{field}, fields...)
	return uguo
}

// Save executes the query and returns the updated UserGroup entity.
func (uguo *UserGroupUpdateOne) Save(ctx context.Context) (*UserGroup, error) {
	var (
		err  error
		node *UserGroup
	)
	if len(uguo.hooks) == 0 {
		if err = uguo.check(); err != nil {
			return nil, err
		}
		node, err = uguo.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*UserGroupMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = uguo.check(); err != nil {
				return nil, err
			}
			uguo.mutation = mutation
			node, err = uguo.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(uguo.hooks) - 1; i >= 0; i-- {
			if uguo.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = uguo.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, uguo.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*UserGroup)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from UserGroupMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (uguo *UserGroupUpdateOne) SaveX(ctx context.Context) *UserGroup {
	node, err := uguo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (uguo *UserGroupUpdateOne) Exec(ctx context.Context) error {
	_, err := uguo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uguo *UserGroupUpdateOne) ExecX(ctx context.Context) {
	if err := uguo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uguo *UserGroupUpdateOne) check() error {
	if _, ok := uguo.mutation.UserID(); uguo.mutation.UserCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "UserGroup.user"`)
	}
	if _, ok := uguo.mutation.GroupID(); uguo.mutation.GroupCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "UserGroup.group"`)
	}
	return nil
}

func (uguo *UserGroupUpdateOne) sqlSave(ctx context.Context) (_node *UserGroup, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   usergroup.Table,
			Columns: usergroup.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: usergroup.FieldID,
			},
		},
	}
	id, ok := uguo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "UserGroup.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := uguo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, usergroup.FieldID)
		for _, f := range fields {
			if !usergroup.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != usergroup.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := uguo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := uguo.mutation.JoinedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: usergroup.FieldJoinedAt,
		})
	}
	if uguo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.UserTable,
			Columns: []string{usergroup.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: user.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.UserTable,
			Columns: []string{usergroup.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: user.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if uguo.mutation.GroupCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.GroupTable,
			Columns: []string{usergroup.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: group.FieldID,
				},
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := uguo.mutation.GroupIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.GroupTable,
			Columns: []string{usergroup.GroupColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: &sqlgraph.FieldSpec{
					Type:   field.TypeInt,
					Column: group.FieldID,
				},
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &UserGroup{config: uguo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, uguo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{usergroup.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	return _node, nil
}
