/*
 *  $Id: layer.h 21763 2019-01-01 22:09:12Z yeti-dn $
 *  Copyright (C) 2016 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */
#ifndef __GWY_LAYER_H__
#define __GWY_LAYER_H__ 1

enum {
    PROXIMITY_DISTANCE = 8,
    CROSS_SIZE = 8,
};

/* GwySelection has no public interface for direct access to coordinates, even
 * for reading, but layers are friends.  Wrap the ugliness in a function... */
G_GNUC_UNUSED
static inline const gdouble*
gwy_vector_layer_selection_data(GwyVectorLayer *layer)
{
    return &g_array_index(layer->selection->objects, gdouble, 0);
}

G_GNUC_UNUSED
static inline guint
gwy_vector_layer_n_selected(GwyVectorLayer *layer)
{
    return gwy_selection_get_data(layer->selection, NULL);
}

#endif

/* vim: set cin et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
