# 9/26/2019

### Agenda:

* Dan Hutchinson (Foundry, security expert)
  - What should we know? We don’t know what we don’t know.
  - CVE’s on mitre.org
  - Allocating huge memory: -x option?
* Tarball signing
* VFX reference platform says 2.3.x ?!?
* Distro packages
* SonarCloud has failed on last 2 PRS’s
* Mission Statement
* Reference images

### Attending:

* Cary Phillips
* Christina Tempelaar-Lietz
* Kimball Thurston
* Joseph Goldstone
* Peter Hillman
* Doug Walker
* Dan Hutchinson
* Carol Payne
* Daniel Heckenberg

### Discussion:

* Dan Hutchinson joined from Foundry to discuss security.

* There’s a healthy security research community, likes to look at
  popular libraries and does research to find vulnerabilities. They’re
  quite enthusiastic.

* Projects need a security policy, and should announce a solicitation
  to the community to report vulnerabilities. Some projects post a PGP
  key with which to encrypt vulnerability reports.

* Projects should have a Responsible Disclosure Policy - given 60 days
  to respond.

* There’s a huge chasm between a bug and an exploit, a way of turning
  the bug into an actionable way of gaining access to a system. It’s
  legitimate for projects to ask, “Do you have an exploit available?”

* Projects need static and dynamic analyzers. OpenEXR uses
  Sonar. SonarCube is a report aggregator. It can subsume valgrind
  reports.

* How concerned should we be about security?  Put yourself in the
  shoes of a hacker: file formats are a common attack vector.

* Dan: OpenEXR is being proactive already;IlmImfFuzzTest is “awesome”.

* Dan: Fewer than 10 CVE’s in 10 years is a pretty good record for a
  file format.

* Dan: From what you’ve said, OpenEXR has ticked all the security
  boxes.

* There are issues with how the library is used: the API says pass in
  a buffer of size X and application passes in buffer of size X-1, and
  we overwrite. Is that our problem? Not really.

* Some of the complaints were that the library could allocate all the
  machine’s memory, then something else would crash, leading to a
  DoS. DoS attacks are common, but not the worst vulnerability.

* An image can be large but compress well, so a small file can lead to
  large memory allocation.

* Tiff has a comparable attribute structure: is there anything we can
  learn from them?

* Is there a plan to provide binary packages hosted in nexus? Not yet.

* Should use common hardening C++ flags.

* Is it worth providing GPG signatures? It prevents against someone
  someone inserting something into the repo, and man-in-the-middle
  attacks..

* Should enable 2-factor authentication on GitHub accounts.

* Would hope that package maintainers would be proactive, but many of
  them probably include OpenEXR only because it’s a dependency of
  something else which might not have changed..

* Reference images: it would be helpful to have a set of images for
  use with a performance test suite, and that exhibit a range of
  features of the library and format, such as multiple AOV’s,
  etc. https://github.com/openexr/openexr-images needs some curating.

* TAC meeting yesterday - Michael Johnson mentioned that Apple is
  sitting on some security-related issues, will work on getting them
  approved.
