/*========================== begin_copyright_notice ============================

Copyright (C) 2017-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

#include <stdio.h>
#include <string.h>

int main(int argc, char **argv)
{
    FILE *input;
    FILE *output;

    if (!argv[1] || !strcmp(argv[1], "-h") || !strcmp(argv[1], "--help") || !argv[2] || !argv[3])
    {
        printf("Usage: bif_linker [input file] [output file] [symbol base name]\n");
        return 0;
    }

    input = fopen(argv[1], "rb");
    if (!input)
    {
        printf("Unable to open input file for reading (%s)\n", argv[1]);
        return 1;
    }

    output = fopen(argv[2], "wb");
    if (!output)
    {
        printf("Unable to open output file for writing (%s)\n", argv[2]);
        return 1;
    }

    fprintf(output, "// This file is auto generated by bo_linker, DO NOT EDIT\n\n");
    fprintf(output, "unsigned char __attribute__((visibility(\"default\"))) %s[] =\n{\n    ", argv[3]);

    int count = 0;
    int is_eol;
    unsigned char data;
    while(fread(&data, 1, 1, input))
    {
        is_eol = count ? !(count % 20) : 0;
        fprintf(output, "%s0x%.2x, ", is_eol? "\n    ":"", data);
        count++;
    }
    fprintf(output, "\n};\n\n");

    fprintf(output, "unsigned int __attribute__((visibility(\"default\"))) %s_size = %d;\n\n", argv[3], count);
    fclose(input);
    fclose(output);

}



