/* The following code was generated by JFlex 1.7.0-SNAPSHOT tweaked for IntelliJ platform */

/* It's an automatically generated code. Do not modify it. */
package org.intellij.lang.regexp;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;

import com.intellij.util.containers.IntArrayList;
import java.util.EnumSet;

import static org.intellij.lang.regexp.RegExpCapability.*;

@SuppressWarnings("ALL")

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0-SNAPSHOT
 * from the specification file <tt>regexp-lexer.flex</tt>
 */
class _RegExLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int QUOTED = 2;
  public static final int EMBRACED = 4;
  public static final int QUANTIFIER = 6;
  public static final int NEGATED_CLASS = 8;
  public static final int QUOTED_CLASS1 = 10;
  public static final int CLASS1 = 12;
  public static final int CLASS2 = 14;
  public static final int PROP = 16;
  public static final int NAMED = 18;
  public static final int OPTIONS = 20;
  public static final int COMMENT = 22;
  public static final int NAMED_GROUP = 24;
  public static final int QUOTED_NAMED_GROUP = 26;
  public static final int PY_NAMED_GROUP_REF = 28;
  public static final int PY_COND_REF = 30;
  public static final int BRACKET_EXPRESSION = 32;
  public static final int MYSQL_CHAR_EXPRESSION = 34;
  public static final int MYSQL_CHAR_EQ_EXPRESSION = 36;
  public static final int EMBRACED_HEX = 38;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17, 18, 18, 19, 19
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\10\0\2\61\1\76\1\0\1\61\1\76\22\0\1\14\1\75\1\0"+
    "\1\72\1\16\1\0\1\71\1\64\1\2\1\3\1\20\1\21\1\56"+
    "\1\13\1\1\1\0\1\53\3\55\4\54\2\47\1\67\1\0\1\63"+
    "\1\70\1\74\1\17\1\0\1\30\1\30\1\37\1\35\1\45\1\46"+
    "\1\31\1\57\1\40\2\73\1\44\1\66\1\60\1\73\1\42\1\50"+
    "\1\65\1\34\1\73\1\43\1\33\1\33\1\33\1\73\1\32\1\6"+
    "\1\10\1\7\1\23\1\12\1\0\1\25\1\26\1\36\1\35\1\25"+
    "\1\25\1\27\1\57\1\40\1\73\1\62\1\43\1\73\1\24\1\73"+
    "\1\41\1\73\1\24\1\33\1\24\1\52\1\33\1\33\1\51\1\73"+
    "\1\31\1\4\1\22\1\5\54\0\1\11\12\0\1\11\4\0\1\11"+
    "\5\0\27\11\1\0\37\11\1\0\u01ca\11\4\0\14\11\16\0\5\11"+
    "\7\0\1\11\1\0\1\11\201\0\5\11\1\0\2\11\2\0\4\11"+
    "\1\0\1\11\6\0\1\11\1\0\3\11\1\0\1\11\1\0\24\11"+
    "\1\0\123\11\1\0\213\11\10\0\246\11\1\0\46\11\2\0\1\11"+
    "\7\0\47\11\110\0\33\11\5\0\3\11\55\0\53\11\25\0\12\15"+
    "\4\0\2\11\1\0\143\11\1\0\1\11\17\0\2\11\7\0\2\11"+
    "\12\15\3\11\2\0\1\11\20\0\1\11\1\0\36\11\35\0\131\11"+
    "\13\0\1\11\16\0\12\15\41\11\11\0\2\11\4\0\1\11\5\0"+
    "\26\11\4\0\1\11\11\0\1\11\3\0\1\11\27\0\31\11\107\0"+
    "\25\11\117\0\66\11\3\0\1\11\22\0\1\11\7\0\12\11\4\0"+
    "\12\15\1\0\20\11\4\0\10\11\2\0\2\11\2\0\26\11\1\0"+
    "\7\11\1\0\1\11\3\0\4\11\3\0\1\11\20\0\1\11\15\0"+
    "\2\11\1\0\3\11\4\0\12\15\2\11\23\0\6\11\4\0\2\11"+
    "\2\0\26\11\1\0\7\11\1\0\2\11\1\0\2\11\1\0\2\11"+
    "\37\0\4\11\1\0\1\11\7\0\12\15\2\0\3\11\20\0\11\11"+
    "\1\0\3\11\1\0\26\11\1\0\7\11\1\0\2\11\1\0\5\11"+
    "\3\0\1\11\22\0\1\11\17\0\2\11\4\0\12\15\11\0\1\11"+
    "\13\0\10\11\2\0\2\11\2\0\26\11\1\0\7\11\1\0\2\11"+
    "\1\0\5\11\3\0\1\11\36\0\2\11\1\0\3\11\4\0\12\15"+
    "\1\0\1\11\21\0\1\11\1\0\6\11\3\0\3\11\1\0\4\11"+
    "\3\0\2\11\1\0\1\11\1\0\2\11\3\0\2\11\3\0\3\11"+
    "\3\0\14\11\26\0\1\11\25\0\12\15\25\0\10\11\1\0\3\11"+
    "\1\0\27\11\1\0\20\11\3\0\1\11\32\0\3\11\5\0\2\11"+
    "\4\0\12\15\25\0\10\11\1\0\3\11\1\0\27\11\1\0\12\11"+
    "\1\0\5\11\3\0\1\11\40\0\1\11\1\0\2\11\4\0\12\15"+
    "\1\0\2\11\22\0\10\11\1\0\3\11\1\0\51\11\2\0\1\11"+
    "\20\0\1\11\20\0\3\11\4\0\12\15\12\0\6\11\5\0\22\11"+
    "\3\0\30\11\1\0\11\11\1\0\1\11\2\0\7\11\37\0\12\15"+
    "\21\0\60\11\1\0\2\11\14\0\7\11\11\0\12\15\47\0\2\11"+
    "\1\0\1\11\2\0\2\11\1\0\1\11\2\0\1\11\6\0\4\11"+
    "\1\0\7\11\1\0\3\11\1\0\1\11\1\0\1\11\2\0\2\11"+
    "\1\0\4\11\1\0\2\11\11\0\1\11\2\0\5\11\1\0\1\11"+
    "\11\0\12\15\2\0\4\11\40\0\1\11\37\0\12\15\26\0\10\11"+
    "\1\0\44\11\33\0\5\11\163\0\53\11\24\0\1\11\12\15\6\0"+
    "\6\11\4\0\4\11\3\0\1\11\3\0\2\11\7\0\3\11\4\0"+
    "\15\11\14\0\1\11\1\0\12\15\6\0\46\11\1\0\1\11\5\0"+
    "\1\11\2\0\53\11\1\0\u014d\11\1\0\4\11\2\0\7\11\1\0"+
    "\1\11\1\0\4\11\2\0\51\11\1\0\4\11\2\0\41\11\1\0"+
    "\4\11\2\0\7\11\1\0\1\11\1\0\4\11\2\0\17\11\1\0"+
    "\71\11\1\0\4\11\2\0\103\11\45\0\20\11\20\0\126\11\2\0"+
    "\6\11\3\0\u026c\11\2\0\21\11\1\0\32\11\5\0\113\11\6\0"+
    "\10\11\7\0\15\11\1\0\4\11\16\0\22\11\16\0\22\11\16\0"+
    "\15\11\1\0\3\11\17\0\64\11\43\0\1\11\4\0\1\11\3\0"+
    "\12\15\46\0\12\15\6\0\130\11\10\0\51\11\1\0\1\11\5\0"+
    "\106\11\12\0\37\11\47\0\12\15\36\11\2\0\5\11\13\0\54\11"+
    "\4\0\32\11\6\0\12\15\46\0\27\11\11\0\65\11\53\0\12\15"+
    "\6\0\12\15\15\0\1\11\135\0\57\11\21\0\7\11\4\0\12\15"+
    "\51\0\36\11\15\0\2\11\12\15\54\11\32\0\44\11\34\0\12\15"+
    "\3\0\3\11\12\15\44\11\153\0\4\11\1\0\4\11\3\0\2\11"+
    "\11\0\300\11\100\0\u0116\11\2\0\6\11\2\0\46\11\2\0\6\11"+
    "\2\0\10\11\1\0\1\11\1\0\1\11\1\0\1\11\1\0\37\11"+
    "\2\0\65\11\1\0\7\11\1\0\1\11\3\0\3\11\1\0\7\11"+
    "\3\0\4\11\2\0\6\11\4\0\15\11\5\0\3\11\1\0\7\11"+
    "\164\0\1\11\15\0\1\11\20\0\15\11\145\0\1\11\4\0\1\11"+
    "\2\0\12\11\1\0\1\11\3\0\5\11\6\0\1\11\1\0\1\11"+
    "\1\0\1\11\1\0\4\11\1\0\13\11\2\0\4\11\5\0\5\11"+
    "\4\0\1\11\64\0\2\11\u0a7b\0\57\11\1\0\57\11\1\0\205\11"+
    "\6\0\4\11\3\0\2\11\14\0\46\11\1\0\1\11\5\0\1\11"+
    "\2\0\70\11\7\0\1\11\20\0\27\11\11\0\7\11\1\0\7\11"+
    "\1\0\7\11\1\0\7\11\1\0\7\11\1\0\7\11\1\0\7\11"+
    "\1\0\7\11\120\0\1\11\u01d5\0\2\11\52\0\5\11\5\0\2\11"+
    "\4\0\126\11\6\0\3\11\1\0\132\11\1\0\4\11\5\0\51\11"+
    "\3\0\136\11\21\0\33\11\65\0\20\11\u0200\0\u19b6\11\112\0\u51d6\11"+
    "\52\0\u048d\11\103\0\56\11\2\0\u010d\11\3\0\20\11\12\15\2\11"+
    "\24\0\57\11\20\0\37\11\2\0\106\11\61\0\11\11\2\0\147\11"+
    "\2\0\43\11\2\0\10\11\77\0\13\11\1\0\3\11\1\0\4\11"+
    "\1\0\27\11\35\0\64\11\16\0\62\11\34\0\12\15\30\0\6\11"+
    "\3\0\1\11\1\0\1\11\2\0\12\15\34\11\12\0\27\11\31\0"+
    "\35\11\7\0\57\11\34\0\1\11\12\15\6\0\5\11\1\0\12\11"+
    "\12\15\5\11\1\0\51\11\27\0\3\11\1\0\10\11\4\0\12\15"+
    "\6\0\27\11\3\0\1\11\3\0\62\11\1\0\1\11\3\0\2\11"+
    "\2\0\5\11\2\0\1\11\1\0\1\11\30\0\3\11\2\0\13\11"+
    "\7\0\3\11\14\0\6\11\2\0\6\11\2\0\6\11\11\0\7\11"+
    "\1\0\7\11\1\0\53\11\1\0\12\11\12\0\163\11\15\0\12\15"+
    "\6\0\u2ba4\11\14\0\27\11\4\0\61\11\u2104\0\u016e\11\2\0\152\11"+
    "\46\0\7\11\14\0\5\11\5\0\1\11\1\0\12\11\1\0\15\11"+
    "\1\0\5\11\1\0\1\11\1\0\2\11\1\0\2\11\1\0\154\11"+
    "\41\0\u016b\11\22\0\100\11\2\0\66\11\50\0\14\11\164\0\5\11"+
    "\1\0\207\11\23\0\12\15\7\0\32\11\6\0\32\11\13\0\131\11"+
    "\3\0\6\11\2\0\6\11\2\0\6\11\2\0\3\11\43\0\14\11"+
    "\1\0\32\11\1\0\23\11\1\0\2\11\1\0\17\11\2\0\16\11"+
    "\42\0\173\11\u0185\0\35\11\3\0\61\11\57\0\40\11\20\0\21\11"+
    "\1\0\10\11\6\0\46\11\12\0\36\11\2\0\44\11\4\0\10\11"+
    "\60\0\236\11\2\0\12\15\126\0\50\11\10\0\64\11\234\0\u0137\11"+
    "\11\0\26\11\12\0\10\11\230\0\6\11\2\0\1\11\1\0\54\11"+
    "\1\0\2\11\3\0\1\11\2\0\27\11\12\0\27\11\11\0\37\11"+
    "\101\0\23\11\1\0\2\11\12\0\26\11\12\0\32\11\106\0\70\11"+
    "\6\0\2\11\100\0\1\11\17\0\4\11\1\0\3\11\1\0\33\11"+
    "\54\0\35\11\3\0\35\11\43\0\10\11\1\0\34\11\33\0\66\11"+
    "\12\0\26\11\12\0\23\11\15\0\22\11\156\0\111\11\67\0\63\11"+
    "\15\0\63\11\u0310\0\65\11\56\0\12\15\23\0\55\11\40\0\31\11"+
    "\7\0\12\15\11\0\44\11\17\0\12\15\20\0\43\11\3\0\1\11"+
    "\14\0\60\11\16\0\4\11\13\0\12\15\1\11\1\0\1\11\43\0"+
    "\22\11\1\0\31\11\124\0\7\11\1\0\1\11\1\0\4\11\1\0"+
    "\17\11\1\0\12\11\7\0\57\11\21\0\12\15\13\0\10\11\2\0"+
    "\2\11\2\0\26\11\1\0\7\11\1\0\2\11\1\0\5\11\3\0"+
    "\1\11\22\0\1\11\14\0\5\11\u011e\0\60\11\24\0\2\11\1\0"+
    "\1\11\10\0\12\15\246\0\57\11\51\0\4\11\44\0\60\11\24\0"+
    "\1\11\13\0\12\15\46\0\53\11\25\0\12\15\66\0\32\11\26\0"+
    "\12\15\u0166\0\100\11\12\15\25\0\1\11\u01c0\0\71\11\u0507\0\u039a\11"+
    "\346\0\304\11\u0abc\0\u042f\11\u0fd1\0\u0247\11\u21b9\0\u0239\11\7\0\37\11"+
    "\1\0\12\15\146\0\36\11\22\0\60\11\20\0\4\11\14\0\12\15"+
    "\11\0\25\11\5\0\23\11\u0370\0\105\11\13\0\1\11\102\0\15\11"+
    "\u4060\0\2\11\u0bfe\0\153\11\5\0\15\11\3\0\11\11\7\0\12\11"+
    "\u1766\0\125\11\1\0\107\11\1\0\2\11\2\0\1\11\2\0\2\11"+
    "\2\0\4\11\1\0\14\11\1\0\1\11\1\0\7\11\1\0\101\11"+
    "\1\0\4\11\2\0\10\11\1\0\7\11\1\0\34\11\1\0\4\11"+
    "\1\0\5\11\1\0\1\11\3\0\7\11\1\0\u0154\11\2\0\31\11"+
    "\1\0\31\11\1\0\37\11\1\0\31\11\1\0\37\11\1\0\31\11"+
    "\1\0\37\11\1\0\31\11\1\0\37\11\1\0\31\11\1\0\10\11"+
    "\2\0\62\15\u1000\0\305\11\u053b\0\4\11\1\0\33\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\1\0\12\11\1\0\4\11\1\0\1\11"+
    "\1\0\1\11\6\0\1\11\4\0\1\11\1\0\1\11\1\0\1\11"+
    "\1\0\3\11\1\0\2\11\1\0\1\11\2\0\1\11\1\0\1\11"+
    "\1\0\1\11\1\0\1\11\1\0\1\11\1\0\2\11\1\0\1\11"+
    "\2\0\4\11\1\0\7\11\1\0\4\11\1\0\4\11\1\0\1\11"+
    "\1\0\12\11\1\0\21\11\5\0\3\11\1\0\5\11\1\0\21\11"+
    "\u1144\0\ua6d7\11\51\0\u1035\11\13\0\336\11\2\0\u1682\11\u295e\0\u021e\11"+
    "\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05f0\0";

  /** 
   * Translates characters to character classes
   */
  private static final int ZZ_SX = 0x0700;
  private static final int ZZ_MX = 0x10000;
  private static final int ZZ_LX = 0x110000;
  private static char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED, ZZ_SX);
  private static class M { static final char [] MAP = zzUnpackCMap(ZZ_CMAP_PACKED, ZZ_MX); }
  private static class L { static final char [] MAP = zzUnpackCMap(ZZ_CMAP_PACKED, ZZ_LX); }

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\13\0\1\1\10\0\1\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\2\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\2\32\1\33\1\34\1\35"+
    "\1\33\1\36\1\37\1\40\1\12\1\41\1\42\1\43"+
    "\1\2\1\44\1\45\1\24\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\26\1\54\1\55\1\56\1\57\3\56"+
    "\1\26\1\56\1\26\1\56\1\60\1\61\2\0\1\62"+
    "\1\63\1\64\1\65\1\66\1\67\1\70\1\71\1\72"+
    "\1\12\1\72\1\73\2\74\1\75\1\76\1\12\1\77"+
    "\1\100\1\101\1\102\1\103\1\104\1\105\1\12\1\106"+
    "\1\107\1\110\1\111\1\112\1\113\1\114\1\115\1\116"+
    "\1\117\1\120\1\121\1\0\1\122\2\26\1\123\2\60"+
    "\1\124\1\0\1\125\1\126\1\127\1\130\1\0\1\131"+
    "\1\132\1\133\1\0\1\134\4\0\1\135\1\136\1\137"+
    "\1\77\1\140\1\141\1\142\1\143\2\144\1\145\1\146"+
    "\1\147\1\150\1\151\1\152\1\153\1\154\1\0\1\155"+
    "\1\156\1\0\1\157\2\0\1\77\1\160\1\143\2\144"+
    "\1\161\1\162\1\143\1\163\1\164";

  private static int [] zzUnpackAction() {
    int [] result = new int[179];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\374\0\u013b\0\u017a\0\u01b9"+
    "\0\u01f8\0\u0237\0\u0276\0\u02b5\0\u02f4\0\u0333\0\u0372\0\u03b1"+
    "\0\u03f0\0\u042f\0\u046e\0\u04ad\0\u04ec\0\u04ec\0\u052b\0\u04ec"+
    "\0\u056a\0\u04ec\0\u05a9\0\u04ec\0\u05e8\0\u04ec\0\u04ec\0\u04ec"+
    "\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u0627\0\u04ec"+
    "\0\u04ec\0\u0666\0\u06a5\0\u04ec\0\u04ec\0\u04ec\0\u0627\0\u04ec"+
    "\0\u06e4\0\u04ec\0\u0723\0\u04ec\0\u0762\0\u04ec\0\u07a1\0\u04ec"+
    "\0\u04ec\0\u04ec\0\u07e0\0\u04ec\0\u04ec\0\u081f\0\u04ec\0\u04ec"+
    "\0\u04ec\0\u085e\0\u089d\0\u04ec\0\u08dc\0\u04ec\0\u04ec\0\u04ec"+
    "\0\u04ec\0\u091b\0\u095a\0\u0999\0\u09d8\0\u0a17\0\u0a56\0\u0a95"+
    "\0\u0ad4\0\u0b13\0\u0b52\0\u0b91\0\u04ec\0\u04ec\0\u04ec\0\u0bd0"+
    "\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u0c0f\0\u0c4e\0\u04ec\0\u04ec"+
    "\0\u0c8d\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u0ccc\0\u04ec\0\u0d0b"+
    "\0\u0d4a\0\u0d89\0\u04ec\0\u04ec\0\u0dc8\0\u04ec\0\u04ec\0\u04ec"+
    "\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec"+
    "\0\u04ec\0\u0e07\0\u04ec\0\u0e46\0\u04ec\0\u04ec\0\u04ec\0\u0e85"+
    "\0\u04ec\0\u0ec4\0\u0f03\0\u04ec\0\u04ec\0\u04ec\0\u0f42\0\u04ec"+
    "\0\u04ec\0\u04ec\0\u0f81\0\u04ec\0\u0fc0\0\u0fff\0\u103e\0\u107d"+
    "\0\u04ec\0\u04ec\0\u04ec\0\u10bc\0\u04ec\0\u10fb\0\u04ec\0\u113a"+
    "\0\u1179\0\u11b8\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec"+
    "\0\u04ec\0\u04ec\0\u11f7\0\u04ec\0\u04ec\0\u1236\0\u04ec\0\u1275"+
    "\0\u12b4\0\u04ec\0\u04ec\0\u12f3\0\u1332\0\u04ec\0\u04ec\0\u04ec"+
    "\0\u1371\0\u04ec\0\u04ec";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[179];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\3\25\1\36\1\25\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\35\25\1\45\10\25\1\46\3\25\1\45"+
    "\10\25\1\47\66\25\5\50\1\51\3\50\1\52\11\50"+
    "\1\44\23\52\1\50\3\52\4\50\2\52\1\50\1\52"+
    "\2\50\2\52\4\50\1\52\10\50\1\51\7\50\1\53"+
    "\31\50\1\53\3\50\3\53\1\54\20\50\23\0\1\55"+
    "\53\0\10\56\1\57\66\56\6\60\1\61\1\62\1\63"+
    "\3\60\1\64\44\60\1\64\14\60\1\64\6\25\1\65"+
    "\1\66\1\67\2\25\1\70\1\71\44\25\1\72\7\25"+
    "\1\73\1\74\3\25\1\72\4\50\1\75\3\50\1\76"+
    "\21\50\1\77\1\50\1\77\2\50\1\77\2\50\1\77"+
    "\1\50\1\77\13\50\1\77\5\50\1\77\14\50\1\75"+
    "\3\50\1\76\66\50\3\100\1\101\5\100\1\102\1\100"+
    "\1\103\10\100\23\102\1\100\3\102\4\100\2\102\1\100"+
    "\1\102\2\100\2\102\1\104\3\100\1\102\3\100\76\14"+
    "\1\0\10\100\3\105\3\100\1\105\5\100\23\105\1\100"+
    "\3\105\4\100\2\105\1\100\1\105\2\100\2\105\4\100"+
    "\1\105\1\106\12\100\3\105\3\100\1\105\5\100\23\105"+
    "\1\100\3\105\4\100\2\105\1\100\1\105\1\100\1\107"+
    "\2\105\4\100\1\105\6\100\1\101\4\100\3\105\3\100"+
    "\1\105\5\100\23\105\1\100\3\105\4\100\2\105\1\100"+
    "\1\105\2\100\2\105\4\100\1\105\6\100\1\101\4\100"+
    "\3\105\2\100\1\53\1\105\5\100\23\105\1\53\3\105"+
    "\3\53\1\100\2\105\1\100\1\105\2\100\2\105\4\100"+
    "\1\105\3\100\11\110\1\52\11\110\1\44\23\52\1\110"+
    "\3\52\4\110\2\52\1\110\1\52\1\111\1\110\2\52"+
    "\1\112\3\110\1\52\1\111\2\110\1\113\1\114\7\113"+
    "\1\115\12\113\23\115\1\113\3\115\4\113\2\115\1\113"+
    "\1\115\2\113\2\115\4\113\1\115\3\113\11\116\1\117"+
    "\12\116\23\117\1\116\3\117\4\116\2\117\1\116\1\117"+
    "\2\116\2\117\1\116\1\120\2\116\1\117\3\116\4\0"+
    "\1\121\210\0\1\122\74\0\1\123\31\0\1\123\3\0"+
    "\3\123\1\124\43\0\1\125\53\0\1\126\3\127\1\130"+
    "\1\131\1\127\1\126\1\127\2\126\1\132\1\133\1\126"+
    "\6\127\2\134\1\135\1\136\3\137\3\140\1\141\2\142"+
    "\2\143\3\144\1\145\1\146\1\147\1\150\1\151\1\152"+
    "\2\146\1\126\1\153\1\154\1\133\1\155\2\126\1\140"+
    "\1\145\4\126\1\145\2\126\1\133\45\0\1\156\33\0"+
    "\2\52\5\0\5\52\6\0\32\52\1\0\2\52\1\0"+
    "\1\52\2\0\2\52\4\0\1\52\20\0\1\53\31\0"+
    "\1\53\3\0\3\53\22\0\1\157\21\0\1\160\43\0"+
    "\1\161\1\157\15\0\1\162\13\0\1\163\24\0\1\164"+
    "\27\0\1\165\21\0\1\166\43\0\2\165\6\0\6\126"+
    "\3\127\2\126\1\132\1\167\7\126\3\134\4\145\3\140"+
    "\1\141\2\142\2\143\3\144\1\145\1\146\1\147\1\150"+
    "\1\151\1\152\2\146\1\126\1\153\1\154\1\167\1\145"+
    "\2\126\2\145\4\126\1\145\2\126\1\167\71\0\1\170"+
    "\5\0\6\126\1\127\1\126\1\127\2\126\1\132\10\126"+
    "\2\134\5\145\3\140\1\141\2\142\2\143\3\144\1\145"+
    "\1\146\1\147\1\150\1\151\1\152\2\146\1\126\1\153"+
    "\1\154\1\126\1\145\2\126\2\145\4\126\1\145\3\126"+
    "\11\0\1\102\12\0\23\102\1\0\3\102\4\0\2\102"+
    "\1\0\1\102\2\0\2\102\4\0\1\102\14\0\1\103"+
    "\12\0\23\103\1\0\3\103\4\0\2\103\1\0\1\103"+
    "\2\0\2\103\4\0\1\103\13\0\7\105\5\0\32\105"+
    "\1\0\2\105\1\0\1\105\2\0\2\105\4\0\1\105"+
    "\12\0\1\171\70\0\1\172\76\0\1\172\5\0\1\173"+
    "\70\0\1\172\7\0\1\174\1\0\1\174\1\0\1\175"+
    "\6\0\23\174\1\175\3\174\3\175\1\0\2\174\1\0"+
    "\1\174\2\0\2\174\4\0\1\174\73\0\1\172\10\0"+
    "\2\52\5\0\5\52\6\0\32\52\1\0\2\52\1\0"+
    "\1\52\2\0\2\52\1\0\1\172\2\0\1\52\12\0"+
    "\1\176\60\0\1\172\13\0\1\177\17\0\2\200\1\0"+
    "\1\200\4\0\3\200\5\0\3\200\3\0\3\200\23\0"+
    "\1\201\37\0\1\202\20\0\1\203\1\204\2\0\1\205"+
    "\1\206\1\0\1\207\1\0\1\210\1\211\6\0\1\212"+
    "\7\0\1\123\31\0\1\123\3\0\3\123\1\213\25\0"+
    "\1\214\7\0\1\215\31\0\1\215\3\0\3\215\36\0"+
    "\1\216\31\0\1\216\3\0\3\216\1\217\24\0\1\220"+
    "\155\0\1\221\1\222\12\0\77\223\47\0\1\224\3\0"+
    "\3\224\25\0\1\225\20\0\2\226\1\0\1\226\4\0"+
    "\3\226\5\0\3\226\3\0\3\226\25\0\1\227\20\0"+
    "\2\230\1\0\1\230\4\0\3\230\5\0\3\230\3\0"+
    "\3\230\74\0\1\231\1\232\1\231\104\0\1\233\1\234"+
    "\21\0\1\235\100\0\1\174\1\0\1\174\1\0\1\175"+
    "\6\0\23\174\1\175\3\174\3\175\1\0\2\174\1\0"+
    "\1\174\2\0\2\174\4\0\1\174\10\0\1\236\17\0"+
    "\2\200\1\0\1\200\4\0\3\200\5\0\3\200\3\0"+
    "\3\200\104\0\1\237\4\0\1\240\76\0\1\241\4\0"+
    "\1\242\1\0\3\243\1\0\73\243\5\0\1\212\7\0"+
    "\1\213\31\0\1\213\3\0\3\213\26\0\1\244\7\0"+
    "\1\215\31\0\1\215\3\0\3\215\26\0\1\245\7\0"+
    "\1\216\31\0\1\216\3\0\3\216\1\246\25\0\1\247"+
    "\7\0\1\250\31\0\1\250\3\0\3\250\50\0\1\251"+
    "\116\0\1\252\3\0\3\252\46\0\2\253\1\0\1\253"+
    "\4\0\3\253\5\0\3\253\3\0\3\253\46\0\2\254"+
    "\1\0\1\254\4\0\3\254\5\0\3\254\3\0\3\254"+
    "\74\0\3\255\74\0\3\256\21\0\3\243\1\257\73\243"+
    "\5\0\1\245\7\0\1\246\31\0\1\246\3\0\3\246"+
    "\26\0\1\260\7\0\1\250\31\0\1\250\3\0\3\250"+
    "\26\0\1\137\116\0\2\261\1\0\1\261\4\0\3\261"+
    "\5\0\3\261\3\0\3\261\74\0\3\262\46\0\2\263"+
    "\1\0\1\263\4\0\3\263\5\0\3\263\3\0\3\263"+
    "\21\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[5040];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\13\0\1\1\10\0\2\11\1\1\1\11\1\1\1\11"+
    "\1\1\1\11\1\1\11\11\1\1\2\11\2\1\3\11"+
    "\1\1\1\11\1\1\1\11\1\1\1\11\1\1\1\11"+
    "\1\1\3\11\1\1\2\11\1\1\3\11\2\1\1\11"+
    "\1\1\4\11\11\1\2\0\3\11\1\1\4\11\2\1"+
    "\2\11\1\1\4\11\1\1\1\11\3\1\2\11\1\1"+
    "\14\11\1\0\1\11\1\1\3\11\1\1\1\11\1\0"+
    "\1\1\3\11\1\0\3\11\1\0\1\11\4\0\3\11"+
    "\1\1\1\11\1\1\1\11\3\1\10\11\1\0\2\11"+
    "\1\0\1\11\2\0\2\11\2\1\3\11\1\1\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[179];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    // This adds support for nested states. I'm no JFlex pro, so maybe this is overkill, but it works quite well.
    final IntArrayList states = new IntArrayList();

    // This was an idea to use the regex implementation for XML schema regexes (which use a slightly different syntax)
    // as well, but is currently unfinished as it requires to tweak more places than just the lexer.
    private boolean xmlSchemaMode;

    int capturingGroupCount = 0;

    private Boolean allowDanglingMetacharacters;
    private boolean allowOmitNumbersInQuantifiers;
    private boolean allowOmitBothNumbersInQuantifiers;
    private boolean allowNestedCharacterClasses;
    private boolean allowOctalNoLeadingZero;
    private boolean allowHexDigitClass;
    private boolean allowEmptyCharacterClass;
    private boolean allowHorizontalWhitespaceClass;
    private boolean allowPosixBracketExpressions;
    private boolean allowTransformationEscapes;
    private boolean allowExtendedUnicodeCharacter;
    private boolean allowOneHexCharEscape;
    private boolean allowMysqlBracketExpressions;
    private int maxOctal = 0777;
    private int minOctalDigits = 1;
    private boolean whitespaceInClass;

    _RegExLexer(EnumSet<RegExpCapability> capabilities) {
      this((java.io.Reader)null);
      this.xmlSchemaMode = capabilities.contains(XML_SCHEMA_MODE);
      if (capabilities.contains(DANGLING_METACHARACTERS)) this.allowDanglingMetacharacters = Boolean.TRUE;
      if (capabilities.contains(NO_DANGLING_METACHARACTERS)) this.allowDanglingMetacharacters = Boolean.FALSE;
      this.allowOmitNumbersInQuantifiers = capabilities.contains(OMIT_NUMBERS_IN_QUANTIFIERS);
      this.allowOmitBothNumbersInQuantifiers = capabilities.contains(OMIT_BOTH_NUMBERS_IN_QUANTIFIERS);
      this.allowNestedCharacterClasses = capabilities.contains(NESTED_CHARACTER_CLASSES);
      this.allowOctalNoLeadingZero = capabilities.contains(OCTAL_NO_LEADING_ZERO);
      this.commentMode = capabilities.contains(COMMENT_MODE);
      this.allowHexDigitClass = capabilities.contains(ALLOW_HEX_DIGIT_CLASS);
      this.allowHorizontalWhitespaceClass = capabilities.contains(ALLOW_HORIZONTAL_WHITESPACE_CLASS);
      this.allowEmptyCharacterClass = capabilities.contains(ALLOW_EMPTY_CHARACTER_CLASS);
      this.allowPosixBracketExpressions = capabilities.contains(POSIX_BRACKET_EXPRESSIONS);
      this.allowTransformationEscapes = capabilities.contains(TRANSFORMATION_ESCAPES);
      this.allowMysqlBracketExpressions = capabilities.contains(MYSQL_BRACKET_EXPRESSIONS);
      if (capabilities.contains(MAX_OCTAL_177)) {
        maxOctal = 0177;
      }
      else if (capabilities.contains(MAX_OCTAL_377)) {
        maxOctal = 0377;
      }
      if (capabilities.contains(MIN_OCTAL_2_DIGITS)) {
        minOctalDigits = 2;
      }
      else if (capabilities.contains(MIN_OCTAL_3_DIGITS)) {
        minOctalDigits = 3;
      }
      this.allowExtendedUnicodeCharacter = capabilities.contains(EXTENDED_UNICODE_CHARACTER);
      this.allowOneHexCharEscape = capabilities.contains(ONE_HEX_CHAR_ESCAPE);
      this.whitespaceInClass = capabilities.contains(WHITESPACE_IN_CLASS);
    }

    private void yypushstate(int state) {
        states.add(yystate());
        yybegin(state);
    }

    private void yypopstate() {
        final int state = states.remove(states.size() - 1);
        yybegin(state);
    }

    private void handleOptions() {
      final String o = yytext().toString();
      if (o.contains("x")) {
        commentMode = !o.startsWith("-");
      }
    }

    // tracks whether the lexer is in comment mode, i.e. whether whitespace is not significant and whether to ignore
    // text after '#' till EOL
    boolean commentMode = false;


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _RegExLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed, int limit) {
    char [] map = new char[limit];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2590 && j < limit) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0 && j < limit);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          if (zzInput >= zzCMapL.length) ZZ_CMAP = zzCMapL = zzInput >= ZZ_MX ? L.MAP : M.MAP;
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { yypopstate(); return RegExpTT.COMMENT;
            }
          case 117: break;
          case 2: 
            { return RegExpTT.CHARACTER;
            }
          case 118: break;
          case 3: 
            { return RegExpTT.DOT;
            }
          case 119: break;
          case 4: 
            { capturingGroupCount++; return RegExpTT.GROUP_BEGIN;
            }
          case 120: break;
          case 5: 
            { return RegExpTT.GROUP_END;
            }
          case 121: break;
          case 6: 
            { if (allowDanglingMetacharacters != Boolean.TRUE) { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; } return RegExpTT.CHARACTER;
            }
          case 122: break;
          case 7: 
            { return (allowDanglingMetacharacters != Boolean.FALSE) ? RegExpTT.CHARACTER : RegExpTT.RBRACE;
            }
          case 123: break;
          case 8: 
            { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN;
            }
          case 124: break;
          case 9: 
            { return allowDanglingMetacharacters == Boolean.FALSE ? RegExpTT.CLASS_END : RegExpTT.CHARACTER;
            }
          case 125: break;
          case 10: 
            { return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            }
          case 126: break;
          case 11: 
            { return commentMode ? com.intellij.psi.TokenType.WHITE_SPACE : RegExpTT.CHARACTER;
            }
          case 127: break;
          case 12: 
            { return RegExpTT.DOLLAR;
            }
          case 128: break;
          case 13: 
            { return RegExpTT.QUEST;
            }
          case 129: break;
          case 14: 
            { return RegExpTT.STAR;
            }
          case 130: break;
          case 15: 
            { return RegExpTT.PLUS;
            }
          case 131: break;
          case 16: 
            { return RegExpTT.UNION;
            }
          case 132: break;
          case 17: 
            { return RegExpTT.CARET;
            }
          case 133: break;
          case 18: 
            { return commentMode ? com.intellij.psi.TokenType.WHITE_SPACE : RegExpTT.CTRL_CHARACTER;
            }
          case 134: break;
          case 19: 
            { if (commentMode) { yypushstate(COMMENT); } else return RegExpTT.CHARACTER;
            }
          case 135: break;
          case 20: 
            { yypopstate(); yypushback(1);
            }
          case 136: break;
          case 21: 
            { yypopstate(); return RegExpTT.RBRACE;
            }
          case 137: break;
          case 22: 
            { return RegExpTT.NAME;
            }
          case 138: break;
          case 23: 
            { return RegExpTT.NUMBER;
            }
          case 139: break;
          case 24: 
            { return RegExpTT.COMMA;
            }
          case 140: break;
          case 25: 
            { yybegin(CLASS1); return RegExpTT.CARET;
            }
          case 141: break;
          case 26: 
            { states.set(states.size() - 1, CLASS2); return RegExpTT.CHARACTER;
            }
          case 142: break;
          case 27: 
            { yypushback(1); yybegin(CLASS2);
            }
          case 143: break;
          case 28: 
            { yybegin(CLASS2); if (allowNestedCharacterClasses) { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN; } return RegExpTT.CHARACTER;
            }
          case 144: break;
          case 29: 
            { if (allowEmptyCharacterClass) { yypopstate(); return RegExpTT.CLASS_END; } yybegin(CLASS2); return RegExpTT.CHARACTER;
            }
          case 145: break;
          case 30: 
            { if (commentMode && whitespaceInClass) return com.intellij.psi.TokenType.WHITE_SPACE; yypushback(1); yybegin(CLASS2);
            }
          case 146: break;
          case 31: 
            { if (allowNestedCharacterClasses) { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN; } return RegExpTT.CHARACTER;
            }
          case 147: break;
          case 32: 
            { yypopstate(); return RegExpTT.CLASS_END;
            }
          case 148: break;
          case 33: 
            { return RegExpTT.MINUS;
            }
          case 149: break;
          case 34: 
            { return (commentMode && whitespaceInClass) ? com.intellij.psi.TokenType.WHITE_SPACE : RegExpTT.CHARACTER;
            }
          case 150: break;
          case 35: 
            { return (commentMode && whitespaceInClass) ? com.intellij.psi.TokenType.WHITE_SPACE : RegExpTT.CTRL_CHARACTER;
            }
          case 151: break;
          case 36: 
            { if (commentMode && whitespaceInClass) yypushstate(COMMENT); else return RegExpTT.CHARACTER;
            }
          case 152: break;
          case 37: 
            { yypopstate(); yypushstate(EMBRACED); return RegExpTT.LBRACE;
            }
          case 153: break;
          case 38: 
            { yypopstate(); return RegExpTT.CATEGORY_SHORT_HAND;
            }
          case 154: break;
          case 39: 
            { yybegin(YYINITIAL); yypushback(1);
            }
          case 155: break;
          case 40: 
            { yybegin(YYINITIAL); return RegExpTT.GROUP_END;
            }
          case 156: break;
          case 41: 
            { handleOptions(); return RegExpTT.OPTIONS_ON;
            }
          case 157: break;
          case 42: 
            { handleOptions(); return RegExpTT.OPTIONS_OFF;
            }
          case 158: break;
          case 43: 
            { yybegin(YYINITIAL); return RegExpTT.COLON;
            }
          case 159: break;
          case 44: 
            { yybegin(YYINITIAL); return RegExpTT.GT;
            }
          case 160: break;
          case 45: 
            { yybegin(YYINITIAL); return RegExpTT.QUOTE;
            }
          case 161: break;
          case 46: 
            { return RegExpTT.BAD_CHARACTER;
            }
          case 162: break;
          case 47: 
            { return allowMysqlBracketExpressions ? RegExpTT.NAME : RegExpTT.BAD_CHARACTER;
            }
          case 163: break;
          case 48: 
            { yypopstate(); return (yycharat(-1) == 'u') ? StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN : RegExpTT.BAD_HEX_VALUE;
            }
          case 164: break;
          case 49: 
            { yybegin(OPTIONS); return RegExpTT.SET_OPTIONS;
            }
          case 165: break;
          case 50: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { yypushstate(NEGATED_CLASS); return RegExpTT.CLASS_BEGIN;
            }
          case 166: break;
          case 51: 
            { return RegExpTT.REDUNDANT_ESCAPE;
            }
          case 167: break;
          case 52: 
            { return RegExpTT.ESC_CHARACTER;
            }
          case 168: break;
          case 53: 
            { return (allowDanglingMetacharacters != Boolean.TRUE) ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          case 169: break;
          case 54: 
            { return (allowDanglingMetacharacters == Boolean.FALSE) ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          case 170: break;
          case 55: 
            { return (yystate() == CLASS2) ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          case 171: break;
          case 56: 
            { return commentMode ? RegExpTT.ESC_CTRL_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          case 172: break;
          case 57: 
            { return RegExpTT.ESC_CTRL_CHARACTER;
            }
          case 173: break;
          case 58: 
            { return RegExpTT.BOUNDARY;
            }
          case 174: break;
          case 59: 
            { return RegExpTT.CHAR_CLASS;
            }
          case 175: break;
          case 60: 
            { if (xmlSchemaMode) return RegExpTT.CHAR_CLASS; else return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            }
          case 176: break;
          case 61: 
            { yypushstate(PROP); return RegExpTT.PROPERTY;
            }
          case 177: break;
          case 62: 
            { return allowTransformationEscapes ? RegExpTT.CHAR_CLASS : StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            }
          case 178: break;
          case 63: 
            { String text = yytext().toString().substring(1);
                                if (allowOctalNoLeadingZero) {
                                  if (Integer.parseInt(text) <= capturingGroupCount && yystate() != CLASS2) return RegExpTT.BACKREF;
                                  int i = 0;
                                  int value = 0;
                                  for (; i < text.length(); i++) {
                                    char c = text.charAt(i);
                                    if (c > '7') break;
                                    value = value * 8 + (c - '0');
                                  }
                                  if (i > 0) {
                                    yypushback(text.length() - i);
                                    if (value > maxOctal) {
                                      yypushback(1);
                                      return RegExpTT.BAD_OCT_VALUE;
                                    }
                                    if (minOctalDigits > i && yystate() != CLASS2) {
                                      return RegExpTT.BAD_OCT_VALUE;
                                    }
                                    return RegExpTT.OCT_CHAR;
                                  }
                                  return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                                }
                                else {
                                  if (yystate() == CLASS2) {
                                    yypushback(yylength() - 2);
                                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                                  }
                                  /* java.util.regex.Pattern says about backrefs:
                                      "In this class, \1 through \9 are always interpreted as back references,
                                      and a larger number is accepted as a back reference if at least that many
                                      subexpressions exist at that point in the regular expression, otherwise the
                                      parser will drop digits until the number is smaller or equal to the existing
                                      number of groups or it is one digit."
                                  */
                                  while (yylength() > 2 && Integer.parseInt(yytext().toString().substring(1)) > capturingGroupCount) {
                                    yypushback(1);
                                  }
                                  return RegExpTT.BACKREF;
                                }
            }
          case 179: break;
          case 64: 
            { yypushstate(QUOTED); return RegExpTT.QUOTE_BEGIN;
            }
          case 180: break;
          case 65: 
            { return RegExpTT.BAD_HEX_VALUE;
            }
          case 181: break;
          case 66: 
            { return allowTransformationEscapes ? RegExpTT.CHAR_CLASS : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
          case 182: break;
          case 67: 
            { return (allowOctalNoLeadingZero ? RegExpTT.OCT_CHAR : RegExpTT.BAD_OCT_VALUE);
            }
          case 183: break;
          case 68: 
            { return (allowHexDigitClass || allowHorizontalWhitespaceClass ? RegExpTT.CHAR_CLASS : StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN);
            }
          case 184: break;
          case 69: 
            { yypushstate(NAMED); return RegExpTT.NAMED_CHARACTER;
            }
          case 185: break;
          case 70: 
            { yypopstate(); return RegExpTT.QUOTE_END;
            }
          case 186: break;
          case 71: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { yybegin(CLASS2); if (allowMysqlBracketExpressions) { yypushback(1); } else if (allowNestedCharacterClasses) { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN; } else { return RegExpTT.CHARACTER; }
            }
          case 187: break;
          case 72: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { yybegin(CLASS2); if (allowNestedCharacterClasses) { yypushstate(NEGATED_CLASS); return RegExpTT.CLASS_BEGIN; } return RegExpTT.CHARACTER;
            }
          case 188: break;
          case 73: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { yybegin(CLASS2); if (allowPosixBracketExpressions) { yypushback(1); } else if (allowNestedCharacterClasses) { yypushstate(CLASS1); return RegExpTT.CLASS_BEGIN; } else { return RegExpTT.CHARACTER; }
            }
          case 189: break;
          case 74: 
            { yybegin(CLASS2); return allowEmptyCharacterClass ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          case 190: break;
          case 75: 
            { yybegin(CLASS2); return RegExpTT.ESC_CHARACTER;
            }
          case 191: break;
          case 76: 
            { yypushstate(QUOTED_CLASS1); return RegExpTT.QUOTE_BEGIN;
            }
          case 192: break;
          case 77: 
            { char c = yycharat(1);
                          if (allowPosixBracketExpressions && c == ':') {
                            yybegin(BRACKET_EXPRESSION);
                            return RegExpTT.BRACKET_EXPRESSION_BEGIN;
                          } else if (allowMysqlBracketExpressions && c == '=') {
                            yybegin(MYSQL_CHAR_EQ_EXPRESSION);
                            return RegExpTT.MYSQL_CHAR_EQ_BEGIN;
                          } else if (allowMysqlBracketExpressions && c == '.') {
                            yybegin(MYSQL_CHAR_EXPRESSION);
                            return RegExpTT.MYSQL_CHAR_BEGIN;
                          } else {
                            yypushback(1);
                            return allowNestedCharacterClasses ? RegExpTT.CLASS_BEGIN : RegExpTT.CHARACTER;
                          }
            }
          case 193: break;
          case 78: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { if (allowNestedCharacterClasses) { yypushstate(NEGATED_CLASS); return RegExpTT.CLASS_BEGIN; } return RegExpTT.CHARACTER;
            }
          case 194: break;
          case 79: 
            { return (commentMode && whitespaceInClass) ? RegExpTT.ESC_CTRL_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          case 195: break;
          case 80: 
            { if (allowNestedCharacterClasses) return RegExpTT.ANDAND; else yypushback(1); return RegExpTT.CHARACTER;
            }
          case 196: break;
          case 81: 
            { yybegin(CLASS2); return RegExpTT.BRACKET_EXPRESSION_END;
            }
          case 197: break;
          case 82: 
            { yybegin(CLASS2); return RegExpTT.MYSQL_CHAR_END;
            }
          case 198: break;
          case 83: 
            { yybegin(CLASS2); return RegExpTT.MYSQL_CHAR_EQ_END;
            }
          case 199: break;
          case 84: 
            { yybegin(PY_COND_REF); return RegExpTT.PYTHON_COND_REF;
            }
          case 200: break;
          case 85: 
            { yybegin(NAMED_GROUP); capturingGroupCount++; return RegExpTT.RUBY_NAMED_GROUP;
            }
          case 201: break;
          case 86: 
            { yybegin(QUOTED_NAMED_GROUP); capturingGroupCount++; return RegExpTT.RUBY_QUOTED_NAMED_GROUP;
            }
          case 202: break;
          case 87: 
            { return RegExpTT.NON_CAPT_GROUP;
            }
          case 203: break;
          case 88: 
            { return RegExpTT.POS_LOOKAHEAD;
            }
          case 204: break;
          case 89: 
            { return RegExpTT.ATOMIC_GROUP;
            }
          case 205: break;
          case 90: 
            { return RegExpTT.NEG_LOOKAHEAD;
            }
          case 206: break;
          case 91: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { yypushstate(QUANTIFIER); return RegExpTT.LBRACE;
            }
          case 207: break;
          case 92: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { if (allowOmitBothNumbersInQuantifiers || allowDanglingMetacharacters != Boolean.TRUE) { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; } else return RegExpTT.CHARACTER;
            }
          case 208: break;
          case 93: 
            { yybegin(NAMED_GROUP); return RegExpTT.RUBY_NAMED_GROUP_CALL;
            }
          case 209: break;
          case 94: 
            { yybegin(QUOTED_NAMED_GROUP); return RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL;
            }
          case 210: break;
          case 95: 
            { if (xmlSchemaMode) { yypushback(1); return RegExpTT.CHAR_CLASS; } else return RegExpTT.CTRL;
            }
          case 211: break;
          case 96: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 2);
            { if (allowExtendedUnicodeCharacter) yypushstate(EMBRACED_HEX); else return RegExpTT.BAD_HEX_VALUE;
            }
          case 212: break;
          case 97: 
            { if (allowOneHexCharEscape) { return RegExpTT.HEX_CHAR; } else { yypushback(1); return RegExpTT.BAD_HEX_VALUE; }
            }
          case 213: break;
          case 98: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 2);
            { if (allowExtendedUnicodeCharacter) yypushstate(EMBRACED_HEX); else return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
          case 214: break;
          case 99: 
            { yypushback(yylength() - 2); return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
          case 215: break;
          case 100: 
            { return RegExpTT.OCT_CHAR;
            }
          case 216: break;
          case 101: 
            { yybegin(NAMED_GROUP); return RegExpTT.RUBY_NAMED_GROUP_REF;
            }
          case 217: break;
          case 102: 
            { yybegin(QUOTED_NAMED_GROUP); return RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF;
            }
          case 218: break;
          case 103: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { return RegExpTT.CHARACTER;
            }
          case 219: break;
          case 104: 
            { yypopstate(); return (yycharat(-1) == 'u') ? RegExpTT.UNICODE_CHAR : RegExpTT.HEX_CHAR;
            }
          case 220: break;
          case 105: 
            { yybegin(NAMED_GROUP); capturingGroupCount++; return RegExpTT.PYTHON_NAMED_GROUP;
            }
          case 221: break;
          case 106: 
            { yybegin(PY_NAMED_GROUP_REF); return RegExpTT.PYTHON_NAMED_GROUP_REF;
            }
          case 222: break;
          case 107: 
            { return RegExpTT.POS_LOOKBEHIND;
            }
          case 223: break;
          case 108: 
            { return RegExpTT.NEG_LOOKBEHIND;
            }
          case 224: break;
          case 109: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 1);
            { if (allowOmitNumbersInQuantifiers || allowDanglingMetacharacters != Boolean.TRUE) { yypushstate(QUANTIFIER); return RegExpTT.LBRACE; } else return RegExpTT.CHARACTER;
            }
          case 225: break;
          case 110: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 2);
            { return RegExpTT.ESC_CHARACTER;
            }
          case 226: break;
          case 111: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 2);
            { return allowOmitBothNumbersInQuantifiers ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          case 227: break;
          case 112: 
            { return RegExpTT.HEX_CHAR;
            }
          case 228: break;
          case 113: 
            { return RegExpTT.COMMENT;
            }
          case 229: break;
          case 114: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL/*, zzStartRead, zzEndRead - zzStartRead*/, zzStartRead, 2);
            { return allowOmitNumbersInQuantifiers ? RegExpTT.ESC_CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
            }
          case 230: break;
          case 115: 
            { if (allowOctalNoLeadingZero) yypushback(1); return RegExpTT.OCT_CHAR;
            }
          case 231: break;
          case 116: 
            { return RegExpTT.UNICODE_CHAR;
            }
          case 232: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
