/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.transaction.xa;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class XAExceptionTest
extends TestCase {
    public void testPublicStatics() {
        Class<?> xAExceptionClass;
        HashMap<String, Integer> thePublicStatics = new HashMap<String, Integer>();
        thePublicStatics.put("XAER_OUTSIDE", new Integer(-9));
        thePublicStatics.put("XAER_DUPID", new Integer(-8));
        thePublicStatics.put("XAER_RMFAIL", new Integer(-7));
        thePublicStatics.put("XAER_PROTO", new Integer(-6));
        thePublicStatics.put("XAER_INVAL", new Integer(-5));
        thePublicStatics.put("XAER_NOTA", new Integer(-4));
        thePublicStatics.put("XAER_RMERR", new Integer(-3));
        thePublicStatics.put("XAER_ASYNC", new Integer(-2));
        thePublicStatics.put("XA_RDONLY", new Integer(3));
        thePublicStatics.put("XA_RETRY", new Integer(4));
        thePublicStatics.put("XA_HEURMIX", new Integer(5));
        thePublicStatics.put("XA_HEURRB", new Integer(6));
        thePublicStatics.put("XA_HEURCOM", new Integer(7));
        thePublicStatics.put("XA_HEURHAZ", new Integer(8));
        thePublicStatics.put("XA_NOMIGRATE", new Integer(9));
        thePublicStatics.put("XA_RBEND", new Integer(107));
        thePublicStatics.put("XA_RBTRANSIENT", new Integer(107));
        thePublicStatics.put("XA_RBTIMEOUT", new Integer(106));
        thePublicStatics.put("XA_RBPROTO", new Integer(105));
        thePublicStatics.put("XA_RBOTHER", new Integer(104));
        thePublicStatics.put("XA_RBINTEGRITY", new Integer(103));
        thePublicStatics.put("XA_RBDEADLOCK", new Integer(102));
        thePublicStatics.put("XA_RBCOMMFAIL", new Integer(101));
        thePublicStatics.put("XA_RBROLLBACK", new Integer(100));
        thePublicStatics.put("XA_RBBASE", new Integer(100));
        try {
            xAExceptionClass = Class.forName("javax.transaction.xa.XAException");
        }
        catch (ClassNotFoundException e) {
            XAExceptionTest.fail((String)"javax.transaction.xa.XAException class not found!");
            return;
        }
        Field[] theFields = xAExceptionClass.getDeclaredFields();
        int requiredModifier = 25;
        int countPublicStatics = 0;
        Field[] fieldArray = theFields;
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field element = fieldArray[n];
            String fieldName = element.getName();
            int theMods = element.getModifiers();
            if (Modifier.isPublic(theMods) && Modifier.isStatic(theMods)) {
                try {
                    Object fieldValue = element.get(null);
                    Object expectedValue = thePublicStatics.get(fieldName);
                    if (expectedValue == null) {
                        XAExceptionTest.fail((String)("Field " + fieldName + " missing!"));
                    }
                    XAExceptionTest.assertEquals((String)("Field " + fieldName + " value mismatch: "), expectedValue, (Object)fieldValue);
                    XAExceptionTest.assertEquals((String)("Field " + fieldName + " modifier mismatch: "), (int)requiredModifier, (int)theMods);
                    ++countPublicStatics;
                }
                catch (IllegalAccessException e) {
                    XAExceptionTest.fail((String)("Illegal access to Field " + fieldName));
                }
            }
            ++n;
        }
    }

    public void testXAExceptionint() {
        int[] nArray = new int[7];
        nArray[0] = Integer.MIN_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        nArray[3] = 1856939228;
        nArray[4] = -217759650;
        nArray[5] = -1808025128;
        nArray[6] = -69857128;
        int[] init1 = nArray;
        String[] theFinalStates1 = new String[7];
        Exception[] theExceptions = new Exception[7];
        int loopCount = init1.length;
        int i = 0;
        while (i < loopCount) {
            try {
                XAException aXAException = new XAException(init1[i]);
                if (theExceptions[i] != null) {
                    XAExceptionTest.fail();
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aXAException.getMessage(), (String)theFinalStates1[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    XAExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testXAExceptionString() {
        String[] init1;
        String[] stringArray = new String[8];
        stringArray[0] = "a";
        stringArray[1] = "1";
        stringArray[2] = "valid1";
        stringArray[3] = "----";
        stringArray[4] = "&valid*";
        stringArray[6] = "";
        stringArray[7] = "\u0000";
        String[] theFinalStates1 = init1 = stringArray;
        Exception[] theExceptions = new Exception[8];
        int loopCount = init1.length;
        int i = 0;
        while (i < loopCount) {
            try {
                XAException aXAException = new XAException(init1[i]);
                if (theExceptions[i] != null) {
                    XAExceptionTest.fail();
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aXAException.getMessage(), (String)theFinalStates1[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    XAExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testXAException() {
        String[] theFinalStates1 = new String[1];
        Exception[] theExceptions = new Exception[1];
        int loopCount = 1;
        int i = 0;
        while (i < loopCount) {
            try {
                XAException aXAException = new XAException();
                if (theExceptions[i] != null) {
                    XAExceptionTest.fail();
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aXAException.getMessage(), (String)theFinalStates1[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    XAExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                XAExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testPublicFields() {
        int testerrorCode = 1;
        XAException aXAException = new XAException();
        aXAException.errorCode = testerrorCode;
        XAExceptionTest.assertEquals((String)"Public field mismatch: ", (int)aXAException.errorCode, (int)testerrorCode);
    }
}

