# -*- rpm-spec -*-
# Copyright (C) 2006 Daniel Berrange <dan@berrange.com>
#

use strict;

die unless (scalar @ARGV == 1);

my $VERSION;
open PM, 'lib/Sys/Virt/TCK.pm';
while (<PM>) {
    if (/\$VERSION\s*=\s*'(.*)'/) {
        $VERSION=$1;
    }
}

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by perl-Sys-Virt-TCK.spec.PL

%define perlvendorarch %(perl -e 'use Config; print $Config{installvendorarch}')
%define perlvendorlib %(perl -e 'use Config; print $Config{installvendorlib}')
%define perlvendorprefix %(perl -e 'use Config; print $Config{vendorprefix}')
%define perlvendorman1 %{perlvendorprefix}/share/man/man1
%define perlvendorman3 %{perlvendorprefix}/share/man/man3
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname Sys-Virt-TCK
%define _extra_release %{?extra_release:%{extra_release}}

Summary: Sys::Virt::TCK - libvirt Technology Compatibility Kit
Name: perl-%{appname}
Version: @VERSION@
Release: 1%{_extra_release}
License: GPLv2
Group: Development/Tools
Source: http://libvirt.org/sources/tck/%{appname}-v%{version}.tar.gz
Url: http://libvirt.org/
BuildRoot: %{_tmppath}/%{appname}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires: perl >= %{perlversion}
Requires: libvirt >= 0.6.2
BuildRequires: perl(accessors)
BuildRequires: perl(App::Prove)
BuildRequires: perl(Config::Record)
BuildRequires: perl(Cwd)
BuildRequires: perl(File::Spec::Functions)
BuildRequires: perl(File::Copy)
BuildRequires: perl(File::Path)
BuildRequires: perl(LWP::UserAgent)
BuildRequires: perl(IO::String)
BuildRequires: perl(IO::Uncompress::Gunzip)
BuildRequires: perl(IO::Uncompress::Bunzip2)
BuildRequires: perl(Module::Build)
BuildRequires: perl(TAP::Formatter::HTML)
BuildRequires: perl(TAP::Formatter::JUnit)
BuildRequires: perl(TAP::Harness)
BuildRequires: perl(TAP::Harness::Archive)
BuildRequires: perl(Test::Builder)
BuildRequires: perl(Test::More)
BuildRequires: perl(Sub::Uplevel)
BuildRequires: perl(Sys::Virt) >= 0.2.0
BuildRequires: perl(XML::Twig)
BuildRequires: perl(XML::Writer)
# RPM autoprovides misses these 3
Requires: perl(Test::Exception)
Requires: perl(TAP::Formatter::HTML)
Requires: perl(TAP::Formatter::JUnit)
Requires: perl(TAP::Harness::Archive)
Requires: /usr/bin/mkisofs
BuildArchitectures: noarch

%description
Sys::Virt::TCK provides an integration test suite for validating
correct operation of libvirt drivers with underlying virtualization
technology.

%prep
%setup -q -n %{appname}-v%{version}


%build
%{__perl} Build.PL installdirs=vendor
./Build

%install
rm -rf $RPM_BUILD_ROOT
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0 \
  --install_path conf=%{_sysconfdir}/libvirt-tck \
  --install_path pkgdata=%{_datadir}/libvirt-tck/tests

find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

%{_fixperms} $RPM_BUILD_ROOT/*

%__install -m 0755 -d $RPM_BUILD_ROOT%{_localstatedir}/cache/libvirt-tck

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
#%doc AUTHORS
%doc LICENSE
%doc README
#%doc INSTALL
%dir %{_sysconfdir}/libvirt-tck
%config(noreplace) %{_sysconfdir}/libvirt-tck/default.cfg
%config(noreplace) %{_sysconfdir}/libvirt-tck/ks.cfg
%{_bindir}/libvirt-tck
%dir %{_datadir}/libvirt-tck
%{_datadir}/libvirt-tck/*
%{perlvendorman1}/*
#%{perlvendorman3}/*
%{perlvendorlib}/Sys/Virt/TCK.pm
%{perlvendorlib}/Sys/Virt/TCK/
%dir %{_localstatedir}/cache/libvirt-tck

%changelog
* Fri Mar 24 2006  <berrange@redhat.com> - 0.0.1-1
- Initial build
