// license:BSD-3-Clause
// copyright-holders:David Haywood

#include "emu.h"
#include "arcompact_helper.ipp"

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                 IIII I$$$   SS SSSS    $$$        ss ssss
// SLEEP <u6>                      0010 0001 0110 1111   0000 uuuu uu11 1111
// SLEEP c                         0010 0001 0010 1111   0000 CCCC CC11 1111
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

uint32_t arcompact_device::handleop32_SLEEP(uint32_t op)
{
	// TODO: this is over simplified
	debugreg_set_ZZ();
	//fatalerror("SLEEP (%08x)", op);
	return m_pc + 4;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                 IIII I$$$   SS SSSS    $$$        ss ssss
// SWI/TRAP0                       0010 0010 0110 1111   0000 0000 0011 1111
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

uint32_t arcompact_device::handleop32_SWI(uint32_t op)
{
	fatalerror("SWI / TRAP0 (%08x)", op);
	return m_pc + 4;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                 IIII I$$$   SS SSSS    $$$        ss ssss
// SYNC                            0010 0011 0110 1111   0000 0000 0011 1111
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

uint32_t arcompact_device::handleop32_SYNC(uint32_t op)
{
	fatalerror("SYNC (%08x)", op);
	return m_pc + 4;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                 IIII I$$$   SS SSSS    $$$        ss ssss
// RTIE                            0010 0100 0110 1111   0000 0000 0011 1111
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

uint32_t arcompact_device::handleop32_RTIE(uint32_t op)
{
	fatalerror("RTIE (%08x)", op);
	return m_pc + 4;
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                                 IIII I$$$   SS SSSS    $$$        ss ssss
// BRK                             0010 0101 0110 1111   0000 0000 0011 1111
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

uint32_t arcompact_device::handleop32_BRK(uint32_t op)
{
	fatalerror("BRK (%08x)", op);
	return m_pc + 4;
}
