/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.plugins.invoker;

import java.util.Collections;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.invoker.model.BuildJob;
import org.junit.jupiter.api.Test;

import static org.mockito.Mockito.anyString;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;

/**
 * Unittest for {@link InvokerSession}
 */
class InvokerSessionTest {

    @Test
    void skipSummary() {
        Log logger = mock(Log.class);
        BuildJob skippedBuildJob = new BuildJob("minvoker-279");
        skippedBuildJob.setResult(BuildJob.Result.SKIPPED);
        InvokerSession session = new InvokerSession(Collections.singletonList(skippedBuildJob));

        session.logSummary(logger, false);

        verify(logger).warn("The following builds were skipped:");
        verify(logger).warn("*  minvoker-279");
        verify(logger, never()).error(anyString());
    }
}
