# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class RemovePolyData(PolyDataAlgorithm):
    r"""
    RemovePolyData - Removes PolyData cells from an input
    PolyData
    
    Superclass: PolyDataAlgorithm
    
    RemovePolyData is a filter that removes cells from an input
    PolyData (defined in the first input #0), and produces an output
    PolyData (which may be empty).  The cells to remove are specified
    in the following ways:
    1) a list of cell ids can be provided; 2) a list of point ids can be
       provided - any cell using one or more of the points indicated is
       removed; and 3) one or more additional PolyData inputs can be
       provided - matching cells are deleted. These three methods can be
       used in combination if desired. Point and cell attribute data
       associated with the remaining cells are copied to the output.
    
    @warning
    The filter AppendPolyData enables appending multiple input
    PolyData's together. So AppendPolyData functions as an
    approximate inverse operation to RemovePolyData.
    
    @warning
    The output point type is the same as the (first) input point type.
    
    @sa
    AppendPolyData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRemovePolyData, obj, update, **traits)
    
    exact_match = tvtk_base.false_bool_trait(desc=\
        r"""
        exact_match controls how the matching of cells when additional
        input PolyDatas are provided. When exact_match is enabled, then
        if any input0 cell Ci uses all of the point ids in cells
        specified in inputs [1,N) Cn, and the number of point ids in Ci
        == Cn, then a match occurs and the cell is marked for deletion.
        Without exact_match enabled, if Ci uses all of the points in Cn,
        even though the cell connectivity list sizes are not the same
        size, a match occurs. This can be used to perform tricks like
        marking all of the cells that use a point or edge to be deleted.
        exact_match is disabled by default since it takes a extra
        computation time.
        """
    )

    def _exact_match_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExactMatch,
                        self.exact_match_)

    def _get_cell_ids(self):
        return wrap_vtk(self._vtk_obj.GetCellIds())
    def _set_cell_ids(self, arg):
        old_val = self._get_cell_ids()
        my_arg = deref_array([arg], [['vtkIdTypeArray']])
        self._wrap_call(self._vtk_obj.SetCellIds,
                        my_arg[0])
        self.trait_property_changed('cell_ids', old_val, arg)
    cell_ids = traits.Property(_get_cell_ids, _set_cell_ids, desc=\
        r"""
        
        """
    )

    def _get_point_ids(self):
        return wrap_vtk(self._vtk_obj.GetPointIds())
    def _set_point_ids(self, arg):
        old_val = self._get_point_ids()
        my_arg = deref_array([arg], [['vtkIdTypeArray']])
        self._wrap_call(self._vtk_obj.SetPointIds,
                        my_arg[0])
        self.trait_property_changed('point_ids', old_val, arg)
    point_ids = traits.Property(_get_point_ids, _set_point_ids, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, idx:int) -> PolyData
        C++: PolyData *get_input(int idx)
        get_input(self) -> PolyData
        C++: PolyData *get_input()
        Get any input of this filter.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def remove_input_data(self, *args):
        """
        remove_input_data(self, __a:PolyData) -> None
        C++: void remove_input_data(PolyData *)
        Remove a PolyData dataset from the list of data.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveInputData, *my_args)
        return ret

    _updateable_traits_ = \
    (('exact_match', 'GetExactMatch'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'exact_match', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RemovePolyData, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RemovePolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['exact_match'], [], []),
            title='Edit RemovePolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RemovePolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

