# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Viewport(Object):
    r"""
    Viewport - abstract specification for Viewports
    
    Superclass: Object
    
    Viewport provides an abstract specification for Viewports. A
    Viewport is an object that controls the rendering process for
    objects. Rendering is the process of converting geometry, a
    specification for lights, and a camera view into an image.
    Viewport also performs coordinate transformation between world
    coordinates, view coordinates (the computer graphics rendering
    coordinate system), and display coordinates (the actual screen
    coordinates on the display device). Certain advanced rendering
    features such as two-sided lighting can also be controlled.
    
    @sa
    Window Renderer
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkViewport, obj, update, **traits)
    
    gradient_background = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get whether this viewport should have a gradient background
        using the Background (bottom) and Background2 (top) colors.
        Default is off.
        """
    )

    def _gradient_background_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGradientBackground,
                        self.gradient_background_)

    gradient_environmental_bg = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get whether this viewport should enable the gradient
        environment using the environmental_bg (bottom) and
        environmental_bg2 (top) colors. Note this is currently ignored
        outside of ray_tracing. Default is off.
        """
    )

    def _gradient_environmental_bg_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGradientEnvironmentalBG,
                        self.gradient_environmental_bg_)

    aspect = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(1.0, 1.0), cols=2, desc=\
        r"""
        Set the aspect ratio of the rendered image. This is computed
        automatically and should not be set by the user.
        """
    )

    def _aspect_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAspect,
                        self.aspect)

    background = tvtk_base.vtk_color_trait((0.0, 0.0, 0.0), desc=\
        r"""
        Set/Get the background color of the rendering screen using an rgb
        color specification.
        """
    )

    def _background_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackground,
                        self.background, False)

    background2 = tvtk_base.vtk_color_trait((0.2, 0.2, 0.2), desc=\
        r"""
        Set/Get the second background color of the rendering screen for
        gradient backgrounds using an rgb color specification.
        """
    )

    def _background2_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackground2,
                        self.background2, False)

    background_alpha = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the alpha value used to fill the background with. By
        default, this is set to 0.0.
        """
    )

    def _background_alpha_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackgroundAlpha,
                        self.background_alpha)

    display_point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/get a point location in display (or screen) coordinates. The
        lower left corner of the window is the origin and y increases as
        you go up the screen.
        """
    )

    def _display_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDisplayPoint,
                        self.display_point)

    environmental_bg = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/Get the constant environmental color using an rgb color
        specification. Note this is currently ignored outside of
        ray_tracing.
        """
    )

    def _environmental_bg_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnvironmentalBG,
                        self.environmental_bg)

    environmental_bg2 = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.2, 0.2, 0.2), cols=3, desc=\
        r"""
        Set/Get the second environmental gradient color using an rgb
        color specification. Note this is currently ignored outside of
        ray_tracing.
        """
    )

    def _environmental_bg2_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnvironmentalBG2,
                        self.environmental_bg2)

    pixel_aspect = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(1.0, 1.0), cols=2, desc=\
        r"""
        Set the aspect ratio of a pixel in the rendered image. This
        factor permits the image to rendered anisotropically (i.e.,
        stretched in one direction or the other).
        """
    )

    def _pixel_aspect_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPixelAspect,
                        self.pixel_aspect)

    view_point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Specify a point location in view coordinates. The origin is in
        the middle of the viewport and it extends from -1 to 1 in all
        three dimensions.
        """
    )

    def _view_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetViewPoint,
                        self.view_point)

    viewport = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 1.0, 1.0), cols=3, desc=\
        r"""
        Specify the viewport for the Viewport to draw in the rendering
        window. Coordinates are expressed as (xmin,ymin,xmax,ymax), where
        each coordinate is 0 <= coordinate <= 1.0.
        """
    )

    def _viewport_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetViewport,
                        self.viewport)

    world_point = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Specify a point location in world coordinates. This method takes
        homogeneous coordinates.
        """
    )

    def _world_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWorldPoint,
                        self.world_point)

    def _get_actors2d(self):
        return wrap_vtk(self._vtk_obj.GetActors2D())
    actors2d = traits.Property(_get_actors2d, desc=\
        r"""
        
        """
    )

    def _get_center(self):
        return self._vtk_obj.GetCenter()
    center = traits.Property(_get_center, desc=\
        r"""
        Return the center of this viewport in display coordinates.
        """
    )

    def _get_origin(self):
        return self._vtk_obj.GetOrigin()
    origin = traits.Property(_get_origin, desc=\
        r"""
        
        """
    )

    def _get_pick_height(self):
        return self._vtk_obj.GetPickHeight()
    pick_height = traits.Property(_get_pick_height, desc=\
        r"""
        
        """
    )

    def _get_pick_result_props(self):
        return wrap_vtk(self._vtk_obj.GetPickResultProps())
    pick_result_props = traits.Property(_get_pick_result_props, desc=\
        r"""
        
        """
    )

    def _get_pick_width(self):
        return self._vtk_obj.GetPickWidth()
    pick_width = traits.Property(_get_pick_width, desc=\
        r"""
        
        """
    )

    def _get_pick_x(self):
        return self._vtk_obj.GetPickX()
    pick_x = traits.Property(_get_pick_x, desc=\
        r"""
        Methods used to return the pick (x,y) in local display
        coordinates (i.e., it's that same as selectionX and selectionY).
        """
    )

    def _get_pick_x1(self):
        return self._vtk_obj.GetPickX1()
    pick_x1 = traits.Property(_get_pick_x1, desc=\
        r"""
        
        """
    )

    def _get_pick_x2(self):
        return self._vtk_obj.GetPickX2()
    pick_x2 = traits.Property(_get_pick_x2, desc=\
        r"""
        
        """
    )

    def _get_pick_y(self):
        return self._vtk_obj.GetPickY()
    pick_y = traits.Property(_get_pick_y, desc=\
        r"""
        
        """
    )

    def _get_pick_y1(self):
        return self._vtk_obj.GetPickY1()
    pick_y1 = traits.Property(_get_pick_y1, desc=\
        r"""
        
        """
    )

    def _get_pick_y2(self):
        return self._vtk_obj.GetPickY2()
    pick_y2 = traits.Property(_get_pick_y2, desc=\
        r"""
        
        """
    )

    def _get_picked_z(self):
        return self._vtk_obj.GetPickedZ()
    picked_z = traits.Property(_get_picked_z, desc=\
        r"""
        Return the Z value for the last picked Prop.
        """
    )

    def _get_size(self):
        return self._vtk_obj.GetSize()
    size = traits.Property(_get_size, desc=\
        r"""
        Get the size and origin of the viewport in display coordinates.
        Note: if the window has not yet been realized, get_size() and
        get_origin() return (0,0).
        """
    )

    def get_tiled_size(self, *args):
        """
        get_tiled_size(self, width:[int, ...], height:[int, ...]) -> None
        C++: void get_tiled_size(int *width, int *height)"""
        ret = self._wrap_call(self._vtk_obj.GetTiledSize, *args)
        return ret

    def get_tiled_size_and_origin(self, *args):
        """
        get_tiled_size_and_origin(self, width:[int, ...], height:[int, ...],
            lowerLeftX:[int, ...], lowerLeftY:[int, ...]) -> None
        C++: virtual void get_tiled_size_and_origin(int *width, int *height,
            int *lowerLeftX, int *lowerLeftY)"""
        ret = self._wrap_call(self._vtk_obj.GetTiledSizeAndOrigin, *args)
        return ret

    def _get_vtk_window(self):
        return wrap_vtk(self._vtk_obj.GetVTKWindow())
    vtk_window = traits.Property(_get_vtk_window, desc=\
        r"""
        Return the Window that owns this Viewport.
        """
    )

    def _get_view_props(self):
        return wrap_vtk(self._vtk_obj.GetViewProps())
    view_props = traits.Property(_get_view_props, desc=\
        r"""
        Return any props in this viewport.
        """
    )

    def add_actor2d(self, *args):
        """
        add_actor2d(self, p:Prop) -> None
        C++: void add_actor2d(Prop *p)
        Add/Remove different types of props to the renderer. These
        methods are all synonyms to add_view_prop and remove_view_prop. They
        are here for convenience and backwards compatibility.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddActor2D, *my_args)
        return ret

    def add_view_prop(self, *args):
        """
        add_view_prop(self, __a:Prop) -> None
        C++: void add_view_prop(Prop *)
        Add a prop to the list of props. Does nothing if the prop is
        already present. Prop is the superclass of all actors, volumes,
        2D actors, composite props etc.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddViewProp, *my_args)
        return ret

    def compute_aspect(self):
        """
        compute_aspect(self) -> None
        C++: virtual void compute_aspect()"""
        ret = self._vtk_obj.ComputeAspect()
        return ret
        

    def display_to_local_display(self, *args):
        """
        display_to_local_display(self, x:float, y:float) -> None
        C++: virtual void display_to_local_display(double &x, double &y)"""
        ret = self._wrap_call(self._vtk_obj.DisplayToLocalDisplay, *args)
        return ret

    def display_to_normalized_display(self, *args):
        """
        display_to_normalized_display(self, u:float, v:float) -> None
        C++: virtual void display_to_normalized_display(double &u, double &v)"""
        ret = self._wrap_call(self._vtk_obj.DisplayToNormalizedDisplay, *args)
        return ret

    def display_to_view(self):
        """
        display_to_view(self) -> None
        C++: virtual void display_to_view()
        Convert display coordinates to view coordinates.
        """
        ret = self._vtk_obj.DisplayToView()
        return ret
        

    def display_to_world(self):
        """
        display_to_world(self) -> None
        C++: void display_to_world()
        Convert display (or screen) coordinates to world coordinates.
        """
        ret = self._vtk_obj.DisplayToWorld()
        return ret
        

    def has_view_prop(self, *args):
        """
        has_view_prop(self, __a:Prop) -> int
        C++: int has_view_prop(Prop *)
        Query if a prop is in the list of props.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasViewProp, *my_args)
        return ret

    def is_in_viewport(self, *args):
        """
        is_in_viewport(self, x:int, y:int) -> int
        C++: virtual int is_in_viewport(int x, int y)
        Is a given display point in this Viewport's viewport.
        """
        ret = self._wrap_call(self._vtk_obj.IsInViewport, *args)
        return ret

    def local_display_to_display(self, *args):
        """
        local_display_to_display(self, x:float, y:float) -> None
        C++: virtual void local_display_to_display(double &x, double &y)
        These methods map from one coordinate system to another. They are
        primarily used by the Coordinate object and are often strung
        together. These methods return valid information only if the
        window has been realized (e.g., get_size() returns something other
        than (0,0)).
        """
        ret = self._wrap_call(self._vtk_obj.LocalDisplayToDisplay, *args)
        return ret

    def normalized_display_to_display(self, *args):
        """
        normalized_display_to_display(self, u:float, v:float) -> None
        C++: virtual void normalized_display_to_display(double &u, double &v)"""
        ret = self._wrap_call(self._vtk_obj.NormalizedDisplayToDisplay, *args)
        return ret

    def normalized_display_to_viewport(self, *args):
        """
        normalized_display_to_viewport(self, x:float, y:float) -> None
        C++: virtual void normalized_display_to_viewport(double &x,
            double &y)"""
        ret = self._wrap_call(self._vtk_obj.NormalizedDisplayToViewport, *args)
        return ret

    def normalized_viewport_to_view(self, *args):
        """
        normalized_viewport_to_view(self, x:float, y:float, z:float) -> None
        C++: virtual void normalized_viewport_to_view(double &x, double &y,
            double &z)"""
        ret = self._wrap_call(self._vtk_obj.NormalizedViewportToView, *args)
        return ret

    def normalized_viewport_to_viewport(self, *args):
        """
        normalized_viewport_to_viewport(self, u:float, v:float) -> None
        C++: virtual void normalized_viewport_to_viewport(double &u,
            double &v)"""
        ret = self._wrap_call(self._vtk_obj.NormalizedViewportToViewport, *args)
        return ret

    def pick_prop(self, *args):
        """
        pick_prop(self, selectionX:float, selectionY:float)
            -> AssemblyPath
        C++: virtual AssemblyPath *pick_prop(double selectionX,
            double selectionY)
        pick_prop(self, selectionX1:float, selectionY1:float,
            selectionX2:float, selectionY2:float) -> AssemblyPath
        C++: virtual AssemblyPath *pick_prop(double selectionX1,
            double selectionY1, double selectionX2, double selectionY2)
        Return the Prop that has the highest z value at the given x, y
        position in the viewport.  Basically, the top most prop that
        renders the pixel at selectionX, selectionY will be returned.  If
        no Props are there NULL is returned.  This method selects from
        the Viewports Prop list.
        """
        ret = self._wrap_call(self._vtk_obj.PickProp, *args)
        return wrap_vtk(ret)

    def pick_prop_from(self, *args):
        """
        pick_prop_from(self, selectionX:float, selectionY:float,
            __c:PropCollection) -> AssemblyPath
        C++: AssemblyPath *pick_prop_from(double selectionX,
            double selectionY, PropCollection *)
        pick_prop_from(self, selectionX1:float, selectionY1:float,
            selectionX2:float, selectionY2:float, __e:PropCollection)
            -> AssemblyPath
        C++: AssemblyPath *pick_prop_from(double selectionX1,
            double selectionY1, double selectionX2, double selectionY2,
            PropCollection *)
        Same as pick_prop with two arguments, but selects from the given
        collection of Props instead of the Renderers props.  Make sure
        the Props in the collection are in this renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PickPropFrom, *my_args)
        return wrap_vtk(ret)

    def pose_to_view(self, *args):
        """
        pose_to_view(self, __a:float, __b:float, __c:float) -> None
        C++: virtual void pose_to_view(double &, double &, double &)"""
        ret = self._wrap_call(self._vtk_obj.PoseToView, *args)
        return ret

    def pose_to_world(self, *args):
        """
        pose_to_world(self, __a:float, __b:float, __c:float) -> None
        C++: virtual void pose_to_world(double &, double &, double &)"""
        ret = self._wrap_call(self._vtk_obj.PoseToWorld, *args)
        return ret

    def remove_actor2d(self, *args):
        """
        remove_actor2d(self, p:Prop) -> None
        C++: void remove_actor2d(Prop *p)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveActor2D, *my_args)
        return ret

    def remove_all_view_props(self):
        """
        remove_all_view_props(self) -> None
        C++: void remove_all_view_props(void)
        Remove all props from the list of props.
        """
        ret = self._vtk_obj.RemoveAllViewProps()
        return ret
        

    def remove_view_prop(self, *args):
        """
        remove_view_prop(self, __a:Prop) -> None
        C++: void remove_view_prop(Prop *)
        Remove a prop from the list of props. Does nothing if the prop is
        not already present.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveViewProp, *my_args)
        return ret

    def view_to_display(self, *args):
        """
        view_to_display(self) -> None
        C++: virtual void view_to_display()
        view_to_display(self, x:float, y:float, z:float) -> None
        C++: virtual void view_to_display(double &x, double &y, double &z)
        Convert view coordinates to display coordinates.
        """
        ret = self._wrap_call(self._vtk_obj.ViewToDisplay, *args)
        return ret

    def view_to_normalized_viewport(self, *args):
        """
        view_to_normalized_viewport(self, x:float, y:float, z:float) -> None
        C++: virtual void view_to_normalized_viewport(double &x, double &y,
            double &z)"""
        ret = self._wrap_call(self._vtk_obj.ViewToNormalizedViewport, *args)
        return ret

    def view_to_pose(self, *args):
        """
        view_to_pose(self, __a:float, __b:float, __c:float) -> None
        C++: virtual void view_to_pose(double &, double &, double &)"""
        ret = self._wrap_call(self._vtk_obj.ViewToPose, *args)
        return ret

    def view_to_world(self, *args):
        """
        view_to_world(self) -> None
        C++: virtual void view_to_world()
        view_to_world(self, __a:float, __b:float, __c:float) -> None
        C++: virtual void view_to_world(double &, double &, double &)
        Convert view point coordinates to world coordinates.
        """
        ret = self._wrap_call(self._vtk_obj.ViewToWorld, *args)
        return ret

    def viewport_to_normalized_display(self, *args):
        """
        viewport_to_normalized_display(self, x:float, y:float) -> None
        C++: virtual void viewport_to_normalized_display(double &x,
            double &y)"""
        ret = self._wrap_call(self._vtk_obj.ViewportToNormalizedDisplay, *args)
        return ret

    def viewport_to_normalized_viewport(self, *args):
        """
        viewport_to_normalized_viewport(self, u:float, v:float) -> None
        C++: virtual void viewport_to_normalized_viewport(double &u,
            double &v)"""
        ret = self._wrap_call(self._vtk_obj.ViewportToNormalizedViewport, *args)
        return ret

    def world_to_display(self, *args):
        """
        world_to_display(self) -> None
        C++: void world_to_display()
        world_to_display(self, x:float, y:float, z:float) -> None
        C++: void world_to_display(double &x, double &y, double &z)
        Convert world point coordinates to display (or screen)
        coordinates.
        """
        ret = self._wrap_call(self._vtk_obj.WorldToDisplay, *args)
        return ret

    def world_to_pose(self, *args):
        """
        world_to_pose(self, __a:float, __b:float, __c:float) -> None
        C++: virtual void world_to_pose(double &, double &, double &)"""
        ret = self._wrap_call(self._vtk_obj.WorldToPose, *args)
        return ret

    def world_to_view(self, *args):
        """
        world_to_view(self) -> None
        C++: virtual void world_to_view()
        world_to_view(self, __a:float, __b:float, __c:float) -> None
        C++: virtual void world_to_view(double &, double &, double &)
        Convert world point coordinates to view coordinates.
        """
        ret = self._wrap_call(self._vtk_obj.WorldToView, *args)
        return ret

    _updateable_traits_ = \
    (('gradient_background', 'GetGradientBackground'),
    ('gradient_environmental_bg', 'GetGradientEnvironmentalBG'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('aspect', 'GetAspect'), ('background', 'GetBackground'),
    ('background2', 'GetBackground2'), ('background_alpha',
    'GetBackgroundAlpha'), ('display_point', 'GetDisplayPoint'),
    ('environmental_bg', 'GetEnvironmentalBG'), ('environmental_bg2',
    'GetEnvironmentalBG2'), ('pixel_aspect', 'GetPixelAspect'),
    ('view_point', 'GetViewPoint'), ('viewport', 'GetViewport'),
    ('world_point', 'GetWorldPoint'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'gradient_background',
    'gradient_environmental_bg', 'aspect', 'background', 'background2',
    'background_alpha', 'display_point', 'environmental_bg',
    'environmental_bg2', 'pixel_aspect', 'view_point', 'viewport',
    'world_point'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Viewport, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Viewport properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['gradient_background', 'gradient_environmental_bg'], [],
            ['aspect', 'background', 'background2', 'background_alpha',
            'display_point', 'environmental_bg', 'environmental_bg2',
            'pixel_aspect', 'view_point', 'viewport', 'world_point']),
            title='Edit Viewport properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Viewport properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

