﻿// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using ILCompiler.DependencyAnalysisFramework;
using Internal.TypeSystem;
using Debug = System.Diagnostics.Debug;

namespace ILCompiler.DependencyAnalysis
{
    /// <summary>
    /// Abstract api to allow creation of various different types of import nodes as might be exposed through the NodeFactory
    /// </summary>
    public abstract class ImportedNodeProvider
    {
        public abstract IEETypeNode ImportedEETypeNode(NodeFactory factory, TypeDesc type);
        public abstract ISortableSymbolNode ImportedGCStaticNode(NodeFactory factory, MetadataType type);
        public abstract ISortableSymbolNode ImportedNonGCStaticNode(NodeFactory factory, MetadataType type);
        public abstract ISortableSymbolNode ImportedThreadStaticOffsetNode(NodeFactory factory, MetadataType type);
        public abstract ISortableSymbolNode ImportedThreadStaticIndexNode(NodeFactory factory, MetadataType type);
        public abstract ISortableSymbolNode ImportedTypeDictionaryNode(NodeFactory factory, TypeDesc type);
        public abstract ISortableSymbolNode ImportedMethodDictionaryNode(NodeFactory factory, MethodDesc method);
        public abstract IMethodNode ImportedMethodCodeNode(NodeFactory factory, MethodDesc method, bool unboxingStub);
    }

    public class ImportedNodeProviderThrowing : ImportedNodeProvider
    {
        public override IEETypeNode ImportedEETypeNode(NodeFactory factory, TypeDesc type)
        {
            throw new NotSupportedException();
        }

        public override ISortableSymbolNode ImportedGCStaticNode(NodeFactory factory, MetadataType type)
        {
            throw new NotSupportedException();
        }

        public override ISortableSymbolNode ImportedNonGCStaticNode(NodeFactory factory, MetadataType type)
        {
            throw new NotSupportedException();
        }

        public override ISortableSymbolNode ImportedThreadStaticOffsetNode(NodeFactory factory, MetadataType type)
        {
            throw new NotSupportedException();
        }

        public override ISortableSymbolNode ImportedThreadStaticIndexNode(NodeFactory factory, MetadataType type)
        {
            throw new NotSupportedException();
        }

        public override ISortableSymbolNode ImportedTypeDictionaryNode(NodeFactory factory, TypeDesc type)
        {
            throw new NotSupportedException();
        }

        public override ISortableSymbolNode ImportedMethodDictionaryNode(NodeFactory factory, MethodDesc method)
        {
            throw new NotSupportedException();
        }

        public override IMethodNode ImportedMethodCodeNode(NodeFactory factory, MethodDesc method, bool unboxingStub)
        {
            throw new NotSupportedException();
        }
    }
}
