---
id: fast-foundation.tooltip
title: Tooltip class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Tooltip](./fast-foundation.tooltip.md)

## Tooltip class

An Tooltip Custom HTML Element.


- The default slot for the tooltip content


tooltip - The tooltip element


dismiss - Fires a custom 'dismiss' event when the tooltip is visible and escape key is pressed

<b>Signature:</b>

```typescript
export declare class Tooltip extends FoundationElement 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [anchor](./fast-foundation.tooltip.anchor.md) |  | string | The id of the element the tooltip is anchored to |
|  [anchorElement](./fast-foundation.tooltip.anchorelement.md) |  | HTMLElement \| null | the html element currently being used as anchor. Setting this directly overrides the anchor attribute. |
|  [autoUpdateMode](./fast-foundation.tooltip.autoupdatemode.md) |  | [AutoUpdateMode](./fast-foundation.autoupdatemode.md) | Controls when the tooltip updates its position, default is 'anchor' which only updates when the anchor is resized. 'auto' will update on scroll/resize events. Corresponds to anchored-region auto-update-mode. |
|  [delay](./fast-foundation.tooltip.delay.md) |  | number | The delay in milliseconds before a tooltip is shown after a hover event |
|  [horizontalViewportLock](./fast-foundation.tooltip.horizontalviewportlock.md) |  | boolean | Controls if the tooltip will always remain fully in the viewport on the horizontal axis |
|  [position](./fast-foundation.tooltip.position.md) |  | [TooltipPosition](./fast-foundation.tooltipposition.md) | Controls the placement of the tooltip relative to the anchor. When the position is undefined the tooltip is placed above or below the anchor based on available space. |
|  [verticalViewportLock](./fast-foundation.tooltip.verticalviewportlock.md) |  | boolean | Controls if the tooltip will always remain fully in the viewport on the vertical axis |
|  [visible](./fast-foundation.tooltip.visible.md) |  | boolean | Whether the tooltip is visible or not. If undefined tooltip is shown when anchor element is hovered |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [connectedCallback()](./fast-foundation.tooltip.connectedcallback.md) |  |  |
|  [disconnectedCallback()](./fast-foundation.tooltip.disconnectedcallback.md) |  |  |
