/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Natural logarithm of the probability mass function (PMF) for a hypergeometric distribution.
*
* @module @stdlib/stats/base/dists/hypergeometric/logpmf
*
* @example
* var logpmf = require( '@stdlib/stats/base/dists/hypergeometric/logpmf' );
*
* var y = logpmf( 1.0, 8, 4, 2 );
* // returns ~-0.56
*
* y = logpmf( 2.0, 8, 4, 2 );
* // returns ~-1.54
*
* y = logpmf( 0.0, 8, 4, 2 );
* // returns ~-1.54
*
* y = logpmf( 1.5, 8, 4, 2 );
* // returns -Infinity
*
* var mylogpmf = logpmf.factory( 30, 20, 5 );
* y = mylogpmf( 4.0 );
* // returns ~-1.079
*
* y = mylogpmf( 1.0 );
* // returns ~-3.54
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-nonenumerable-read-only-property' );
var logpmf = require( './logpmf.js' );
var factory = require( './factory.js' );


// MAIN //

setReadOnly( logpmf, 'factory', factory );


// EXPORTS //

module.exports = logpmf;
