%feature("docstring") OT::PostAnalyticalImportanceSampling
"Post analytical importance sampling.

Simulation method where the original distribution is replaced by the
distribution in the standard space centered around the provided design point.

This method, based on importance sampling, uses a normal instrumental 
distribution in the standard space (see [lemaire2009]_ page 255, [melchers1990]_).

Parameters
----------
analyticalResult : :class:`~openturns.AnalyticalResult`
    Result which contains the whole information on the analytical study
    performed before the simulation study: in particular, the standard
    distribution of the standard space and the standard space design point.

See also
--------
PostAnalyticalControlledImportanceSampling, NAIS, CrossEntropyImportanceSampling

Examples
--------
>>> import openturns as ot
>>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
>>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
>>> X = ot.RandomVector(distribution)
>>> Y = ot.CompositeRandomVector(f, X)
>>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)
>>> solver = ot.AbdoRackwitz()
>>> solver.setStartingPoint(distribution.getMean())
>>> analytical = ot.FORM(solver, event)
>>> analytical.run()
>>> analyticalResult = analytical.getResult()
>>> algo = ot.PostAnalyticalImportanceSampling(analyticalResult)
>>> algo.run()
>>> result = algo.getResult()
>>> pf = result.getProbabilityEstimate()"
