-- This reservoir simulation deck is made available under the Open Database
-- License: http://opendatacommons.org/licenses/odbl/1.0/. Any rights in
-- individual contents of the database are licensed under the Database Contents
-- License: http://opendatacommons.org/licenses/dbcl/1.0/

-- Copyright (C) 2015 Statoil

--
--         Generated by : Prosper 9.3 - License#:4474 - Sep 17 2006 14:05:16
--         Generated on : 09 Jan 07  14:18
--           Input File : C:\GAP\E3CH.OUT
--          Output File : Z:\res\sim\ior\linn\gap\E3CH.Ecl
--
--
--                Fluid : Oil
--           PVT Method : Black Oil
--    Equation Of State : 
--            Separator : Single-Stage
--            Emulsions : No
--             Hydrates : Disable Warning
--      Water Viscosity : Use Default Correlation
--         Water Vapour : No Calculations
--      Viscosity Model : Newtonian Fluid
--
--            Flow Type : Tubing
--            Well Type : Producer
--
--      Artificial Lift : None
--            Lift Type : 
--
--           Predicting : Pressure and Temperature (offshore)
--    Temperature Model : Rough Approximation
--                Range : Full System
--
--           Completion : Cased Hole
--          Gravel Pack : No
--
--          Inflow Type : Single Branch
--           Gas Coning : No
--
--              Company : Statoil
--                Field : Norne
--             Location : Nordland II
--                 Well : E-3 C H
--             Platform : 
--              Analyst : amoe+arild stokkenes
--                 Date : 31 May 06  13:33
--
--
--
--  Surface Equipment Correlation :  Beggs and Brill
--      Vertical Lift Correlation :  Petroleum Experts 3 - (0.996) (0.969)
--
--                    Rate Method :  User Selected
--                      Rate Type :  Liquid Rates
--
--                     First Node :    1            Xmas Tree    397.401 (m)
--                      Last Node :   21               Tubing       3210 (m)
--
--         Sensitivity Variable 1 :  First Node Pressure
--         Sensitivity Variable 2 :  Gas Oil Ratio
--         Sensitivity Variable 3 :  Water Cut
--
--
-- PROSPER Lift Curves For ECLIPSE Simulator    (Liquid - Producer Well)  (Units System  - METRIC)


VFPPROD

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
--    47       2642.03       'LIQ'      'WCT'      'GOR'            /


-- Prosper files are corrected from RKB to MSL depth. lmarr            
      
-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
      47       2618.03       'LIQ'      'WCT'      'GOR'            / 

-- 'LIQ' units - SM3/DAY
  200.0   500.0  1000.0  1500.0  2000.0 
 2500.0  3000.0  3500.0  4000.0  4500.0 
 5000.0  5500.0  6000.0  6500.0  7000.0 
 7500.0  8000.0 10000.0 14000.0 /

-- 'THP' units - BARSA
  20.00   50.00   60.00   80.00  100.00 
 120.00  140.00  160.00  180.00  200.00 /

-- 'WCT' units - FRACTION
      0     0.1     0.2     0.3     0.4 
    0.5     0.6     0.7     0.8       1 /

-- 'GOR' units - SM3/SM3
     50     100     150     200     300 
    500    1000    2000 /

-- 'ALQ' units - 
      0 /

 1  1  1  1  181.87  163.70  158.88  158.12  159.00 
             161.31  164.35  168.48  173.25  178.65 
             184.54  191.33  197.95  204.98  212.32 
             219.91  227.78  261.90  344.53 
/
 1  1  2  1  115.90   95.18   94.78   97.79  103.16 
             110.15  118.30  127.44  137.08  147.24 
             157.66  168.34  179.45  190.77  202.16 
             213.71  224.73  272.40  376.98 
/
 1  1  3  1   66.82   66.57   70.56   76.75   84.84 
              94.43  105.02  116.43  128.29  140.85 
             153.58  166.64  179.58  193.07  206.55 
             220.04  233.73  291.36  414.45 
/
 1  1  4  1   53.76   56.18   62.14   69.93   79.29 
              89.92  101.52  114.48  128.15  142.17 
             156.62  171.15  186.38  201.56  216.51 
             232.07  247.72  311.99  453.33 
/
 1  1  5  1   45.72   50.18   57.63   67.26   78.59 
              91.31  105.17  119.91  135.34  151.31 
             169.25  186.93  205.01  223.46  242.36 
             261.14  279.65  358.75  533.74 
/
 1  1  6  1   41.72   48.36   58.20   70.76   85.91 
             102.95  121.28  140.67  160.96  181.94 
             203.49  225.56  249.04  274.11  299.03 
             324.40  350.41  457.57  703.60 
/
 1  1  7  1   37.89   47.01   65.35   88.33  113.96 
             142.64  173.20  204.62  237.28  271.33 
             306.43  342.58  379.86  418.32  460.41 
             503.54  547.92  738.78 1189.74 
/
 1  1  8  1   35.77   54.68   93.70  136.69  184.35 
             236.15  291.50  350.02  411.85  476.56 
             544.54  615.19  691.08  773.48  857.31 
             946.11 1036.88 1440.52 2481.00 
/
 1  2  1  1  189.23  171.53  166.60  165.57  166.34 
             168.16  171.20  175.01  179.58  184.66 
             190.31  196.31  202.78  209.61  216.74 
             224.17  231.86  266.47  347.92 
/
 1  2  2  1  130.92  104.96  103.57  105.88  110.48 
             116.82  124.41  132.90  142.34  152.06 
             162.16  172.58  183.52  194.04  205.18 
             216.63  227.43  274.60  376.85 
/
 1  2  3  1   75.03   72.66   75.58   81.31   89.05 
              98.22  108.54  119.53  131.33  143.42 
             155.91  168.35  181.33  194.36  207.41 
             220.62  234.03  290.11  410.76 
/
 1  2  4  1   57.80   59.57   64.90   72.35   81.46 
              91.84  103.49  116.21  129.38  143.06 
             157.21  171.44  185.97  200.82  215.80 
             230.68  245.92  308.93  445.76 
/
 1  2  5  1   47.30   51.23   58.39   67.80   78.87 
              91.28  104.76  119.08  134.05  150.18 
             167.38  184.51  202.03  219.51  237.83 
             256.04  273.98  349.75  518.21 
/
 1  2  6  1   42.35   48.81   58.20   70.16   84.60 
             100.78  118.21  136.73  156.08  176.10 
             196.65  217.68  240.71  264.41  288.17 
             312.45  336.63  438.29  671.56 
/
 1  2  7  1   38.26   46.95   63.53   84.64  108.80 
             135.44  163.57  192.89  223.66  255.34 
             287.95  321.49  355.99  390.15  429.34 
             469.81  509.45  682.96 1094.81 
/
 1  2  8  1   36.52   52.56   87.86  127.12  170.63 
             217.89  268.19  321.40  377.22  435.53 
             496.22  559.55  626.59  697.56  773.91 
             853.38  935.08 1289.75 2192.72 
/
 1  3  1  1  195.05  179.27  174.37  173.34  173.87 
             175.58  178.33  181.89  186.20  191.03 
             196.43  202.31  208.49  215.11  222.07 
             229.37  237.03  270.38  352.07 
/
 1  3  2  1  145.25  115.98  113.79  115.27  119.18 
             124.77  131.75  139.70  148.38  157.63 
             166.95  177.18  187.57  198.33  208.60 
             219.13  230.38  275.74  378.32 
/
 1  3  3  1   88.89   80.99   82.44   87.33   94.50 
             103.22  113.04  123.66  134.91  146.66 
             158.72  170.84  183.30  195.82  208.54 
             221.47  234.59  289.50  406.84 
/
 1  3  4  1   63.66   64.36   68.82   75.77   84.52 
              94.77  106.30  118.48  131.31  144.68 
             158.22  172.11  186.31  200.34  214.97 
             229.60  244.25  305.78  438.07 
/
 1  3  5  1   49.67   53.00   59.75   68.87   79.63 
              91.69  104.77  118.64  133.10  149.46 
             165.67  182.22  199.18  216.11  233.37 
             250.98  268.31  341.45  504.30 
/
 1  3  6  1   43.09   49.34   58.30   69.67   83.39 
              98.70  115.32  132.96  151.38  170.41 
             189.96  209.95  232.60  254.71  277.30 
             300.39  323.41  420.01  638.08 
/
 1  3  7  1   38.73   47.02   62.30   80.94  103.37 
             127.88  154.23  181.72  210.15  239.49 
             268.89  300.29  331.45  363.99  397.63 
             434.86  472.15  631.00 1005.86 
/
 1  3  8  1   36.34   50.62   82.26  117.72  157.27 
             200.05  245.52  293.57  343.66  395.88 
             449.45  506.21  565.49  626.43  693.29 
             764.33  836.70 1148.05 1928.30 
/
 1  4  1  1  201.99  187.45  182.31  181.31  181.75 
             183.33  185.83  189.03  192.98  197.57 
             202.62  208.19  214.18  220.54  227.26 
             234.39  241.88  274.79  355.49 
/
 1  4  2  1  161.40  128.49  125.38  126.21  129.30 
             134.30  140.43  147.49  155.50  164.23 
             173.18  182.81  192.35  202.62  212.63 
             222.71  233.74  278.25  377.96 
/
 1  4  3  1  109.68   91.76   91.75   95.52  101.71 
             109.76  118.86  128.96  139.75  150.68 
             162.18  174.20  186.11  198.25  210.62 
             223.17  236.32  289.33  404.11 
/
 1  4  4  1   73.29   71.21   74.48   80.69   89.16 
              99.04  110.00  121.62  134.04  146.75 
             159.86  173.32  186.99  200.62  214.60 
             228.57  242.77  302.70  431.69 
/
 1  4  5  1   53.33   55.88   62.05   70.76   81.13 
              92.77  105.39  118.75  133.68  148.74 
             164.56  180.20  196.58  212.92  229.61 
             246.03  263.16  333.10  488.13 
/
 1  4  6  1   44.07   50.00   58.54   69.33   82.30 
              96.88  112.69  129.44  146.92  164.98 
             183.50  203.47  224.62  245.57  266.43 
             288.31  310.11  401.39  605.11 
/
 1  4  7  1   39.33   47.30   61.28   78.26   98.30 
             120.69  144.83  169.99  196.14  223.13 
             250.86  279.20  308.19  337.92  368.39 
             402.82  437.69  582.22  919.99 
/
 1  4  8  1   36.35   48.85   76.88  108.81  144.00 
             182.35  223.44  266.35  311.11  357.43 
             404.85  455.02  506.81  560.30  616.66 
             678.29  742.56 1016.39 1681.29 
/
 1  5  1  1  209.09  195.89  190.67  189.53  189.86 
             191.25  193.52  196.53  200.20  204.49 
             209.28  214.53  220.29  226.36  232.92 
             239.74  247.05  279.42  359.43 
/
 1  5  2  1  177.47  143.89  138.53  138.65  141.12 
             145.06  150.59  156.95  164.09  171.82 
             180.42  189.07  197.97  207.75  217.19 
             226.98  236.91  279.93  377.79 
/
 1  5  3  1  133.06  105.16  103.74  106.36  111.48 
             118.44  126.68  135.95  145.74  156.39 
             167.18  178.29  189.70  201.34  212.70 
             225.09  237.89  288.14  400.18 
/
 1  5  4  1   89.33   81.73   83.13   88.27   95.84 
             104.96  115.20  126.26  137.94  150.12 
             162.73  175.48  188.19  201.70  215.00 
             228.53  242.27  299.83  423.90 
/
 1  5  5  1   59.07   60.57   65.89   73.97   83.80 
              94.91  106.96  120.62  134.58  149.04 
             163.97  178.99  194.35  210.04  225.52 
             241.68  257.94  324.62  473.60 
/
 1  5  6  1   45.90   50.91   59.02   69.33   81.68 
              95.52  110.49  126.33  142.84  159.87 
             177.59  197.27  216.63  236.38  256.07 
             276.76  297.37  382.32  572.81 
/
 1  5  7  1   40.12   47.82   60.50   75.85   94.04 
             114.46  136.40  159.39  183.32  208.03 
             233.40  259.38  285.94  313.00  341.21 
             372.57  403.73  534.46  834.90 
/
 1  5  8  1   36.71   47.86   71.89   99.85  131.44 
             165.51  201.63  239.91  279.42  319.63 
             361.60  405.37  450.25  497.18  545.82 
             596.29  651.78  889.71 1450.58 
/
 1  6  1  1  216.06  204.66  199.22  198.04  198.29 
             199.54  201.61  204.38  207.78  211.73 
             216.27  221.21  226.59  232.49  238.69 
             245.40  252.35  284.00  363.38 
/
 1  6  2  1  192.19  161.12  153.23  152.75  154.51 
             157.87  162.45  167.97  174.25  181.16 
             188.58  196.43  205.24  213.94  222.86 
             232.05  241.55  282.98  379.18 
/
 1  6  3  1  156.54  121.56  118.78  120.20  124.19 
             129.91  137.05  145.20  154.12  163.65 
             173.63  183.62  194.31  205.43  216.56 
             227.76  239.94  288.22  397.59 
/
 1  6  4  1  117.29   96.23   95.81   99.38  105.57 
             113.53  122.86  132.92  143.84  155.15 
             166.97  178.86  191.03  203.46  216.15 
             229.04  242.20  297.34  416.84 
/
 1  6  5  1   69.24   68.44   72.35   79.40   88.42 
              99.15  111.00  123.42  136.60  150.36 
             164.29  178.60  193.27  207.76  222.93 
             238.15  253.37  317.05  457.20 
/
 1  6  6  1   49.32   53.09   60.52   70.28   81.96 
              95.00  109.08  123.95  139.42  155.81 
             173.53  191.17  209.28  227.85  246.37 
             265.28  284.64  364.00  540.11 
/
 1  6  7  1   41.17   48.68   60.00   73.76   90.13 
             108.54  128.24  149.08  170.78  193.20 
             216.21  239.75  263.81  288.38  315.55 
             342.94  370.96  488.51  754.35 
/
 1  6  8  1   37.36   47.27   67.38   91.52  119.00 
             148.63  180.71  214.21  247.83  283.45 
             320.17  358.02  397.05  437.28  478.40 
             521.29  565.59  769.53 1234.57 
/
 1  7  1  1  222.71  213.47  207.82  206.81  206.95 
             208.11  210.02  212.59  215.75  219.52 
             223.71  228.38  233.48  239.12  245.06 
             251.40  258.24  288.95  367.53 
/
 1  7  2  1  206.81  178.52  169.92  168.91  169.86 
             172.38  176.12  180.70  186.11  192.17 
             198.79  205.89  213.43  221.24  229.50 
             238.13  247.09  286.84  378.97 
/
 1  7  3  1  180.20  141.50  137.20  137.57  140.40 
             144.90  150.67  157.41  164.89  173.34 
             181.94  191.45  201.18  211.08  221.90 
             232.28  243.07  289.17  393.20 
/
 1  7  4  1  149.50  115.55  113.26  115.31  119.93 
             126.39  134.16  142.94  152.47  162.59 
             173.17  184.14  195.43  207.04  218.38 
             230.64  242.44  295.12  408.39 
/
 1  7  5  1   89.13   82.44   83.84   89.28   97.23 
             106.76  117.41  128.87  140.97  153.58 
             166.63  179.97  193.35  207.12  220.97 
             235.08  249.42  308.66  442.16 
/
 1  7  6  1   55.84   58.03   64.27   73.23   84.05 
              96.16  109.22  122.99  138.21  153.90 
             169.92  186.40  202.93  219.81  237.09 
             254.73  272.13  345.82  506.79 
/
 1  7  7  1   42.75   49.97   59.86   72.08   86.68 
             103.01  120.69  139.38  158.87  178.98 
             199.62  220.73  242.26  265.99  289.99 
             314.53  339.73  443.99  676.87 
/
 1  7  8  1   38.42   47.24   63.80   83.51  106.90 
             132.44  159.87  188.45  218.03  248.55 
             279.93  312.02  345.14  378.35  412.84 
             449.89  485.01  653.50 1042.12 
/
 1  8  1  1  228.85  221.54  216.67  215.77  215.92 
             217.03  218.83  221.24  224.20  227.67 
             231.71  236.12  240.98  246.26  251.95 
             258.04  264.68  294.40  371.90 
/
 1  8  2  1  217.29  196.44  187.46  186.19  186.73 
             188.58  191.47  195.28  199.74  204.93 
             210.46  216.71  223.33  230.49  238.07 
             245.90  254.23  290.77  379.72 
/
 1  8  3  1  200.84  168.12  159.19  158.68  160.40 
             163.48  167.88  173.29  179.53  186.83 
             194.33  202.29  210.67  219.45  228.57 
             238.03  248.75  290.72  390.51 
/
 1  8  4  1  181.72  140.40  136.66  137.17  140.08 
             144.77  150.73  157.88  165.60  174.31 
             183.18  192.46  202.64  212.63  223.01 
             234.74  245.86  293.76  401.40 
/
 1  8  5  1  133.51  105.37  104.03  107.08  112.72 
             120.24  129.23  139.03  149.64  160.59 
             172.38  184.22  196.39  208.87  221.59 
             234.01  247.26  301.99  426.23 
/
 1  8  6  1   70.27   69.28   73.22   80.65   90.09 
             101.04  113.28  126.22  139.85  154.06 
             168.46  183.27  198.47  214.03  229.22 
             245.13  261.00  327.61  473.73 
/
 1  8  7  1   46.03   51.72   60.38   71.24   84.23 
              98.73  114.40  130.94  148.16  165.94 
             184.15  203.66  224.31  244.98  266.20 
             287.38  309.05  400.24  601.70 
/
 1  8  8  1   40.12   48.20   61.74   77.78   96.60 
             117.67  140.32  164.03  188.74  214.25 
             240.47  267.36  294.83  322.86  351.55 
             380.90  410.96  549.68  863.52 
/
 1  9  1  1  234.32  229.84  225.61  224.75  225.09 
             226.19  227.93  230.23  233.04  236.34 
             240.10  244.30  248.93  253.97  259.43 
             265.44  271.70  300.58  376.54 
/
 1  9  2  1  226.90  213.54  205.97  204.58  204.84 
             206.18  208.40  211.36  214.98  219.24 
             223.99  229.32  235.06  241.32  247.94 
             255.09  262.50  296.25  380.75 
/
 1  9  3  1  218.79  195.39  185.53  184.25  185.00 
             187.16  190.27  194.25  198.97  204.43 
             210.49  216.98  224.06  231.59  239.55 
             247.77  256.50  294.81  387.35 
/
 1  9  4  1  209.25  176.07  166.43  165.77  167.30 
             170.30  174.22  179.26  185.21  191.78 
             198.99  207.22  215.42  224.04  233.05 
             242.43  252.15  294.34  394.89 
/
 1  9  5  1  180.90  139.91  136.05  136.73  139.91 
             144.82  151.00  158.17  166.37  174.95 
             184.46  194.01  203.94  214.79  225.38 
             237.03  248.21  298.01  410.55 
/
 1  9  6  1  118.00   96.76   96.53  100.53  107.25 
             115.90  125.67  136.49  148.05  159.89 
             172.29  185.20  198.14  211.39  224.93 
             238.78  252.88  310.94  440.72 
/
 1  9  7  1   56.54   58.81   65.42   74.69   85.86 
              98.33  111.77  125.95  141.23  157.64 
             174.17  190.82  208.30  225.78  243.71 
             262.02  280.12  357.03  525.40 
/
 1  9  8  1   43.07   50.66   60.96   73.49   88.45 
             105.14  123.20  142.31  162.25  182.84 
             203.99  225.64  247.73  270.27  294.55 
             320.50  346.01  454.48  696.93 
/
 1 10  1  1  242.83  242.24  241.88  242.20  243.08 
             244.46  246.29  248.56  251.24  254.34 
             257.83  261.72  266.00  270.68  275.73 
             281.18  287.01  314.15  386.67 
/
 1 10  2  1  242.83  242.24  241.88  242.20  243.08 
             244.46  246.29  248.56  251.24  254.34 
             257.83  261.72  266.00  270.68  275.73 
             281.18  287.01  314.15  386.67 
/
 1 10  3  1  242.83  242.24  241.88  242.20  243.08 
             244.46  246.29  248.56  251.24  254.34 
             257.83  261.72  266.00  270.68  275.73 
             281.18  287.01  314.15  386.67 
/
 1 10  4  1  242.83  242.24  241.88  242.20  243.08 
             244.46  246.29  248.56  251.24  254.34 
             257.83  261.72  266.00  270.68  275.73 
             281.18  287.01  314.15  386.67 
/
 1 10  5  1  242.83  242.24  241.88  242.20  243.08 
             244.46  246.29  248.56  251.24  254.34 
             257.83  261.72  266.00  270.68  275.73 
             281.18  287.01  314.15  386.67 
/
 1 10  6  1  242.83  242.24  241.88  242.20  243.08 
             244.46  246.29  248.56  251.24  254.34 
             257.83  261.72  266.00  270.68  275.73 
             281.18  287.01  314.15  386.67 
/
 1 10  7  1  242.83  242.24  241.88  242.20  243.08 
             244.46  246.29  248.56  251.24  254.34 
             257.83  261.72  266.00  270.68  275.73 
             281.18  287.01  314.15  386.67 
/
 1 10  8  1  242.83  242.24  241.88  242.20  243.08 
             244.46  246.29  248.56  251.24  254.34 
             257.83  261.72  266.00  270.68  275.73 
             281.18  287.01  314.15  386.67 
/
 2  1  1  1  224.77  221.66  218.33  217.67  217.89 
             218.78  220.38  222.58  225.34  228.61 
             232.38  236.60  241.27  246.45  251.96 
             257.85  264.14  293.13  368.44 
/
 2  1  2  1  204.16  178.08  173.80  173.13  174.25 
             176.82  180.62  185.33  190.97  197.23 
             204.20  211.79  219.78  228.17  236.98 
             246.16  255.81  297.06  394.64 
/
 2  1  3  1  175.01  145.21  142.31  143.17  146.09 
             150.78  156.82  163.96  172.22  181.03 
             190.75  201.04  211.48  222.71  233.90 
             246.11  258.37  310.49  427.35 
/
 2  1  4  1  136.42  123.44  122.79  125.38  130.14 
             136.83  144.91  154.32  164.77  176.08 
             187.83  200.37  213.34  226.54  240.13 
             254.08  268.38  329.12  464.77 
/
 2  1  5  1  101.47  101.29  103.64  109.17  117.16 
             126.98  138.21  150.52  164.57  179.39 
             194.77  210.81  227.08  243.86  261.15 
             278.91  297.01  372.14  543.68 
/
 2  1  6  1   84.53   87.08   94.41  104.62  117.08 
             131.47  147.45  164.72  183.02  202.21 
             222.13  243.06  266.17  289.83  313.17 
             337.70  362.37  467.62  712.69 
/
 2  1  7  1   78.11   84.92   97.85  115.70  137.66 
             162.75  190.30  219.61  250.51  282.83 
             316.48  351.43  387.66  425.23  467.19 
             510.09  553.92  743.62 1195.63 
/
 2  1  8  1   74.97   87.02  115.61  153.01  197.10 
             246.89  300.34  357.37  417.57  481.17 
             548.30  618.36  694.10  775.10  859.36 
             947.57 1037.84 1439.76 2480.25 
/
 2  2  1  1  229.21  226.48  223.19  222.48  222.72 
             223.61  225.22  227.43  230.18  233.43 
             237.17  241.37  246.01  251.07  256.63 
             262.50  268.75  297.71  372.76 
/
 2  2  2  1  210.33  186.76  181.50  180.60  181.47 
             183.78  187.23  191.68  196.97  202.98 
             209.63  216.82  224.49  232.61  240.97 
             249.88  259.27  299.48  395.69 
/
 2  2  3  1  186.78  153.50  150.11  150.45  153.00 
             157.19  162.80  169.51  177.13  185.75 
             194.77  204.32  214.79  225.24  236.64 
             248.23  259.92  309.84  425.52 
/
 2  2  4  1  151.67  131.18  129.61  131.53  135.79 
             141.89  149.45  158.20  168.14  178.71 
             190.08  202.16  214.50  227.28  240.47 
             254.05  267.95  326.78  457.72 
/
 2  2  5  1  107.70  106.28  108.00  112.68  119.85 
             128.97  139.54  151.87  165.25  179.33 
             193.86  209.32  225.02  241.24  257.97 
             274.61  291.89  364.59  528.30 
/
 2  2  6  1   87.38   88.94   95.36  104.89  116.69 
             130.33  145.48  161.85  179.21  197.40 
             216.28  236.86  258.47  280.91  303.04 
             326.39  349.83  449.40  678.62 
/
 2  2  7  1   78.69   85.17   97.07  113.47  133.70 
             156.87  182.29  209.38  237.99  267.90 
             299.02  331.28  364.69  399.26  437.36 
             477.03  517.35  690.69 1103.35 
/
 2  2  8  1   75.22   86.20  111.67  145.14  184.82 
             229.23  277.40  328.79  382.91  439.92 
             499.89  562.99  629.31  700.72  776.56 
             855.60  936.80 1291.18 2195.68 
/
 2  3  1  1  233.73  231.39  228.03  227.47  227.64 
             228.63  230.26  232.46  235.20  238.44 
             242.15  246.32  250.92  255.94  261.37 
             267.20  273.56  302.21  377.54 
/
 2  3  2  1  216.62  195.60  189.79  188.69  189.33 
             191.34  194.51  198.56  203.49  209.12 
             215.38  222.19  229.50  237.29  245.51 
             254.12  263.10  302.34  396.81 
/
 2  3  3  1  198.43  162.55  158.96  158.80  160.92 
             164.64  169.80  175.83  183.21  191.12 
             199.67  208.78  218.36  228.91  239.62 
             250.71  261.90  310.52  422.65 
/
 2  3  4  1  167.49  140.08  137.65  138.96  142.61 
             148.06  155.05  163.19  172.38  182.46 
             193.15  204.44  216.26  228.56  240.76 
             253.79  267.22  324.55  452.37 
/
 2  3  5  1  116.58  112.43  113.48  117.43  123.76 
             132.00  142.34  153.82  166.35  179.77 
             193.67  208.19  223.27  238.88  254.47 
             270.70  287.51  356.99  514.84 
/
 2  3  6  1   91.33   91.90   97.11  105.79  116.82 
             129.65  143.92  159.35  175.73  192.89 
             210.72  231.05  251.25  272.09  293.57 
             315.16  337.35  431.33  647.02 
/
 2  3  7  1   79.38   85.51   96.45  111.43  129.98 
             151.28  174.56  199.50  225.84  253.39 
             282.02  311.67  342.32  373.98  408.25 
             444.64  481.68  639.50 1012.99 
/
 2  3  8  1   75.57   85.58  108.09  137.73  173.11 
             212.88  256.10  302.13  350.51  401.34 
             454.64  510.51  569.01  630.30  697.18 
             767.15  839.12 1148.93 1927.29 
/
 2  4  1  1  239.43  236.61  233.34  232.75  232.92 
             233.92  235.55  237.75  240.47  243.68 
             247.36  251.50  256.06  261.04  266.43 
             272.21  278.39  307.08  382.00 
/
 2  4  2  1  224.11  205.42  198.62  197.38  197.83 
             199.59  202.41  206.17  210.67  215.91 
             221.77  228.19  235.05  242.45  250.30 
             258.55  267.20  305.29  398.02 
/
 2  4  3  1  208.70  172.58  168.72  168.28  169.90 
             173.14  177.78  183.50  190.12  197.50 
             205.53  214.13  223.23  233.03  243.24 
             253.67  264.54  311.52  419.47 
/
 2  4  4  1  184.32  150.68  147.16  147.85  150.93 
             155.72  161.96  169.52  177.85  187.20 
             197.28  207.62  218.80  230.49  242.14 
             254.76  267.11  322.47  445.05 
/
 2  4  5  1  127.21  120.72  120.59  123.79  129.45 
             137.08  146.30  156.94  168.51  180.95 
             194.14  207.98  221.99  236.77  251.89 
             267.17  282.84  349.37  499.18 
/
 2  4  6  1   96.45   96.44  100.11  107.68  117.75 
             129.65  142.96  157.40  172.74  188.83 
             206.89  225.26  244.28  263.92  284.24 
             304.66  324.98  413.22  613.96 
/
 2  4  7  1   80.29   85.97   95.99  109.60  126.54 
             145.91  167.17  190.00  214.13  239.34 
             265.53  292.62  320.59  349.43  380.58 
             413.85  447.72  590.95  927.04 
/
 2  4  8  1   76.07   85.20  104.87  130.82  162.04 
             197.27  235.66  276.47  319.34  364.28 
             411.27  460.34  511.56  565.02  620.80 
             681.86  745.67 1018.14 1681.32 
/
 2  5  1  1  245.38  242.03  238.85  238.23  238.40 
             239.41  241.04  243.22  245.93  249.12 
             252.76  256.86  261.38  266.31  271.66 
             277.40  283.54  311.89  386.57 
/
 2  5  2  1  232.07  215.68  207.99  206.66  206.97 
             208.50  211.04  214.43  218.62  223.41 
             228.88  234.90  241.45  248.36  255.82 
             263.71  271.87  308.68  399.44 
/
 2  5  3  1  218.73  183.87  179.57  178.82  180.15 
             183.04  187.11  192.20  198.23  205.03 
             212.49  220.58  229.41  238.61  248.20 
             258.14  268.58  312.98  418.14 
/
 2  5  4  1  201.79  162.39  158.39  158.45  160.89 
             165.00  170.58  177.27  184.88  193.26 
             202.66  212.31  222.46  233.58  244.60 
             256.00  268.46  320.93  439.19 
/
 2  5  5  1  152.15  131.56  129.95  132.31  137.09 
             143.79  152.00  161.61  172.08  183.64 
             195.67  208.56  221.93  235.59  249.67 
             264.18  279.09  341.75  485.33 
/
 2  5  6  1  103.23  102.71  105.13  111.17  120.00 
             130.76  142.97  156.29  170.50  186.57 
             203.30  220.52  237.99  256.49  275.12 
             294.30  313.37  395.33  582.41 
/
 2  5  7  1   82.18   86.62   95.76  108.07  123.38 
             140.92  160.24  180.99  202.91  225.82 
             249.60  274.17  299.52  325.59  354.14 
             384.14  414.55  543.63  843.56 
/
 2  5  8  1   76.77   85.15  102.07  124.47  151.65 
             182.49  216.17  251.90  289.45  328.75 
             369.73  412.40  456.79  502.94  550.95 
             600.83  656.46  893.42 1451.65 
/
 2  6  1  1  251.25  247.51  244.50  243.87  244.04 
             245.06  246.70  248.88  251.56  254.72 
             258.33  262.39  266.87  271.76  277.06 
             282.76  288.85  317.04  391.61 
/
 2  6  2  1  240.07  225.99  218.02  216.53  216.73 
             218.09  220.37  223.53  227.31  231.73 
             236.81  242.35  248.48  254.99  262.05 
             269.55  277.33  312.68  401.10 
/
 2  6  3  1  228.85  198.59  191.68  190.69  191.63 
             194.00  197.53  202.03  207.38  213.61 
             220.49  227.93  235.89  244.35  253.38 
             262.71  272.42  314.80  416.36 
/
 2  6  4  1  217.16  175.71  171.55  171.09  172.90 
             176.31  181.16  187.09  193.65  201.22 
             209.86  218.74  228.15  238.03  248.33 
             259.03  270.41  320.15  432.38 
/
 2  6  5  1  178.36  145.27  142.16  143.51  147.29 
             152.94  160.18  168.58  177.99  188.22 
             199.24  211.26  223.52  235.82  249.01 
             262.61  276.64  334.61  471.72 
/
 2  6  6  1  114.30  111.37  112.69  117.33  124.58 
             133.85  144.68  157.22  170.96  185.47 
             200.46  216.44  232.71  249.54  266.92 
             284.25  302.49  378.36  550.70 
/
 2  6  7  1   85.88   88.24   96.05  107.13  120.90 
             136.63  153.97  172.60  192.30  212.89 
             234.27  256.34  279.08  302.91  329.52 
             356.09  383.49  498.37  761.30 
/
 2  6  8  1   77.77   85.49   99.77  118.78  142.02 
             168.56  197.59  228.40  260.83  294.74 
             330.02  366.65  404.63  444.00  484.78 
             527.02  571.54  773.25 1241.22 
/
 2  7  1  1  256.83  252.99  250.24  249.62  249.94 
             250.87  252.51  254.68  257.35  260.49 
             264.07  268.08  272.52  277.37  282.62 
             288.27  294.32  322.34  396.74 
/
 2  7  2  1  247.91  236.54  228.55  227.07  227.20 
             228.40  230.48  233.29  236.76  240.90 
             245.53  250.67  256.40  262.51  269.13 
             276.20  283.64  317.55  403.09 
/
 2  7  3  1  238.85  215.11  205.43  204.19  204.86 
             206.78  209.78  213.71  218.43  223.79 
             229.86  236.53  243.72  251.42  259.59 
             268.21  277.24  316.98  413.97 
/
 2  7  4  1  229.48  191.54  186.64  185.81  187.08 
             189.88  193.92  198.97  204.91  211.52 
             218.89  226.87  235.39  244.24  254.00 
             264.22  274.67  320.25  427.54 
/
 2  7  5  1  205.15  162.24  158.03  158.25  161.05 
             165.58  171.58  178.71  187.00  195.91 
             205.80  216.00  227.20  238.42  250.05 
             262.74  275.17  329.27  455.94 
/
 2  7  6  1  132.29  124.48  124.06  127.35  133.18 
             141.01  150.62  161.44  173.35  186.17 
             199.78  214.08  229.03  244.07  259.80 
             275.58  292.55  361.50  518.48 
/
 2  7  7  1   92.82   93.10   98.47  107.93  119.90 
             133.70  148.97  165.41  182.83  201.04 
             219.96  239.51  260.89  283.40  306.26 
             329.91  353.64  454.83  685.65 
/
 2  7  8  1   79.28   86.34   98.08  113.90  133.34 
             155.68  180.03  206.08  233.57  262.29 
             292.15  323.08  355.06  388.10  422.19 
             457.37  493.67  660.85 1049.12 
/
 2  8  1  1  261.95  258.36  256.19  255.52  255.82 
             256.88  258.53  260.70  263.36  266.47 
             269.93  273.91  278.31  283.11  288.32 
             293.92  299.91  327.76  401.93 
/
 2  8  2  1  255.34  247.43  239.58  238.20  238.31 
             239.34  241.24  243.82  247.08  250.83 
             255.11  259.89  265.24  270.95  277.11 
             283.82  290.81  322.96  405.79 
/
 2  8  3  1  248.50  231.70  221.14  219.66  219.97 
             221.48  224.01  227.27  231.33  235.97 
             241.30  247.10  253.52  260.44  267.72 
             275.57  283.86  320.69  412.82 
/
 2  8  4  1  241.48  214.05  204.14  203.09  203.86 
             205.96  209.14  213.22  218.11  223.82 
             230.22  237.19  244.73  252.78  261.31 
             270.46  279.90  321.69  422.04 
/
 2  8  5  1  226.93  182.55  178.12  177.64  179.40 
             182.76  187.54  193.18  199.91  207.45 
             215.67  224.51  233.90  243.79  254.77 
             265.60  276.84  326.01  444.02 
/
 2  8  6  1  179.04  145.23  142.26  143.81  148.00 
             154.04  161.68  170.58  180.52  191.25 
             202.96  215.18  227.98  241.32  255.15 
             269.47  284.18  345.94  486.78 
/
 2  8  7  1  104.47  103.74  106.32  112.82  122.28 
             133.72  146.61  160.62  175.55  191.24 
             208.91  226.95  245.70  265.12  284.73 
             304.95  325.76  413.09  611.11 
/
 2  8  8  1   82.59   87.54   97.19  110.03  125.91 
             144.09  164.08  185.53  208.20  231.91 
             256.53  281.99  308.26  335.31  363.15 
             391.77  421.86  558.90  870.19 
/
 2  9  1  1  266.41  263.48  261.67  261.28  261.74 
             262.85  264.52  266.70  269.34  272.43 
             275.95  279.89  284.25  289.00  294.16 
             299.72  305.66  333.32  406.85 
/
 2  9  2  1  262.11  256.40  250.93  249.86  249.90 
             250.96  252.74  255.14  258.10  261.59 
             265.57  270.02  274.93  280.29  286.07 
             292.27  299.04  329.52  409.08 
/
 2  9  3  1  257.54  247.36  238.18  236.81  236.84 
             238.04  240.09  242.85  246.26  250.34 
             254.89  259.97  265.65  271.70  278.29 
             285.24  292.71  326.55  413.11 
/
 2  9  4  1  252.89  236.84  225.47  224.04  224.39 
             225.90  228.35  231.66  235.60  240.27 
             245.47  251.31  257.70  264.50  271.88 
             279.75  288.07  325.21  418.03 
/
 2  9  5  1  243.33  212.23  203.24  202.23  203.13 
             205.41  208.79  213.10  218.24  224.12 
             230.67  237.83  245.56  253.81  262.55 
             272.10  282.03  325.74  431.11 
/
 2  9  6  1  223.32  174.97  170.49  170.29  172.61 
             176.61  182.09  188.70  196.25  204.62 
             213.70  223.39  233.64  244.96  256.22 
             267.91  280.01  333.14  458.23 
/
 2  9  7  1  132.74  124.88  124.52  128.03  134.21 
             142.51  152.41  163.82  176.19  189.50 
             203.61  218.44  233.93  250.06  266.22 
             283.11  300.02  372.86  536.77 
/
 2  9  8  1   93.53   93.74   99.49  109.32  121.64 
             135.80  151.46  168.32  186.18  204.88 
             224.31  244.39  265.09  286.80  311.22 
             335.61  360.12  465.42  705.84 
/
 2 10  1  1  272.99  272.39  272.03  272.35  273.23 
             274.60  276.43  278.70  281.38  284.48 
             287.97  291.86  296.13  300.80  305.86 
             311.30  317.13  344.25  416.72 
/
 2 10  2  1  272.99  272.39  272.03  272.35  273.23 
             274.60  276.43  278.70  281.38  284.48 
             287.97  291.86  296.13  300.80  305.86 
             311.30  317.13  344.25  416.72 
/
 2 10  3  1  272.99  272.39  272.03  272.35  273.23 
             274.60  276.43  278.70  281.38  284.48 
             287.97  291.86  296.13  300.80  305.86 
             311.30  317.13  344.25  416.72 
/
 2 10  4  1  272.99  272.39  272.03  272.35  273.23 
             274.60  276.43  278.70  281.38  284.48 
             287.97  291.86  296.13  300.80  305.86 
             311.30  317.13  344.25  416.72 
/
 2 10  5  1  272.99  272.39  272.03  272.35  273.23 
             274.60  276.43  278.70  281.38  284.48 
             287.97  291.86  296.13  300.80  305.86 
             311.30  317.13  344.25  416.72 
/
 2 10  6  1  272.99  272.39  272.03  272.35  273.23 
             274.60  276.43  278.70  281.38  284.48 
             287.97  291.86  296.13  300.80  305.86 
             311.30  317.13  344.25  416.72 
/
 2 10  7  1  272.99  272.39  272.03  272.35  273.23 
             274.60  276.43  278.70  281.38  284.48 
             287.97  291.86  296.13  300.80  305.86 
             311.30  317.13  344.25  416.72 
/
 2 10  8  1  272.99  272.39  272.03  272.35  273.23 
             274.60  276.43  278.70  281.38  284.48 
             287.97  291.86  296.13  300.80  305.86 
             311.30  317.13  344.25  416.72 
/
 3  1  1  1  235.90  234.26  232.05  231.56  231.88 
             232.83  234.31  236.41  239.02  242.12 
             245.69  249.70  254.15  259.01  264.28 
             269.95  276.00  304.18  377.95 
/
 3  1  2  1  218.02  198.11  193.47  192.52  193.17 
             195.11  198.20  202.24  207.04  212.62 
             218.83  225.61  232.91  240.70  248.91 
             257.53  266.54  306.17  402.04 
/
 3  1  3  1  200.05  166.29  163.31  163.35  165.45 
             169.22  174.42  180.54  187.75  196.04 
             204.76  214.05  223.85  234.09  245.30 
             256.83  268.43  318.27  433.98 
/
 3  1  4  1  167.05  145.12  143.12  144.66  148.40 
             153.94  161.02  169.33  178.68  189.01 
             199.89  211.80  223.97  236.65  249.79 
             262.82  276.71  336.02  469.42 
/
 3  1  5  1  122.43  120.06  121.37  125.50  132.05 
             140.58  150.71  162.76  175.91  189.89 
             204.69  219.91  235.73  252.12  269.06 
             285.98  303.83  378.05  547.43 
/
 3  1  6  1  101.04  101.85  107.55  116.73  128.40 
             142.07  157.36  173.98  191.69  210.31 
             229.73  250.93  273.24  296.47  320.00 
             343.72  368.16  472.51  715.73 
/
 3  1  7  1   91.08   97.15  109.17  126.05  147.10 
             171.32  198.01  226.63  256.95  288.77 
             321.97  356.52  392.42  429.69  471.84 
             513.90  557.48  746.50 1199.53 
/
 3  1  8  1   87.68   98.78  125.49  161.38  204.24 
             252.38  304.90  361.11  420.68  483.76 
             550.47  620.95  696.46  777.63  862.48 
             949.93 1040.26 1443.71 2482.58 
/
 3  2  1  1  240.22  238.64  236.60  236.08  236.32 
             237.30  238.87  240.99  243.62  246.66 
             250.22  254.23  258.76  263.62  268.89 
             274.55  280.60  308.60  382.41 
/
 3  2  2  1  223.70  206.10  200.66  199.47  199.96 
             201.72  204.60  208.34  212.92  218.21 
             224.14  230.63  237.66  245.18  253.13 
             261.38  270.13  308.90  403.05 
/
 3  2  3  1  207.33  174.12  170.73  170.56  172.30 
             175.70  180.53  186.25  193.06  200.67 
             208.96  217.83  227.23  237.61  248.29 
             259.18  270.44  319.12  431.07 
/
 3  2  4  1  181.18  153.00  150.19  151.16  154.44 
             159.50  166.05  173.78  182.63  192.36 
             202.83  213.96  225.68  237.46  250.08 
             263.16  276.10  333.84  463.88 
/
 3  2  5  1  130.66  125.56  126.27  129.79  135.65 
             143.45  153.48  164.55  176.90  190.24 
             204.15  218.75  233.97  249.78  265.62 
             282.35  299.29  370.63  534.11 
/
 3  2  6  1  104.69  104.91  109.34  117.62  128.50 
             141.35  155.77  171.46  188.19  205.79 
             224.16  244.85  266.08  287.72  310.08 
             332.60  355.81  453.82  683.72 
/
 3  2  7  1   91.69   97.45  108.52  124.01  143.38 
             165.73  190.28  216.72  244.74  274.14 
             304.80  336.67  369.73  403.98  442.24 
             481.12  521.18  693.77 1105.97 
/
 3  2  8  1   87.99   98.14  121.87  153.88  192.36 
             235.79  283.17  333.83  387.39  443.94 
             503.54  566.30  632.36  703.65  779.10 
             857.90  939.04 1293.92 2198.58 
/
 3  3  1  1  244.62  243.10  241.13  240.65  241.00 
             242.01  243.54  245.67  248.31  251.42 
             254.98  258.99  263.42  268.26  273.51 
             279.16  285.20  313.34  387.32 
/
 3  3  2  1  229.51  214.12  208.14  206.94  207.29 
             208.89  211.51  215.05  219.31  224.32 
             229.95  236.08  242.80  250.00  257.66 
             265.74  274.10  311.70  404.18 
/
 3  3  3  1  214.81  182.69  179.00  178.48  180.03 
             183.13  187.52  193.03  199.20  206.38 
             214.24  222.71  231.70  241.49  251.57 
             262.09  272.83  319.11  429.57 
/
 3  3  4  1  195.73  161.77  158.38  158.81  161.59 
             166.12  172.13  179.30  187.64  196.60 
             206.54  216.80  227.96  239.22  251.46 
             263.55  276.69  331.90  456.94 
/
 3  3  5  1  140.09  132.91  132.45  135.34  140.65 
             147.97  156.92  167.21  178.82  191.22 
             204.44  218.40  232.58  247.60  262.82 
             278.63  294.67  363.15  518.65 
/
 3  3  6  1  109.24  109.05  112.22  119.34  129.27 
             141.20  154.68  169.37  185.08  201.64 
             219.79  239.37  259.16  279.15  300.31 
             321.61  343.55  436.19  650.44 
/
 3  3  7  1   92.53   97.84  108.01  122.16  139.93 
             160.34  182.87  207.17  232.94  259.97 
             288.13  317.38  347.67  379.01  413.69 
             449.16  485.77  642.79 1015.25 
/
 3  3  8  1   88.41   97.69  118.58  146.85  181.08 
             219.88  262.30  307.57  355.37  405.72 
             458.62  514.12  572.35  633.39  700.02 
             769.75  841.51 1152.59 1930.23 
/
 3  4  1  1  250.21  248.11  246.14  245.59  245.95 
             246.89  248.50  250.64  253.28  256.39 
             259.95  263.95  268.36  273.20  278.44 
             284.07  290.09  318.01  391.91 
/
 3  4  2  1  236.57  223.09  216.18  214.91  215.10 
             216.55  219.03  222.28  226.27  230.99 
             236.32  242.14  248.54  255.44  262.67 
             270.45  278.66  315.22  405.84 
/
 3  4  3  1  223.51  192.06  188.17  187.37  188.57 
             191.29  195.26  200.26  206.17  212.86 
             220.24  228.09  236.92  246.10  255.68 
             265.63  276.11  320.56  427.52 
/
 3  4  4  1  210.00  171.45  167.81  167.72  169.95 
             173.93  179.38  185.97  193.52  201.88 
             210.93  220.99  231.22  241.92  253.06 
             265.23  277.18  330.46  451.42 
/
 3  4  5  1  159.17  142.01  140.33  142.48  147.06 
             153.58  161.65  171.16  181.81  193.17 
             205.61  218.43  232.00  246.26  260.70 
             275.59  290.93  355.72  505.10 
/
 3  4  6  1  115.01  114.38  116.60  122.39  131.10 
             141.92  154.32  167.95  182.56  198.59 
             216.02  233.86  252.44  271.75  291.26 
             311.36  332.10  418.88  619.13 
/
 3  4  7  1   94.25   98.35  107.67  120.55  136.71 
             155.29  175.86  198.06  221.60  246.29 
             272.01  298.69  326.29  354.79  385.97 
             418.78  452.12  594.47  929.49 
/
 3  4  8  1   88.97   97.46  115.65  140.33  170.45 
             204.73  242.32  282.36  324.63  369.07 
             415.64  464.33  515.24  568.42  623.96 
             685.43  748.38 1020.19 1684.18 
/
 3  5  1  1  256.07  253.32  251.35  250.73  250.99 
             252.02  253.64  255.79  258.42  261.53 
             265.08  269.06  273.47  278.29  283.51 
             289.13  295.14  323.01  396.60 
/
 3  5  2  1  244.17  232.35  224.72  223.41  223.50 
             224.82  227.06  230.15  233.89  238.26 
             243.28  248.77  254.85  261.32  268.35 
             275.82  283.58  319.01  407.72 
/
 3  5  3  1  232.77  203.70  198.32  197.31  198.21 
             200.53  204.02  208.49  213.82  219.91 
             226.89  234.36  242.39  251.00  259.99 
             269.41  279.23  322.30  425.66 
/
 3  5  4  1  221.00  182.46  178.45  178.07  179.88 
             183.32  188.03  193.98  200.87  208.58 
             216.99  226.01  235.58  245.65  256.17 
             267.10  278.43  329.45  445.01 
/
 3  5  5  1  183.62  153.16  150.23  151.50  155.35 
             161.02  168.16  176.67  186.25  196.85 
             208.04  220.32  232.91  246.04  259.17 
             273.24  287.72  348.67  489.97 
/
 3  5  6  1  123.27  121.38  122.66  127.32  134.66 
             144.10  155.22  167.61  181.85  196.93 
             212.84  229.53  246.56  264.21  282.47 
             301.33  320.13  401.25  586.25 
/
 3  5  7  1   97.41   99.60  107.67  119.34  133.95 
             150.76  169.39  189.50  210.83  233.21 
             256.51  280.66  305.60  331.33  360.41 
             389.83  420.06  547.52  846.36 
/
 3  5  8  1   89.75   97.55  113.12  134.39  160.53 
             190.45  223.30  258.27  295.23  334.01 
             374.55  416.84  460.89  506.76  554.50 
             604.16  659.55  895.76 1456.16 
/
 3  6  1  1  261.83  258.60  256.59  256.01  256.26 
             257.30  258.93  261.08  263.71  266.81 
             270.35  274.32  278.71  283.51  288.71 
             294.31  300.30  328.12  401.72 
/
 3  6  2  1  251.84  241.37  233.85  232.40  232.44 
             233.65  235.72  238.54  242.10  246.18 
             250.83  256.10  261.77  268.02  274.61 
             281.73  289.27  323.32  409.87 
/
 3  6  3  1  242.14  217.77  209.51  208.38  209.05 
             211.07  214.15  218.18  223.00  228.59 
             234.74  241.56  248.95  256.84  265.32 
             274.14  283.38  324.02  423.56 
/
 3  6  4  1  232.20  194.91  190.69  189.91  191.26 
             194.18  198.37  203.63  209.79  216.66 
             224.32  232.60  241.31  250.65  260.47 
             271.05  282.00  329.31  440.52 
/
 3  6  5  1  207.22  166.60  162.63  163.09  166.03 
             170.78  177.03  184.47  193.10  202.66 
             212.70  223.69  234.92  247.07  259.27 
             272.50  285.54  343.19  476.32 
/
 3  6  6  1  137.73  130.90  131.10  134.60  140.61 
             148.62  158.73  170.16  182.84  196.56 
             210.92  226.02  241.81  258.23  274.73 
             292.14  309.67  384.58  554.74 
/
 3  6  7  1  102.76  103.14  109.06  119.25  132.15 
             147.12  163.74  181.71  200.80  220.84 
             241.70  263.32  285.65  310.14  335.90 
             362.18  388.62  502.56  765.99 
/
 3  6  8  1   90.86   98.00  111.10  129.11  151.40 
             177.08  205.23  235.34  267.18  300.56 
             335.39  371.63  409.27  448.33  488.85 
             530.84  575.12  775.97 1244.55 
/
 3  7  1  1  267.31  263.88  261.91  261.40  261.71 
             262.76  264.35  266.51  269.14  272.23 
             275.75  279.70  284.07  288.85  294.03 
             299.61  305.58  333.33  406.91 
/
 3  7  2  1  259.34  251.09  243.25  241.90  241.94 
             243.06  244.99  247.62  250.87  254.75 
             259.12  264.03  269.43  275.25  281.63 
             288.34  295.60  328.28  412.29 
/
 3  7  3  1  251.44  232.54  222.48  221.19  221.58 
             223.20  225.82  229.36  233.58  238.55 
             244.15  250.25  256.97  264.21  271.93 
             280.11  288.73  327.12  422.06 
/
 3  7  4  1  243.39  211.13  204.77  203.73  204.63 
             206.94  210.41  214.85  220.13  226.18 
             232.90  240.26  248.18  257.01  266.09 
             275.64  285.75  329.67  434.90 
/
 3  7  5  1  226.78  182.23  178.00  177.76  179.79 
             183.60  188.89  195.32  202.45  210.94 
             219.89  229.48  239.63  250.30  261.44 
             273.02  285.75  337.72  463.10 
/
 3  7  6  1  166.67  145.72  143.71  145.95  150.73 
             157.51  165.88  175.71  186.73  198.48 
             211.35  224.64  238.86  253.40  268.61 
             284.13  300.14  367.97  523.15 
/
 3  7  7  1  110.79  110.33  113.66  121.44  132.27 
             145.15  159.61  175.31  192.06  209.67 
             228.05  247.11  268.71  290.51  313.08 
             336.41  359.89  460.38  689.14 
/
 3  7  8  1   92.73   98.77  109.66  124.63  143.25 
             164.70  188.30  213.69  240.59  268.80 
             298.19  328.72  360.34  393.05  426.86 
             461.78  497.85  665.25 1051.19 
/
 3  8  1  1  272.33  269.04  267.15  266.72  267.14 
             268.22  269.87  272.03  274.65  277.72 
             281.23  285.15  289.50  294.24  299.39 
             304.93  310.87  338.47  411.87 
/
 3  8  2  1  266.44  259.78  253.30  251.97  251.99 
             253.05  254.87  257.27  260.33  264.00 
             268.11  272.71  277.79  283.31  289.38 
             295.78  302.59  334.00  415.48 
/
 3  8  3  1  260.42  247.24  236.72  235.32  235.42 
             236.76  239.07  242.09  245.79  250.20 
             255.12  260.68  266.67  273.25  280.20 
             287.72  295.69  331.42  421.65 
/
 3  8  4  1  254.33  231.92  220.83  219.74  220.32 
             222.16  225.05  228.80  233.32  238.54 
             244.46  250.95  257.92  265.51  273.60 
             282.17  291.19  331.51  429.98 
/
 3  8  5  1  241.81  201.19  196.73  195.91  197.24 
             200.15  204.31  209.51  215.64  222.57 
             230.23  238.52  247.41  256.84  266.59 
             276.97  287.79  336.03  450.92 
/
 3  8  6  1  208.09  166.63  162.50  163.20  166.46 
             171.57  178.35  186.23  195.34  205.39 
             215.94  227.49  239.71  252.50  265.34 
             279.16  292.88  353.49  493.57 
/
 3  8  7  1  123.97  122.34  123.73  128.83  136.76 
             146.87  158.69  171.80  185.94  201.64 
             218.51  236.00  254.30  272.90  292.14 
             312.03  332.58  418.86  614.90 
/
 3  8  8  1   98.26  100.45  109.08  121.23  136.45 
             153.91  173.21  194.03  216.11  239.29 
             263.43  288.47  314.34  341.04  368.56 
             396.90  427.40  562.80  874.28 
/
 3  9  1  1  276.69  273.96  272.34  272.04  272.56 
             273.71  275.39  277.57  280.20  283.26 
             286.76  290.66  294.97  299.69  304.80 
             310.30  316.20  343.64  416.73 
/
 3  9  2  1  272.88  267.77  263.37  262.37  262.44 
             263.49  265.22  267.56  270.45  273.85 
             277.73  282.08  286.88  292.12  297.79 
             303.87  310.37  340.58  419.10 
/
 3  9  3  1  268.83  260.87  252.27  250.70  250.74 
             251.87  253.81  256.45  259.71  263.60 
             267.97  272.88  278.29  284.14  290.55 
             297.29  304.46  337.59  422.63 
/
 3  9  4  1  264.75  252.12  240.67  239.19  239.44 
             240.80  243.06  246.07  249.85  254.17 
             259.17  264.64  270.73  277.34  284.32 
             291.90  299.78  336.04  427.04 
/
 3  9  5  1  256.42  230.51  219.96  218.87  219.57 
             221.54  224.55  228.44  233.13  238.53 
             244.59  251.26  258.50  266.36  274.93 
             283.98  293.42  335.76  438.95 
/
 3  9  6  1  239.20  194.13  189.53  189.03  190.89 
             194.34  199.22  204.99  211.90  219.64 
             228.13  237.28  247.02  257.32  268.12 
             279.40  291.12  342.14  466.18 
/
 3  9  7  1  163.99  145.90  144.02  146.52  151.63 
             158.78  167.66  177.94  189.21  201.68 
             215.07  229.28  243.82  259.31  275.07 
             291.52  308.27  379.44  542.69 
/
 3  9  8  1  111.53  110.96  114.45  122.71  133.95 
             147.22  162.08  178.22  195.42  213.53 
             232.41  252.01  272.27  294.48  318.01 
             341.60  366.48  471.11  709.31 
/
 3 10  1  1  283.05  282.44  282.08  282.40  283.27 
             284.65  286.48  288.75  291.43  294.52 
             298.01  301.90  306.18  310.85  315.90 
             321.34  327.17  354.29  426.74 
/
 3 10  2  1  283.05  282.44  282.08  282.40  283.27 
             284.65  286.48  288.75  291.43  294.52 
             298.01  301.90  306.18  310.85  315.90 
             321.34  327.17  354.29  426.74 
/
 3 10  3  1  283.05  282.44  282.08  282.40  283.27 
             284.65  286.48  288.75  291.43  294.52 
             298.01  301.90  306.18  310.85  315.90 
             321.34  327.17  354.29  426.74 
/
 3 10  4  1  283.05  282.44  282.08  282.40  283.27 
             284.65  286.48  288.75  291.43  294.52 
             298.01  301.90  306.18  310.85  315.90 
             321.34  327.17  354.29  426.74 
/
 3 10  5  1  283.05  282.44  282.08  282.40  283.27 
             284.65  286.48  288.75  291.43  294.52 
             298.01  301.90  306.18  310.85  315.90 
             321.34  327.17  354.29  426.74 
/
 3 10  6  1  283.05  282.44  282.08  282.40  283.27 
             284.65  286.48  288.75  291.43  294.52 
             298.01  301.90  306.18  310.85  315.90 
             321.34  327.17  354.29  426.74 
/
 3 10  7  1  283.05  282.44  282.08  282.40  283.27 
             284.65  286.48  288.75  291.43  294.52 
             298.01  301.90  306.18  310.85  315.90 
             321.34  327.17  354.29  426.74 
/
 3 10  8  1  283.05  282.44  282.08  282.40  283.27 
             284.65  286.48  288.75  291.43  294.52 
             298.01  301.90  306.18  310.85  315.90 
             321.34  327.17  354.29  426.74 
/
 4  1  1  1  256.96  256.36  255.81  255.82  256.36 
             257.41  258.97  261.03  263.56  266.54 
             269.88  273.70  277.93  282.57  287.61 
             293.04  298.85  325.92  397.77 
/
 4  1  2  1  242.22  231.84  227.12  226.05  226.34 
             227.71  230.02  233.14  237.05  241.58 
             246.78  252.55  258.78  265.58  272.86 
             280.61  288.65  325.29  417.42 
/
 4  1  3  1  228.80  202.68  199.52  198.95  200.17 
             202.87  206.81  211.82  217.76  224.53 
             232.03  240.18  249.13  258.62  268.46 
             278.82  289.47  336.23  447.58 
/
 4  1  4  1  215.23  183.35  180.53  180.86  183.17 
             187.31  192.81  199.61  207.44  216.14 
             225.60  235.73  246.86  258.15  269.92 
             282.14  295.42  352.10  482.27 
/
 4  1  5  1  163.69  156.95  156.04  158.49  163.26 
             170.12  178.67  188.67  199.92  212.25 
             225.52  239.63  254.51  269.52  285.44 
             301.67  319.01  390.58  557.60 
/
 4  1  6  1  134.34  133.91  136.52  142.92  152.52 
             164.49  178.30  193.56  210.03  227.53 
             246.60  267.41  288.60  310.66  333.57 
             356.77  380.78  483.08  725.07 
/
 4  1  7  1  116.92  121.52  132.02  147.32  166.75 
             189.34  214.53  241.91  271.12  301.97 
             334.33  368.14  403.38  441.33  482.06 
             523.78  566.93  753.75 1204.75 
/
 4  1  8  1  112.99  122.50  146.03  179.19  219.79 
             266.10  317.14  371.98  430.52  492.76 
             558.75  628.64  703.74  784.48  868.62 
             955.66 1045.50 1448.72 2488.58 
/
 4  2  1  1  261.19  260.55  259.96  259.95  260.50 
             261.59  263.17  265.26  267.79  270.78 
             274.21  278.06  282.32  286.99  292.05 
             297.38  303.21  330.34  402.74 
/
 4  2  2  1  247.38  238.71  233.23  232.11  232.35 
             233.65  235.85  238.86  242.63  246.99 
             252.01  257.53  263.64  270.16  277.25 
             284.80  292.65  328.58  419.06 
/
 4  2  3  1  235.02  209.76  206.40  205.62  206.62 
             209.05  212.69  217.35  222.93  229.30 
             236.40  244.31  252.84  261.80  271.33 
             281.20  291.48  336.67  446.02 
/
 4  2  4  1  222.51  190.54  187.29  187.29  189.43 
             193.16  198.28  204.69  211.86  220.11 
             229.12  238.79  249.06  259.86  271.16 
             283.53  295.76  349.75  475.89 
/
 4  2  5  1  176.19  163.96  161.91  163.76  168.03 
             174.28  182.14  191.52  202.15  213.61 
             226.23  239.35  253.33  268.08  283.11 
             298.69  314.79  383.46  544.39 
/
 4  2  6  1  138.75  137.96  139.87  145.38  153.87 
             164.77  177.54  191.77  207.19  223.63 
             242.32  261.80  281.89  302.81  324.05 
             346.03  368.77  464.96  691.25 
/
 4  2  7  1  118.50  121.90  131.56  145.63  163.44 
             184.18  207.36  232.57  259.49  287.91 
             317.71  348.81  381.20  415.37  453.19 
             491.41  531.04  702.49 1111.56 
/
 4  2  8  1  113.40  122.11  142.90  172.35  208.66 
             250.25  296.13  345.39  397.88  453.54 
             512.40  574.53  640.05  711.48  786.51 
             864.12  944.85 1298.53 2203.76 
/
 4  3  1  1  265.49  264.82  264.21  264.19  264.76 
             265.88  267.51  269.60  272.17  275.18 
             278.60  282.47  286.74  291.41  296.48 
             301.94  307.80  335.03  407.36 
/
 4  3  2  1  252.71  245.28  239.63  238.50  238.72 
             239.96  242.07  244.95  248.52  252.78 
             257.56  262.95  268.79  275.20  281.98 
             289.32  296.97  332.18  421.21 
/
 4  3  3  1  241.45  217.39  213.91  212.97  213.77 
             215.95  219.28  223.60  228.80  234.76 
             241.65  249.05  257.03  265.63  274.63 
             284.09  294.09  337.66  443.83 
/
 4  3  4  1  230.09  198.53  194.93  194.57  196.34 
             199.78  204.59  210.43  217.36  224.87 
             233.38  242.56  252.35  262.68  273.51 
             284.82  296.68  348.77  471.40 
/
 4  3  5  1  196.66  171.99  169.00  170.19  173.89 
             179.52  186.67  195.26  205.01  215.93 
             227.59  240.11  253.21  266.95  281.26 
             296.14  311.51  376.68  529.27 
/
 4  3  6  1  144.11  142.95  144.13  148.77  156.23 
             165.97  177.56  190.65  204.95  221.31 
             238.48  256.53  275.43  294.73  315.27 
             335.47  356.92  447.56  659.92 
/
 4  3  7  1  121.17  122.79  131.28  144.15  160.41 
             179.38  200.59  223.66  248.32  274.35 
             301.63  330.09  359.69  390.41  425.12 
             460.64  496.14  651.90 1022.99 
/
 4  3  8  1  113.93  121.89  140.09  165.99  198.13 
             235.14  276.00  319.87  366.58  416.01 
             468.13  522.98  580.63  641.18  707.86 
             776.54  848.78 1157.92 1937.39 
/
 4  4  1  1  270.98  269.64  268.79  268.71  269.27 
             270.39  272.03  274.15  276.74  279.76 
             283.21  287.06  291.33  296.01  301.08 
             306.55  312.41  339.67  412.14 
/
 4  4  2  1  259.32  252.92  246.57  245.39  245.50 
             246.69  248.72  251.48  254.90  259.00 
             263.59  268.72  274.43  280.54  287.18 
             294.28  301.77  336.03  423.17 
/
 4  4  3  1  249.15  227.14  222.10  221.05  221.69 
             223.64  226.67  230.72  235.61  241.23 
             247.55  254.49  262.09  270.15  278.70 
             287.72  297.15  339.11  442.15 
/
 4  4  4  1  238.96  207.41  203.57  202.89  204.28 
             207.26  211.54  216.92  223.27  230.46 
             238.41  247.02  256.25  266.04  276.33 
             286.94  298.61  348.42  465.57 
/
 4  4  5  1  215.93  180.77  177.35  177.99  181.05 
             186.01  192.54  200.32  209.37  219.40 
             230.31  241.66  254.00  266.95  280.04 
             294.10  308.14  370.24  516.19 
/
 4  4  6  1  153.84  149.17  149.60  153.35  159.78 
             168.37  178.73  190.55  204.47  219.53 
             235.48  252.03  269.77  287.91  306.76 
             325.72  345.92  430.24  627.31 
/
 4  4  7  1  124.81  125.18  131.73  143.24  157.90 
             175.08  194.32  215.29  237.70  261.38 
             286.18  312.04  338.91  366.77  398.40 
             430.74  462.97  604.00  937.56 
/
 4  4  8  1  114.61  121.87  137.62  160.15  188.29 
             220.83  256.80  295.46  336.62  380.12 
             425.88  473.90  524.21  576.87  631.96 
             693.21  756.29 1025.69 1688.38 
/
 4  5  1  1  276.75  274.66  273.54  273.39  273.93 
             275.05  276.70  278.83  281.42  284.45 
             287.90  291.77  296.05  300.73  305.81 
             311.28  317.14  344.41  416.98 
/
 4  5  2  1  266.58  260.70  253.83  252.67  252.77 
             253.86  255.80  258.45  261.77  265.64 
             270.05  275.03  280.46  286.42  292.77 
             299.68  306.90  340.22  425.69 
/
 4  5  3  1  257.55  238.63  231.26  230.06  230.59 
             232.33  235.11  238.82  243.26  248.47 
             254.34  260.83  267.88  275.46  283.54 
             292.09  301.07  341.14  440.79 
/
 4  5  4  1  248.56  217.27  213.31  212.38  213.43 
             215.97  219.74  224.54  230.25  236.78 
             244.04  251.97  260.50  269.60  279.31 
             289.81  300.63  347.73  460.00 
/
 4  5  5  1  230.32  190.97  187.29  187.31  189.80 
             194.13  200.01  206.92  215.03  224.03 
             234.15  244.68  255.84  268.06  280.34 
             293.10  306.32  364.32  503.26 
/
 4  5  6  1  165.84  157.36  156.74  159.58  164.95 
             172.35  182.03  193.12  205.38  218.98 
             233.38  248.66  264.75  281.62  298.67 
             316.74  335.04  413.88  596.56 
/
 4  5  7  1  129.62  129.37  133.74  143.34  156.24 
             171.55  188.80  207.62  227.79  249.10 
             271.45  294.74  318.94  345.03  373.48 
             401.72  431.43  557.52  855.09 
/
 4  5  8  1  115.51  122.07  135.55  154.88  179.18 
             207.43  238.61  272.25  308.09  345.92 
             385.65  427.24  470.68  516.01  563.25 
             613.20  667.68  902.00 1460.53 
/
 4  6  1  1  282.43  279.75  278.39  278.18  278.72 
             279.84  281.49  283.63  286.23  289.26 
             292.72  296.59  300.86  305.54  310.61 
             316.08  321.93  349.19  421.79 
/
 4  6  2  1  273.90  267.82  261.63  260.41  260.47 
             261.49  263.36  265.89  269.04  272.75 
             276.98  281.80  287.02  292.71  298.95 
             305.53  312.53  344.97  428.46 
/
 4  6  3  1  266.11  250.75  241.44  240.17  240.50 
             242.01  244.50  247.87  251.94  256.74 
             262.10  268.12  274.69  281.79  289.39 
             297.32  305.82  344.06  439.80 
/
 4  6  4  1  258.40  228.96  224.28  223.21  223.97 
             226.11  229.38  233.62  238.71  244.56 
             251.12  258.32  266.12  274.86  283.88 
             293.53  303.50  347.84  454.84 
/
 4  6  5  1  242.74  202.98  198.83  198.48  200.48 
             204.18  209.12  215.40  222.69  230.57 
             239.48  249.09  259.33  270.14  281.48 
             293.95  306.31  360.08  490.56 
/
 4  6  6  1  187.35  169.36  166.70  168.60  173.00 
             179.49  187.74  197.30  208.26  220.34 
             233.13  247.07  261.43  276.66  292.68 
             308.95  325.80  397.77  565.74 
/
 4  6  7  1  136.21  135.33  138.13  145.35  156.08 
             169.30  184.40  201.00  218.84  237.76 
             257.62  278.36  300.27  324.87  349.67 
             375.39  401.36  513.13  773.53 
/
 4  6  8  1  117.54  122.54  133.94  150.26  170.91 
             194.92  221.56  250.40  281.12  313.54 
             347.53  383.04  420.03  458.52  498.51 
             540.03  584.81  784.28 1249.52 
/
 4  7  1  1  287.82  284.83  283.31  283.07  283.60 
             284.74  286.40  288.55  291.15  294.19 
             297.64  301.51  305.79  310.46  315.52 
             320.99  326.83  354.07  426.67 
/
 4  7  2  1  281.06  275.10  269.67  268.47  268.61 
             269.59  271.38  273.82  276.84  280.40 
             284.48  289.03  294.06  299.54  305.47 
             311.94  318.72  350.09  431.55 
/
 4  7  3  1  274.63  262.94  252.67  251.20  251.40 
             252.72  254.94  257.95  261.72  266.05 
             271.05  276.54  282.64  289.15  296.25 
             303.81  311.69  348.02  439.77 
/
 4  7  4  1  268.30  245.85  236.61  235.50  236.06 
             237.86  240.68  244.38  248.91  254.20 
             260.20  266.77  273.96  281.67  289.92 
             298.67  307.88  349.08  450.69 
/
 4  7  5  1  255.44  217.13  212.77  211.95  213.28 
             216.20  220.41  225.71  231.96  239.06 
             246.92  255.47  264.66  274.43  284.74 
             295.56  306.87  357.08  477.90 
/
 4  7  6  1  225.21  184.46  180.47  181.13  184.47 
             189.72  196.55  204.77  214.14  224.58 
             235.91  248.07  260.96  274.07  288.22 
             302.94  318.23  382.61  534.91 
/
 4  7  7  1  145.71  144.12  145.39  150.63  158.91 
             169.58  182.16  196.29  211.64  228.03 
             245.32  264.95  285.20  306.26  327.64 
             350.40  373.41  471.60  698.65 
/
 4  7  8  1  122.24  123.72  132.92  146.42  163.62 
             183.62  205.89  230.06  255.85  283.07 
             311.59  341.34  372.26  404.35  437.59 
             472.01  507.63  673.30 1056.83 
/
 4  8  1  1  292.74  289.79  288.24  288.02  288.57 
             289.73  291.41  293.56  296.17  299.21 
             302.67  306.54  310.81  315.47  320.54 
             325.99  331.83  359.04  431.63 
/
 4  8  2  1  287.80  282.40  278.26  277.04  277.09 
             278.12  279.86  282.12  285.02  288.44 
             292.35  296.73  301.56  306.84  312.67 
             318.82  325.38  355.68  435.30 
/
 4  8  3  1  282.85  274.21  264.88  263.35  263.35 
             264.51  266.51  269.23  272.60  276.56 
             281.16  286.20  291.74  297.87  304.36 
             311.39  318.88  352.96  440.32 
/
 4  8  4  1  277.99  263.30  251.26  250.02  250.36 
             251.84  254.25  257.46  261.46  266.12 
             271.32  277.18  283.60  290.45  297.90 
             305.85  314.28  352.21  447.26 
/
 4  8  5  1  268.14  234.40  229.56  228.47  229.28 
             231.49  234.81  239.10  244.25  250.16 
             256.79  264.08  271.98  280.45  289.46 
             298.99  309.01  354.84  465.64 
/
 4  8  6  1  248.08  203.06  198.69  198.54  200.73 
             204.74  210.13  216.84  224.60  233.27 
             242.75  252.95  263.80  275.25  287.25 
             299.78  313.51  370.30  507.15 
/
 4  8  7  1  167.33  157.85  157.55  160.79  166.71 
             174.74  184.51  195.86  209.20  223.54 
             239.00  255.12  272.10  289.88  308.44 
             327.74  347.13  431.68  624.88 
/
 4  8  8  1  130.59  130.16  134.81  145.04  158.63 
             174.62  192.57  212.13  233.07  255.19 
             278.39  302.57  327.69  353.72  380.64 
             408.43  439.84  573.00  881.20 
/
 4  9  1  1  297.01  294.50  293.11  292.96  293.56 
             294.76  296.47  298.65  301.27  304.32 
             307.78  311.65  315.92  320.58  325.63 
             331.08  336.91  364.09  436.64 
/
 4  9  2  1  293.86  289.56  286.74  285.86  286.03 
             287.02  288.72  290.99  293.70  296.99 
             300.75  304.97  309.62  314.71  320.22 
             326.14  332.48  361.85  439.25 
/
 4  9  3  1  290.51  283.94  277.81  276.39  276.40 
             277.45  279.21  281.70  284.77  288.40 
             292.54  297.26  302.38  307.96  313.99 
             320.46  327.49  359.43  442.22 
/
 4  9  4  1  287.20  278.32  268.26  266.74  266.78 
             267.98  270.01  272.77  276.25  280.25 
             284.81  289.99  295.60  301.70  308.39 
             315.43  323.06  357.56  445.92 
/
 4  9  5  1  280.52  263.17  249.71  248.66  249.17 
             250.82  253.41  256.81  260.93  265.76 
             271.34  277.47  284.24  291.55  299.36 
             307.69  316.37  356.28  456.14 
/
 4  9  6  1  266.94  227.69  223.12  222.16  223.30 
             225.96  229.85  234.78  240.63  247.31 
             254.74  262.87  271.65  281.02  290.95 
             301.42  312.39  360.96  480.87 
/
 4  9  7  1  225.30  184.79  180.52  181.41  185.10 
             190.77  197.99  206.69  216.59  227.47 
             239.38  252.22  265.72  279.92  294.80 
             309.71  325.77  393.91  554.03 
/
 4  9  8  1  146.47  144.70  146.07  151.62  160.31 
             171.43  184.52  199.13  214.97  231.86 
             249.68  268.32  288.47  310.42  333.01 
             355.90  380.23  482.52  719.01 
/
 4 10  1  1  303.16  302.54  302.18  302.49  303.37 
             304.75  306.58  308.84  311.53  314.62 
             318.11  321.99  326.27  330.93  335.98 
             341.42  347.24  374.35  446.77 
/
 4 10  2  1  303.16  302.54  302.18  302.49  303.37 
             304.75  306.58  308.84  311.53  314.62 
             318.11  321.99  326.27  330.93  335.98 
             341.42  347.24  374.35  446.77 
/
 4 10  3  1  303.16  302.54  302.18  302.49  303.37 
             304.75  306.58  308.84  311.53  314.62 
             318.11  321.99  326.27  330.93  335.98 
             341.42  347.24  374.35  446.77 
/
 4 10  4  1  303.16  302.54  302.18  302.49  303.37 
             304.75  306.58  308.84  311.53  314.62 
             318.11  321.99  326.27  330.93  335.98 
             341.42  347.24  374.35  446.77 
/
 4 10  5  1  303.16  302.54  302.18  302.49  303.37 
             304.75  306.58  308.84  311.53  314.62 
             318.11  321.99  326.27  330.93  335.98 
             341.42  347.24  374.35  446.77 
/
 4 10  6  1  303.16  302.54  302.18  302.49  303.37 
             304.75  306.58  308.84  311.53  314.62 
             318.11  321.99  326.27  330.93  335.98 
             341.42  347.24  374.35  446.77 
/
 4 10  7  1  303.16  302.54  302.18  302.49  303.37 
             304.75  306.58  308.84  311.53  314.62 
             318.11  321.99  326.27  330.93  335.98 
             341.42  347.24  374.35  446.77 
/
 4 10  8  1  303.16  302.54  302.18  302.49  303.37 
             304.75  306.58  308.84  311.53  314.62 
             318.11  321.99  326.27  330.93  335.98 
             341.42  347.24  374.35  446.77 
/
 5  1  1  1  277.29  276.97  276.82  277.13  277.91 
             279.15  280.82  282.94  285.49  288.44 
             291.80  295.57  299.72  304.27  309.21 
             314.52  320.22  346.80  417.74 
/
 5  1  2  1  264.06  259.82  255.45  254.62  254.88 
             256.09  258.10  260.83  264.22  268.22 
             272.87  277.99  283.68  289.80  296.48 
             303.58  311.13  345.90  434.72 
/
 5  1  3  1  253.14  233.68  230.90  230.17  230.95 
             233.02  236.18  240.30  245.33  251.26 
             257.83  265.07  272.98  281.37  290.28 
             299.77  309.60  353.58  462.13 
/
 5  1  4  1  242.45  216.04  213.06  212.81  214.48 
             217.75  222.36  228.13  234.93  242.63 
             251.15  260.39  270.29  280.79  291.70 
             303.26  315.79  368.82  496.31 
/
 5  1  5  1  213.85  191.80  189.40  190.49  194.05 
             199.62  206.77  215.43  225.32  236.40 
             248.27  261.36  274.96  289.27  303.77 
             319.33  335.46  404.53  568.84 
/
 5  1  6  1  166.40  165.28  166.44  171.06  178.64 
             188.66  200.69  214.41  229.55  246.56 
             265.13  284.88  304.93  326.31  348.14 
             370.83  394.38  494.85  734.80 
/
 5  1  7  1  145.20  146.27  155.07  169.08  187.03 
             208.23  232.15  258.35  286.52  316.43 
             347.97  381.06  415.68  453.88  493.95 
             535.03  577.76  763.67 1211.65 
/
 5  1  8  1  138.13  146.23  167.20  198.02  236.57 
             281.17  330.70  384.32  441.89  503.32 
             568.66  638.00  713.05  793.46  876.43 
             963.83 1052.51 1454.61 2493.20 
/
 5  2  1  1  281.50  281.13  280.92  281.20  281.97 
             283.21  284.90  287.04  289.60  292.58 
             295.96  299.74  303.92  308.49  313.45 
             318.79  324.51  351.19  422.39 
/
 5  2  2  1  269.00  265.62  260.87  260.03  260.26 
             261.44  263.38  266.05  269.40  273.31 
             277.78  282.84  288.37  294.40  300.87 
             307.90  315.26  349.26  436.79 
/
 5  2  3  1  258.81  240.26  237.23  236.38  237.04 
             238.94  241.95  245.91  250.71  256.27 
             262.53  269.44  276.94  284.99  293.66 
             302.70  312.21  354.90  460.73 
/
 5  2  4  1  248.89  222.79  219.54  219.03  220.42 
             223.36  227.59  232.95  239.30  246.52 
             254.54  263.27  272.66  282.65  293.20 
             304.51  316.42  367.81  490.84 
/
 5  2  5  1  229.39  198.16  195.54  196.18  199.36 
             204.37  210.96  219.10  228.26  238.65 
             249.98  261.84  274.76  288.36  302.19 
             317.04  331.96  398.22  556.03 
/
 5  2  6  1  172.24  169.80  170.36  174.25  180.96 
             190.00  200.97  213.57  227.73  244.20 
             261.46  279.74  298.64  318.87  339.54 
             360.45  382.70  477.53  701.72 
/
 5  2  7  1  147.91  148.24  155.16  167.80  184.19 
             203.60  225.53  249.56  275.42  302.90 
             331.86  362.22  393.95  428.56  465.38 
             503.03  542.22  711.54 1120.49 
/
 5  2  8  1  138.62  146.00  164.46  191.74  226.09 
             266.01  310.35  358.35  409.84  464.68 
             522.85  584.41  649.43  720.33  794.88 
             872.86  953.25 1304.71 2208.56 
/
 5  3  1  1  285.78  285.37  285.11  285.37  286.14 
             287.39  289.09  291.25  293.83  296.82 
             300.22  304.03  308.22  312.81  317.79 
             323.15  328.90  355.66  427.09 
/
 5  3  2  1  274.12  270.96  266.56  265.74  265.98 
             267.10  269.03  271.64  274.88  278.70 
             283.06  288.01  293.39  299.25  305.67 
             312.45  319.79  353.05  439.33 
/
 5  3  3  1  264.70  248.48  244.21  243.25  243.80 
             245.59  248.38  252.11  256.59  261.85 
             267.79  274.37  281.52  289.21  297.42 
             306.11  315.27  356.58  459.39 
/
 5  3  4  1  255.63  230.19  226.75  226.02  227.15 
             229.77  233.63  238.56  244.44  251.17 
             258.67  266.87  275.72  285.17  295.18 
             306.20  317.47  366.49  485.17 
/
 5  3  5  1  237.61  205.44  202.36  202.81  205.49 
             210.02  216.09  223.56  232.14  241.69 
             252.11  263.28  275.55  288.09  301.19 
             315.43  329.65  392.22  541.92 
/
 5  3  6  1  182.55  175.26  175.20  178.37  184.21 
             192.25  202.13  213.96  227.58  242.38 
             258.37  275.11  293.18  311.78  330.69 
             350.88  371.70  460.34  670.63 
/
 5  3  7  1  151.26  151.10  156.19  167.12  181.85 
             199.45  219.38  241.27  264.85  289.91 
             316.33  344.01  372.93  404.33  438.05 
             472.67  508.48  662.34 1030.28 
/
 5  3  8  1  139.22  145.92  162.03  185.93  216.23 
             251.61  290.90  333.51  379.20  427.78 
             479.19  533.43  590.57  650.66  717.09 
             785.86  856.85 1164.55 1942.66 
/
 5  4  1  1  291.25  290.14  289.62  289.79  290.53 
             291.77  293.48  295.64  298.23  301.23 
             304.65  308.46  312.67  317.28  322.27 
             327.64  333.40  360.24  431.87 
/
 5  4  2  1  280.54  276.97  272.80  271.84  272.06 
             273.21  275.05  277.60  280.75  284.47 
             288.72  293.48  298.80  304.53  310.71 
             317.44  324.51  357.11  442.12 
/
 5  4  3  1  271.88  258.03  251.93  250.79  251.22 
             252.83  255.46  258.90  263.17  268.13 
             273.69  279.91  286.70  294.03  301.87 
             310.20  319.02  358.70  458.32 
/
 5  4  4  1  263.67  238.31  234.76  233.87  234.77 
             237.09  240.58  245.08  250.49  256.71 
             263.67  271.32  279.61  288.56  298.34 
             308.53  319.12  365.89  479.78 
/
 5  4  5  1  247.26  213.80  210.27  210.29  212.67 
             216.79  222.31  229.03  236.74  245.60 
             255.30  265.75  276.90  288.67  301.57 
             314.52  327.98  386.65  528.98 
/
 5  4  6  1  190.34  182.45  181.24  183.68  188.65 
             196.01  205.16  216.03  228.20  241.59 
             256.38  271.93  288.41  305.30  323.44 
             341.62  360.89  443.39  638.08 
/
 5  4  7  1  155.50  154.84  158.54  167.41  180.29 
             195.98  213.88  233.62  254.91  277.58 
             301.48  326.55  352.71  381.49  411.97 
             443.23  475.73  614.78  945.69 
/
 5  4  8  1  140.17  146.02  159.93  180.65  207.06 
             238.01  272.41  309.85  349.99  392.61 
             437.63  485.02  534.77  586.95  642.27 
             703.02  764.98 1034.08 1693.95 
/
 5  5  1  1  297.00  295.12  294.30  294.37  295.06 
             296.29  298.00  300.16  302.75  305.77 
             309.19  313.02  317.24  321.85  326.86 
             332.24  338.02  364.91  436.71 
/
 5  5  2  1  287.69  283.45  279.40  278.43  278.61 
             279.66  281.50  283.93  287.00  290.62 
             294.76  299.46  304.58  310.16  316.19 
             322.65  329.67  361.63  444.72 
/
 5  5  3  1  279.89  268.62  260.23  259.09  259.41 
             260.86  263.26  266.46  270.45  275.06 
             280.35  286.22  292.58  299.53  306.99 
             314.95  323.26  361.37  457.82 
/
 5  5  4  1  272.57  247.22  243.68  242.67  243.39 
             245.42  248.56  252.64  257.58  263.29 
             269.70  276.78  284.75  293.21  302.17 
             311.62  321.71  365.95  475.20 
/
 5  5  5  1  257.90  223.43  219.54  219.13  220.96 
             224.50  229.45  235.60  242.80  250.92 
             259.79  269.49  279.75  290.75  302.34 
             314.47  327.13  382.76  516.78 
/
 5  5  6  1  206.76  192.68  189.45  191.06  195.33 
             201.68  209.74  219.27  230.28  242.51 
             255.55  269.83  284.64  300.40  317.05 
             334.04  351.69  427.70  607.81 
/
 5  5  7  1  161.01  159.82  162.26  169.33  180.01 
             193.56  209.32  226.83  245.81  266.07 
             287.48  309.95  333.41  360.19  387.20 
             415.39  444.64  568.69  863.35 
/
 5  5  8  1  142.43  146.28  158.20  175.93  198.64 
             225.27  255.04  287.50  322.29  359.23 
             398.18  439.10  481.96  526.76  573.56 
             623.79  677.79  911.16 1466.54 
/
 5  6  1  1  302.65  300.16  299.06  299.05  299.71 
             300.92  302.62  304.79  307.39  310.41 
             313.84  317.67  321.90  326.53  331.54 
             336.93  342.72  369.67  441.62 
/
 5  6  2  1  294.90  290.15  286.37  285.34  285.47 
             286.55  288.26  290.68  293.67  297.18 
             301.21  305.72  310.69  316.12  322.00 
             328.31  335.04  366.30  447.92 
/
 5  6  3  1  288.08  279.00  269.43  268.10  268.33 
             269.65  271.86  274.84  278.51  282.88 
             287.78  293.31  299.29  305.88  312.97 
             320.43  328.48  364.85  457.72 
/
 5  6  4  1  281.76  260.66  253.59  252.55  253.12 
             254.90  257.71  261.39  265.86  271.21 
             277.22  283.82  291.04  298.82  307.14 
             315.98  325.30  367.06  471.12 
/
 5  6  5  1  269.02  234.54  230.45  229.68  231.01 
             233.93  238.14  243.47  249.77  256.95 
             264.94  273.65  283.04  293.06  303.66 
             314.81  326.48  378.64  504.70 
/
 5  6  6  1  243.91  203.80  200.20  200.83  204.13 
             209.46  216.43  224.86  234.50  245.23 
             256.98  269.62  283.09  297.30  312.24 
             327.29  343.44  412.80  577.99 
/
 5  6  7  1  168.39  166.64  167.82  173.19  181.82 
             193.05  206.39  221.48  238.03  255.80 
             274.66  294.50  317.23  340.30  364.46 
             389.60  415.12  525.77  784.17 
/
 5  6  8  1  146.45  147.27  156.91  171.82  191.02 
             213.63  238.97  266.64  296.32  327.82 
             361.01  395.80  432.17  470.10  509.60 
             550.69  595.85  792.90 1256.87 
/
 5  7  1  1  308.03  305.18  303.89  303.80  304.44 
             305.65  307.35  309.52  312.12  315.15 
             318.59  322.43  326.66  331.29  336.31 
             341.72  347.51  374.50  446.57 
/
 5  7  2  1  301.93  297.01  293.62  292.57  292.79 
             293.75  295.49  297.76  300.66  304.08 
             307.99  312.37  317.20  322.48  328.20 
             334.35  340.92  371.50  451.34 
/
 5  7  3  1  296.27  288.08  279.36  277.95  278.11 
             279.23  281.27  284.03  287.52  291.54 
             296.12  301.32  306.94  313.06  319.77 
             326.84  334.45  369.25  458.43 
/
 5  7  4  1  291.01  276.46  265.12  263.90  264.32 
             265.95  268.45  271.83  275.88  280.67 
             286.03  292.07  298.67  305.83  313.52 
             321.71  330.38  369.42  467.99 
/
 5  7  5  1  280.43  247.38  243.30  242.29  243.21 
             245.56  249.07  253.60  259.02  265.26 
             272.24  279.92  288.25  297.19  306.70 
             316.76  327.34  375.56  492.61 
/
 5  7  6  1  259.30  217.43  213.40  213.52  216.03 
             220.33  226.16  233.39  241.73  251.06 
             261.26  272.25  283.95  296.31  309.28 
             323.45  337.59  400.19  550.10 
/
 5  7  7  1  183.50  176.36  176.27  179.97  186.57 
             195.49  206.34  218.81  232.67  247.72 
             265.20  283.36  302.65  322.94  343.72 
             365.37  387.88  484.15  709.08 
/
 5  7  8  1  152.44  152.01  157.49  169.24  184.95 
             203.58  224.57  247.56  272.29  298.55 
             326.21  355.19  385.43  416.92  449.64 
             483.60  520.20  683.88 1065.68 
/
 5  8  1  1  312.93  310.09  308.71  308.61  309.24 
             310.45  312.16  314.33  316.94  319.98 
             323.42  327.27  331.51  336.15  341.17 
             346.58  352.38  379.40  451.59 
/
 5  8  2  1  308.53  303.89  301.07  300.19  300.36 
             301.36  303.06  305.27  308.09  311.41 
             315.21  319.46  324.17  329.31  334.88 
             340.87  347.28  376.99  455.33 
/
 5  8  3  1  304.17  296.92  290.26  288.71  288.73 
             289.75  291.64  294.21  297.39  301.14 
             305.42  310.29  315.57  321.34  327.56 
             334.35  341.47  374.34  459.97 
/
 5  8  4  1  300.09  290.09  278.44  277.05  277.29 
             278.61  280.80  283.74  287.43  291.68 
             296.59  301.99  308.01  314.45  321.50 
             329.04  336.92  373.28  465.94 
/
 5  8  5  1  291.88  266.23  258.47  257.39  258.00 
             259.87  262.76  266.54  271.11  276.42 
             282.41  289.05  296.29  304.11  312.48 
             321.63  331.36  374.81  482.11 
/
 5  8  6  1  275.38  234.79  230.33  229.67  231.29 
             234.60  239.26  245.08  251.94  259.70 
             268.31  277.68  287.75  298.47  309.81 
             321.71  334.17  389.04  522.82 
/
 5  8  7  1  201.43  192.46  189.73  191.77  196.47 
             203.30  212.01  222.31  234.00  246.95 
             261.05  276.19  291.90  308.88  326.21 
             344.69  363.53  445.65  636.08 
/
 5  8  8  1  162.06  160.59  163.23  170.82  182.19 
             196.50  213.01  231.29  251.07  272.16 
             294.43  317.80  342.18  367.55  393.90 
             421.76  452.80  584.40  890.72 
/
 5  9  1  1  317.17  314.73  313.46  313.40  314.05 
             315.28  317.01  319.20  321.83  324.87 
             328.32  332.18  336.43  341.07  346.10 
             351.52  357.33  384.37  456.64 
/
 5  9  2  1  314.42  310.61  308.25  307.61  307.96 
             309.05  310.74  312.98  315.72  318.94 
             322.62  326.74  331.29  336.27  341.66 
             347.47  353.69  382.59  459.17 
/
 5  9  3  1  311.48  305.81  301.59  300.22  300.20 
             301.14  302.91  305.31  308.28  311.78 
             315.79  320.29  325.25  330.66  336.52 
             342.82  349.55  380.59  462.15 
/
 5  9  4  1  308.67  301.04  293.43  291.94  291.92 
             293.00  294.93  297.54  300.77  304.58 
             308.93  313.83  319.23  325.08  331.51 
             338.30  345.52  378.99  465.70 
/
 5  9  5  1  303.03  291.38  276.65  275.65  276.09 
             277.59  280.02  283.19  287.09  291.57 
             296.73  302.48  308.70  315.57  322.95 
             330.85  339.26  377.45  474.47 
/
 5  9  6  1  291.69  257.03  252.77  251.69  252.51 
             254.72  258.06  262.36  267.52  273.48 
             280.17  287.55  295.58  304.22  313.44 
             323.22  333.54  379.77  496.92 
/
 5  9  7  1  263.43  217.82  213.61  213.75  216.48 
             221.22  227.47  235.12  243.91  253.71 
             264.42  276.26  288.57  301.56  315.74 
             330.02  344.88  411.48  567.11 
/
 5  9  8  1  183.85  176.89  176.86  180.85  187.83 
             197.18  208.50  221.47  235.85  251.46 
             268.13  286.09  306.52  327.45  348.87 
             371.74  394.97  494.98  729.81 
/
 5 10  1  1  323.27  322.65  322.28  322.59  323.47 
             324.84  326.67  328.94  331.62  334.71 
             338.20  342.08  346.36  351.02  356.07 
             361.50  367.32  394.42  466.80 
/
 5 10  2  1  323.27  322.65  322.28  322.59  323.47 
             324.84  326.67  328.94  331.62  334.71 
             338.20  342.08  346.36  351.02  356.07 
             361.50  367.32  394.42  466.80 
/
 5 10  3  1  323.27  322.65  322.28  322.59  323.47 
             324.84  326.67  328.94  331.62  334.71 
             338.20  342.08  346.36  351.02  356.07 
             361.50  367.32  394.42  466.80 
/
 5 10  4  1  323.27  322.65  322.28  322.59  323.47 
             324.84  326.67  328.94  331.62  334.71 
             338.20  342.08  346.36  351.02  356.07 
             361.50  367.32  394.42  466.80 
/
 5 10  5  1  323.27  322.65  322.28  322.59  323.47 
             324.84  326.67  328.94  331.62  334.71 
             338.20  342.08  346.36  351.02  356.07 
             361.50  367.32  394.42  466.80 
/
 5 10  6  1  323.27  322.65  322.28  322.59  323.47 
             324.84  326.67  328.94  331.62  334.71 
             338.20  342.08  346.36  351.02  356.07 
             361.50  367.32  394.42  466.80 
/
 5 10  7  1  323.27  322.65  322.28  322.59  323.47 
             324.84  326.67  328.94  331.62  334.71 
             338.20  342.08  346.36  351.02  356.07 
             361.50  367.32  394.42  466.80 
/
 5 10  8  1  323.27  322.65  322.28  322.59  323.47 
             324.84  326.67  328.94  331.62  334.71 
             338.20  342.08  346.36  351.02  356.07 
             361.50  367.32  394.42  466.80 
/
 6  1  1  1  297.47  297.17  297.06  297.44  298.29 
             299.60  301.35  303.52  306.10  309.08 
             312.46  316.22  320.38  324.91  329.83 
             335.12  340.78  367.18  437.70 
/
 6  1  2  1  284.79  282.83  280.37  279.89  280.30 
             281.48  283.37  285.94  289.12  292.87 
             297.17  301.97  307.29  313.07  319.43 
             326.16  333.33  366.51  453.18 
/
 6  1  3  1  275.17  261.52  259.03  258.37  259.03 
             260.80  263.57  267.25  271.75  276.98 
             282.84  289.38  296.52  304.22  312.56 
             321.35  330.65  372.50  478.32 
/
 6  1  4  1  266.33  245.02  242.32  241.89  243.14 
             245.80  249.68  254.63  260.55  267.36 
             274.95  283.29  292.32  301.98  312.53 
             323.63  335.20  385.85  510.14 
/
 6  1  5  1  249.15  222.14  219.75  220.53  223.55 
             228.22  234.56  242.18  251.11  261.10 
             272.01  283.75  296.26  309.91  323.81 
             338.32  353.41  420.77  583.39 
/
 6  1  6  1  201.17  195.13  195.39  198.85  205.08 
             213.66  224.23  236.53  251.23  267.36 
             284.66  302.83  322.46  342.75  364.01 
             386.21  408.71  507.90  746.06 
/
 6  1  7  1  173.65  173.62  179.33  191.50  208.00 
             227.89  250.58  275.65  302.80  331.81 
             362.55  394.95  428.96  467.58  506.55 
             547.19  589.59  774.62 1221.88 
/
 6  1  8  1  162.95  169.84  188.75  217.52  254.23 
             297.23  345.28  397.76  454.41  515.11 
             579.82  648.65  723.75  803.04  886.33 
             972.51 1061.50 1461.84 2499.11 
/
 6  2  1  1  301.67  301.32  301.15  301.51  302.36 
             303.67  305.43  307.61  310.20  313.20 
             316.60  320.38  324.56  329.11  334.05 
             339.37  345.05  371.56  442.37 
/
 6  2  2  1  289.64  287.75  285.41  284.90  285.27 
             286.45  288.35  290.85  293.99  297.68 
             301.90  306.63  311.85  317.55  323.80 
             330.42  337.48  370.20  455.92 
/
 6  2  3  1  280.53  268.38  265.05  264.28  264.84 
             266.50  269.12  272.64  276.93  281.89 
             287.56  293.85  300.72  308.15  316.12 
             324.62  333.63  374.29  477.17 
/
 6  2  4  1  272.29  251.37  248.48  247.87  248.93 
             251.36  254.95  259.58  265.15  271.55 
             278.73  286.64  295.21  304.61  314.63 
             325.17  336.25  384.83  504.90 
/
 6  2  5  1  256.14  228.36  225.55  225.93  228.56 
             233.02  238.94  246.09  254.32  263.74 
             273.77  284.88  296.74  309.29  323.01 
             336.87  351.30  415.07  569.09 
/
 6  2  6  1  206.78  199.90  199.65  202.49  207.97 
             215.67  225.28  237.32  250.72  265.57 
             281.44  298.77  316.85  335.93  355.96 
             376.32  397.75  490.81  713.00 
/
 6  2  7  1  176.68  176.22  180.72  191.01  205.79 
             223.83  244.50  267.40  292.22  318.77 
             346.90  376.54  407.63  442.73  478.98 
             516.27  554.36  722.73 1129.07 
/
 6  2  8  1  163.51  169.71  186.31  211.72  244.33 
             282.68  325.53  372.39  422.94  477.00 
             534.52  595.53  660.10  731.22  805.25 
             882.06  962.01 1312.38 2214.81 
/
 6  3  1  1  305.94  305.55  305.34  305.68  306.52 
             307.84  309.61  311.80  314.41  317.43 
             320.84  324.64  328.83  333.41  338.36 
             343.70  349.41  376.02  447.09 
/
 6  3  2  1  294.67  292.86  290.69  290.17  290.54 
             291.69  293.58  296.09  299.13  302.76 
             306.90  311.55  316.68  322.36  328.42 
             334.93  341.88  374.13  458.41 
/
 6  3  3  1  286.12  276.76  271.58  270.72  271.14 
             272.74  275.22  278.52  282.62  287.35 
             292.77  298.80  305.39  312.45  320.13 
             328.33  337.03  376.42  476.60 
/
 6  3  4  1  278.54  258.27  255.27  254.52  255.41 
             257.61  260.93  265.24  270.43  276.43 
             283.19  290.63  298.93  307.83  317.31 
             327.24  337.82  384.43  500.33 
/
 6  3  5  1  263.57  235.39  232.21  232.21  234.39 
             238.33  243.74  250.42  258.23  266.95 
             276.64  287.05  298.28  310.20  322.77 
             335.36  349.03  410.62  556.90 
/
 6  3  6  1  213.32  206.59  204.90  207.14  212.00 
             219.08  228.11  238.80  250.97  264.71 
             279.47  295.34  312.24  329.66  348.26 
             367.36  387.38  474.11  681.65 
/
 6  3  7  1  180.40  179.51  182.89  191.49  204.29 
             220.37  238.99  259.69  282.20  306.31 
             331.88  358.82  387.08  419.03  451.65 
             485.60  520.94  673.74 1040.94 
/
 6  3  8  1  164.76  169.72  184.18  206.38  235.06 
             268.85  306.73  348.22  392.94  440.70 
             491.43  545.10  601.74  661.98  727.89 
             796.44  867.06 1172.43 1949.38 
/
 6  4  1  1  311.41  310.32  309.85  310.10  310.90 
             312.21  313.97  316.16  318.78  321.80 
             325.22  329.04  333.24  337.83  342.80 
             348.16  353.88  380.59  451.89 
/
 6  4  2  1  301.02  298.64  296.55  295.84  296.19 
             297.38  299.17  301.64  304.67  308.23 
             312.31  316.87  321.91  327.41  333.35 
             339.74  346.57  378.31  461.46 
/
 6  4  3  1  293.00  285.75  278.72  277.70  278.04 
             279.49  281.89  285.02  288.86  293.42 
             298.53  304.29  310.60  317.38  324.77 
             332.66  340.91  378.97  476.31 
/
 6  4  4  1  286.10  265.80  262.75  261.91  262.65 
             264.64  267.69  271.67  276.50  282.10 
             288.45  295.65  303.38  311.70  320.68 
             330.10  340.03  384.57  495.69 
/
 6  4  5  1  272.40  243.36  239.88  239.53  241.30 
             244.72  249.53  255.54  262.61  270.64 
             279.55  289.24  299.67  310.78  322.52 
             334.86  347.77  405.49  544.33 
/
 6  4  6  1  222.65  214.94  211.77  213.28  217.43 
             223.73  231.80  241.40  252.57  265.03 
             278.39  293.10  308.30  324.64  341.59 
             359.30  377.75  457.82  649.92 
/
 6  4  7  1  185.04  183.71  186.00  193.06  203.93 
             217.85  234.29  252.76  272.94  294.61 
             317.64  341.93  367.41  396.87  426.42 
             457.22  488.58  626.45  955.99 
/
 6  4  8  1  167.12  169.89  182.36  201.56  226.45 
             255.85  288.96  325.28  364.43  406.22 
             450.51  497.28  546.50  598.22  653.89 
             714.01  775.78 1042.77 1703.33 
/
 6  5  1  1  317.15  315.29  314.51  314.66  315.42 
             316.70  318.45  320.65  323.26  326.29 
             329.72  333.54  337.76  342.36  347.34 
             352.71  358.46  385.23  456.75 
/
 6  5  2  1  308.16  304.92  302.78  302.00  302.28 
             303.36  305.18  307.60  310.50  313.99 
             317.97  322.44  327.37  332.76  338.59 
             344.86  351.56  382.75  464.32 
/
 6  5  3  1  300.86  294.22  286.40  285.30  285.62 
             286.97  289.18  292.13  295.78  300.04 
             304.97  310.39  316.43  322.90  329.98 
             337.56  345.49  382.10  476.00 
/
 6  5  4  1  294.67  275.59  271.01  270.12  270.74 
             272.54  275.33  279.04  283.58  288.89 
             294.83  301.47  308.69  316.50  324.87 
             333.75  343.14  385.37  491.91 
/
 6  5  5  1  282.31  252.41  248.74  248.10  249.47 
             252.40  256.62  261.96  268.30  275.55 
             283.62  292.47  302.02  312.24  323.08 
             334.51  346.51  400.62  531.46 
/
 6  5  6  1  258.46  223.56  220.55  221.16  224.52 
             229.95  237.09  245.65  255.64  266.64 
             278.83  291.97  306.02  320.89  336.55 
             352.93  369.46  443.09  620.50 
/
 6  5  7  1  190.97  189.19  190.40  195.96  204.98 
             216.79  230.92  247.00  264.75  283.95 
             304.41  326.05  350.37  375.69  402.14 
             429.80  457.95  580.65  874.13 
/
 6  5  8  1  170.44  170.94  180.92  197.28  218.58 
             243.85  272.38  303.71  337.52  373.59 
             411.79  452.05  494.33  538.65  585.01 
             635.72  689.24  920.20 1474.03 
/
 6  6  1  1  322.79  320.31  319.27  319.31  320.03 
             321.30  323.04  325.23  327.85  330.88 
             334.31  338.14  342.37  346.98  351.97 
             357.36  363.11  389.96  461.67 
/
 6  6  2  1  315.35  311.43  309.14  308.41  308.70 
             309.74  311.52  313.81  316.71  320.13 
             324.03  328.41  333.24  338.52  344.24 
             350.39  356.97  387.44  467.73 
/
 6  6  3  1  308.94  302.03  294.80  293.61  293.78 
             295.03  297.11  299.90  303.34  307.45 
             312.07  317.22  322.99  329.16  335.90 
             343.03  350.72  385.81  476.80 
/
 6  6  4  1  303.53  289.96  280.44  279.48  279.98 
             281.60  284.21  287.59  291.77  296.65 
             302.11  308.26  314.98  322.27  330.10 
             338.45  347.30  387.15  488.55 
/
 6  6  5  1  292.71  262.74  259.01  258.15  259.17 
             261.64  265.29  269.98  275.59  282.05 
             289.28  297.24  305.89  315.18  325.08 
             335.56  346.59  396.91  519.30 
/
 6  6  6  1  271.52  234.10  230.50  230.86  233.62 
             238.22  244.42  251.90  260.68  270.52 
             281.30  292.93  305.34  318.96  332.82 
             347.31  362.42  429.40  591.50 
/
 6  6  7  1  198.77  196.53  196.67  200.77  207.98 
             217.70  229.53  243.17  258.36  274.93 
             292.71  313.15  334.50  356.94  379.95 
             404.57  429.66  538.11  795.63 
/
 6  6  8  1  175.02  174.63  180.83  194.07  211.89 
             233.14  257.25  283.78  312.45  343.06 
             375.45  409.55  445.30  482.70  521.74 
             562.41  608.37  803.82 1266.17 
/
 6  7  1  1  328.16  325.33  324.07  324.05  324.73 
             325.98  327.72  329.90  332.52  335.56 
             339.00  342.83  347.06  351.68  356.69 
             362.08  367.85  394.76  466.63 
/
 6  7  2  1  322.37  318.08  315.67  315.00  315.33 
             316.42  318.16  320.43  323.27  326.58 
             330.40  334.68  339.41  344.58  350.18 
             356.21  362.66  392.59  471.70 
/
 6  7  3  1  317.03  310.19  303.99  302.63  302.74 
             303.90  305.84  308.42  311.67  315.56 
             319.93  324.83  330.22  336.19  342.55 
             349.36  356.75  390.34  477.96 
/
 6  7  4  1  312.49  302.70  291.39  290.16  290.50 
             291.92  294.22  297.30  301.13  305.55 
             310.64  316.33  322.48  329.25  336.55 
             344.23  352.51  390.10  486.14 
/
 6  7  5  1  303.42  274.56  270.93  269.96  270.71 
             272.76  275.88  279.94  284.84  290.51 
             296.91  303.99  311.71  320.04  328.96 
             338.44  348.46  395.07  508.48 
/
 6  7  6  1  285.46  247.10  243.03  242.71  244.72 
             248.50  253.73  260.21  267.80  276.37 
             285.86  296.17  307.24  318.89  331.32 
             344.38  357.85  417.93  565.03 
/
 6  7  7  1  215.74  206.70  205.80  208.48  213.92 
             221.58  231.12  242.28  255.56  270.26 
             286.29  303.26  321.69  340.82  360.94 
             382.03  403.39  497.79  720.26 
/
 6  7  8  1  181.68  180.43  184.10  193.46  207.25 
             224.37  244.06  265.89  289.56  314.87 
             341.70  369.93  399.53  430.43  462.64 
             496.13  533.23  695.44 1075.31 
/
 6  8  1  1  333.05  330.22  328.88  328.82  329.49 
             330.73  332.47  334.66  337.28  340.32 
             343.76  347.60  351.84  356.47  361.49 
             366.89  372.67  399.62  471.65 
/
 6  8  2  1  328.93  324.75  322.39  321.78  322.14 
             323.24  324.95  327.21  329.99  333.24 
             336.95  341.12  345.72  350.76  356.22 
             362.09  368.38  397.62  475.16 
/
 6  8  3  1  324.85  318.57  313.81  312.46  312.48 
             313.47  315.30  317.79  320.86  324.42 
             328.56  333.27  338.40  343.99  350.04 
             356.54  363.47  395.67  479.67 
/
 6  8  4  1  321.28  312.63  303.58  302.18  302.29 
             303.52  305.59  308.37  311.81  315.92 
             320.52  325.67  331.43  337.60  344.37 
             351.50  359.23  394.30  485.02 
/
 6  8  5  1  314.17  296.64  284.83  283.87  284.44 
             286.14  288.79  292.27  296.50  301.42 
             307.00  313.20  320.14  327.74  335.82 
             344.45  353.58  395.33  499.73 
/
 6  8  6  1  300.00  263.30  259.07  258.24  259.49 
             262.28  266.33  271.46  277.58  284.59 
             292.41  301.00  310.31  320.29  330.91 
             342.14  353.94  406.56  537.76 
/
 6  8  7  1  266.14  224.53  220.49  221.58  225.42 
             231.36  239.09  248.34  258.94  271.00 
             283.97  297.96  313.19  329.07  345.92 
             363.40  381.64  461.00  648.56 
/
 6  8  8  1  192.09  189.98  191.30  197.35  207.00 
             219.52  234.43  251.33  269.93  289.98 
             311.34  333.89  357.56  382.29  408.05 
             437.19  467.17  596.69  901.11 
/
 6  9  1  1  337.29  334.86  333.61  333.58  334.26 
             335.51  337.26  339.46  342.09  345.13 
             348.58  352.44  356.68  361.32  366.35 
             371.76  377.55  404.55  476.70 
/
 6  9  2  1  334.75  331.24  329.19  328.73  329.18 
             330.31  332.03  334.26  336.98  340.16 
             343.78  347.84  352.32  357.23  362.54 
             368.26  374.39  402.90  478.76 
/
 6  9  3  1  332.04  326.99  323.72  322.67  322.83 
             323.81  325.51  327.86  330.77  334.11 
             338.02  342.41  347.27  352.57  358.31 
             364.49  371.09  401.68  482.16 
/
 6  9  4  1  329.56  322.80  317.26  315.60  315.60 
             316.61  318.47  320.99  324.13  327.75 
             332.04  336.78  342.00  347.70  353.85 
             360.45  367.50  400.11  485.38 
/
 6  9  5  1  324.63  314.60  302.25  301.04  301.40 
             302.79  305.02  308.05  311.69  316.01 
             320.86  326.36  332.31  338.89  346.00 
             353.49  361.60  398.64  493.30 
/
 6  9  6  1  314.78  283.66  279.82  278.78  279.47 
             281.44  284.45  288.37  293.10  298.59 
             304.79  311.65  319.16  327.27  335.98 
             345.24  355.06  399.46  513.86 
/
 6  9  7  1  290.48  247.68  243.30  243.14  245.48 
             249.68  255.39  262.30  270.45  279.35 
             289.41  300.34  312.05  324.50  337.64 
             351.43  365.83  429.24  581.51 
/
 6  9  8  1  216.90  207.25  206.35  209.30  215.08 
             223.15  233.14  244.79  257.89  272.30 
             288.65  306.61  325.30  345.45  366.17 
             387.90  410.60  509.16  739.64 
/
 6 10  1  1  343.38  342.75  342.38  342.69  343.57 
             344.94  346.77  349.03  351.71  354.80 
             358.29  362.17  366.44  371.11  376.15 
             381.59  387.40  414.48  486.84 
/
 6 10  2  1  343.38  342.75  342.38  342.69  343.57 
             344.94  346.77  349.03  351.71  354.80 
             358.29  362.17  366.44  371.11  376.15 
             381.59  387.40  414.48  486.84 
/
 6 10  3  1  343.38  342.75  342.38  342.69  343.57 
             344.94  346.77  349.03  351.71  354.80 
             358.29  362.17  366.44  371.11  376.15 
             381.59  387.40  414.48  486.84 
/
 6 10  4  1  343.38  342.75  342.38  342.69  343.57 
             344.94  346.77  349.03  351.71  354.80 
             358.29  362.17  366.44  371.11  376.15 
             381.59  387.40  414.48  486.84 
/
 6 10  5  1  343.38  342.75  342.38  342.69  343.57 
             344.94  346.77  349.03  351.71  354.80 
             358.29  362.17  366.44  371.11  376.15 
             381.59  387.40  414.48  486.84 
/
 6 10  6  1  343.38  342.75  342.38  342.69  343.57 
             344.94  346.77  349.03  351.71  354.80 
             358.29  362.17  366.44  371.11  376.15 
             381.59  387.40  414.48  486.84 
/
 6 10  7  1  343.38  342.75  342.38  342.69  343.57 
             344.94  346.77  349.03  351.71  354.80 
             358.29  362.17  366.44  371.11  376.15 
             381.59  387.40  414.48  486.84 
/
 6 10  8  1  343.38  342.75  342.38  342.69  343.57 
             344.94  346.77  349.03  351.71  354.80 
             358.29  362.17  366.44  371.11  376.15 
             381.59  387.40  414.48  486.84 
/
 7  1  1  1  317.62  317.33  317.24  317.64  318.51 
             319.84  321.59  323.77  326.35  329.33 
             332.71  336.48  340.63  345.16  350.07 
             355.35  361.01  387.38  457.80 
/
 7  1  2  1  305.01  304.01  303.16  303.00  303.57 
             304.83  306.72  309.25  312.34  315.90 
             320.04  324.67  329.79  335.39  341.45 
             347.96  354.93  387.38  472.39 
/
 7  1  3  1  295.85  287.24  284.80  284.30  284.91 
             286.56  289.15  292.50  296.59  301.41 
             306.89  312.92  319.62  326.88  334.70 
             343.06  351.81  392.13  495.53 
/
 7  1  4  1  288.31  271.35  269.08  268.71  269.81 
             272.15  275.60  280.05  285.40  291.58 
             298.54  306.28  314.91  324.10  333.83 
             344.23  355.04  403.54  525.52 
/
 7  1  5  1  273.66  249.93  247.57  247.99  250.48 
             254.71  260.43  267.49  275.72  285.02 
             295.28  306.42  318.27  330.96  344.22 
             358.27  372.95  438.77  597.19 
/
 7  1  6  1  229.51  223.50  223.08  225.81  231.11 
             238.64  248.70  260.47  273.77  288.74 
             305.15  322.56  341.12  360.77  380.97 
             402.31  424.76  521.82  758.04 
/
 7  1  7  1  201.05  200.51  204.81  214.86  229.68 
             248.19  269.65  293.61  319.76  347.89 
             377.85  409.58  444.43  481.52  520.57 
             560.83  602.16  786.40 1230.59 
/
 7  1  8  1  187.55  193.21  210.48  237.51  272.56 
             314.00  360.70  412.13  467.90  527.87 
             591.99  660.31  735.33  814.31  897.22 
             983.01 1070.85 1471.37 2506.60 
/
 7  2  1  1  321.81  321.48  321.34  321.71  322.57 
             323.90  325.67  327.85  330.45  333.45 
             336.84  340.63  344.80  349.35  354.28 
             359.59  365.28  391.75  462.47 
/
 7  2  2  1  309.83  308.82  307.94  307.83  308.38 
             309.62  311.48  313.98  316.98  320.56 
             324.65  329.23  334.29  339.81  345.80 
             352.23  359.11  390.98  475.30 
/
 7  2  3  1  301.03  294.82  290.55  289.89  290.42 
             291.99  294.47  297.69  301.63  306.28 
             311.51  317.41  323.89  330.84  338.41 
             346.52  355.00  394.17  494.77 
/
 7  2  4  1  293.97  277.37  274.97  274.47  275.42 
             277.59  280.82  285.00  290.06  295.91 
             302.63  310.10  318.21  326.93  336.20 
             346.16  356.53  403.25  520.81 
/
 7  2  5  1  280.16  255.97  253.28  253.39  255.52 
             259.32  264.55  271.04  278.67  287.32 
             296.90  307.34  318.57  330.53  343.19 
             356.51  370.46  433.18  584.52 
/
 7  2  6  1  235.09  230.22  227.74  229.96  234.74 
             241.74  250.75  261.50  273.99  287.77 
             302.86  318.81  336.17  354.48  373.45 
             393.44  414.10  505.16  725.19 
/
 7  2  7  1  204.29  203.38  206.69  215.30  228.24 
             244.73  264.10  285.85  309.66  335.30 
             362.65  391.59  423.21  457.46  492.69 
             529.52  568.00  734.68 1139.93 
/
 7  2  8  1  189.06  193.16  208.28  232.10  263.16 
             299.96  341.53  387.32  436.97  490.27 
             547.17  607.64  672.29  742.87  816.65 
             893.07  972.68 1322.91 2222.53 
/
 7  3  1  1  326.08  325.70  325.52  325.87  326.73 
             328.06  329.84  332.03  334.65  337.66 
             341.07  344.87  349.06  353.63  358.58 
             363.91  369.62  396.20  467.19 
/
 7  3  2  1  314.84  313.84  312.93  312.82  313.40 
             314.66  316.50  318.98  321.94  325.48 
             329.51  334.03  339.02  344.47  350.37 
             356.71  363.50  394.97  477.95 
/
 7  3  3  1  306.47  302.30  296.69  295.90  296.42 
             297.92  300.25  303.34  307.12  311.60 
             316.64  322.33  328.51  335.30  342.52 
             350.36  358.71  396.68  494.59 
/
 7  3  4  1  299.93  283.90  281.42  280.82  281.64 
             283.64  286.66  290.58  295.36  301.04 
             307.37  314.38  322.02  330.37  339.22 
             348.61  358.52  403.39  516.41 
/
 7  3  5  1  287.08  262.73  259.78  259.60  261.38 
             264.75  269.49  275.42  282.43  290.42 
             299.30  309.01  319.49  330.69  342.56 
             355.09  368.23  427.58  570.98 
/
 7  3  6  1  241.52  236.20  233.70  235.13  239.27 
             245.63  253.81  263.59  275.00  287.55 
             301.27  316.32  332.32  349.09  366.74 
             385.24  404.57  488.99  694.27 
/
 7  3  7  1  208.24  206.95  209.29  216.49  227.68 
             242.13  259.30  278.78  300.23  323.40 
             348.14  374.36  403.16  434.30  466.35 
             499.87  534.16  685.88 1050.03 
/
 7  3  8  1  191.21  193.25  206.39  227.16  254.34 
             286.71  323.36  363.77  407.57  454.54 
             504.60  557.70  613.85  674.37  739.74 
             807.12  877.34 1183.07 1958.03 
/
 7  4  1  1  331.55  330.47  330.02  330.28  331.10 
             332.42  334.19  336.38  339.00  342.02 
             345.44  349.26  353.46  358.04  363.01 
             368.36  374.09  400.75  471.98 
/
 7  4  2  1  321.16  319.51  318.38  318.20  318.79 
             320.02  321.86  324.30  327.22  330.70 
             334.67  339.12  344.03  349.40  355.21 
             361.46  368.16  399.19  481.15 
/
 7  4  3  1  313.18  308.75  303.37  302.48  302.95 
             304.31  306.53  309.49  313.17  317.42 
             322.26  327.74  333.68  340.24  347.20 
             354.74  362.68  399.48  494.71 
/
 7  4  4  1  307.19  291.33  288.50  287.83  288.56 
             290.44  293.28  297.01  301.53  306.81 
             312.77  319.32  326.55  334.37  342.86 
             351.80  361.24  404.05  512.65 
/
 7  4  5  1  295.36  270.34  267.18  266.74  268.21 
             271.17  275.42  280.79  287.17  294.48 
             302.65  311.61  321.32  331.72  342.79 
             354.49  366.79  422.79  558.35 
/
 7  4  6  1  272.98  243.28  240.75  241.69  245.14 
             250.69  258.01  266.88  277.19  288.52 
             301.17  314.86  329.52  345.10  361.06 
             378.22  396.19  473.54  663.03 
/
 7  4  7  1  213.11  211.45  212.83  218.68  228.15 
             240.61  255.59  272.72  291.73  312.39 
             334.53  358.05  384.47  412.55  441.54 
             471.22  502.86  638.80  965.84 
/
 7  4  8  1  193.97  194.50  204.83  222.69  246.23 
             274.34  306.26  341.50  379.72  420.69 
             464.29  510.44  559.15  610.41  666.34 
             725.51  787.52 1053.20 1712.30 
/
 7  5  1  1  337.28  335.43  334.68  334.83  335.61 
             336.90  338.66  340.85  343.47  346.50 
             349.93  353.75  357.96  362.56  367.54 
             372.90  378.65  405.39  476.84 
/
 7  5  2  1  328.33  325.70  324.23  323.95  324.49 
             325.71  327.54  329.93  332.83  336.25 
             340.13  344.50  349.33  354.61  360.33 
             366.49  373.07  403.64  484.53 
/
 7  5  3  1  321.04  315.92  310.63  309.68  310.03 
             311.32  313.44  316.26  319.73  323.79 
             328.48  333.66  339.42  345.67  352.41 
             359.60  367.38  402.92  495.13 
/
 7  5  4  1  315.60  303.53  296.58  295.81  296.41 
             298.10  300.76  304.19  308.43  313.37 
             318.90  325.11  331.93  339.31  347.25 
             355.71  364.68  405.35  509.38 
/
 7  5  5  1  304.87  278.92  275.64  275.00  276.17 
             278.74  282.51  287.33  293.09  299.73 
             307.17  315.37  324.28  333.86  344.09 
             354.93  366.36  418.72  546.37 
/
 7  5  6  1  284.20  251.73  248.65  249.27  252.40 
             257.24  263.78  271.67  280.72  291.05 
             302.39  314.65  328.17  342.12  356.82 
             372.21  388.28  459.76  635.70 
/
 7  5  7  1  219.27  217.23  217.68  222.22  230.02 
             240.53  253.33  268.13  284.66  302.74 
             322.22  343.90  367.59  392.32  418.27 
             444.86  472.61  594.30  885.66 
/
 7  5  8  1  197.61  197.36  204.37  219.11  239.09 
             263.08  290.43  320.68  353.54  388.77 
             426.24  465.85  507.57  551.40  597.33 
             648.17  701.57  931.39 1485.31 
/
 7  6  1  1  342.92  340.45  339.42  339.48  340.21 
             341.48  343.23  345.42  348.04  351.07 
             354.50  358.33  362.55  367.16  372.16 
             377.53  383.29  410.10  481.74 
/
 7  6  2  1  335.55  332.12  330.34  329.97  330.47 
             331.66  333.46  335.80  338.66  342.01 
             345.84  350.12  354.85  360.03  365.64 
             371.68  378.13  408.17  487.74 
/
 7  6  3  1  329.17  323.49  318.61  317.50  317.75 
             318.94  320.95  323.65  326.96  330.85 
             335.29  340.26  345.73  351.79  358.23 
             365.15  372.66  406.83  495.91 
/
 7  6  4  1  324.34  315.68  305.67  304.76  305.22 
             306.74  309.13  312.31  316.25  320.79 
             326.02  331.85  338.17  345.11  352.59 
             360.46  368.94  407.58  507.01 
/
 7  6  5  1  314.88  288.63  285.36  284.58  285.49 
             287.70  291.01  295.29  300.44  306.41 
             313.12  320.55  328.65  337.39  346.76 
             356.71  367.23  416.09  535.57 
/
 7  6  6  1  296.41  261.92  258.37  258.40  260.76 
             264.93  270.61  277.62  285.80  295.04 
             305.24  316.24  328.04  340.70  354.08 
             368.15  382.87  447.86  607.57 
/
 7  6  7  1  232.59  224.84  224.39  227.66  233.84 
             242.45  253.11  265.57  279.64  295.12 
             313.29  332.73  352.84  374.55  396.97 
             420.48  445.07  551.62  807.22 
/
 7  6  8  1  202.56  201.57  206.25  217.32  233.42 
             253.30  276.18  301.62  329.31  359.03 
             390.66  424.08  459.24  496.11  534.68 
             575.63  621.40  815.56 1274.79 
/
 7  7  1  1  348.28  345.46  344.22  344.20  344.90 
             346.15  347.89  350.08  352.70  355.73 
             359.17  363.01  367.23  371.85  376.86 
             382.24  388.02  414.89  486.70 
/
 7  7  2  1  342.59  338.68  336.69  336.26  336.73 
             337.90  339.67  341.97  344.77  348.05 
             351.79  355.99  360.62  365.69  371.18 
             377.10  383.43  412.88  491.13 
/
 7  7  3  1  337.33  331.42  327.32  325.99  326.13 
             327.21  329.11  331.62  334.78  338.49 
             342.73  347.48  352.72  358.44  364.63 
             371.37  378.47  411.22  497.52 
/
 7  7  4  1  333.21  324.75  315.95  314.75  315.00 
             316.35  318.54  321.47  325.13  329.34 
             334.14  339.58  345.48  351.99  358.89 
             366.41  374.27  410.82  505.37 
/
 7  7  5  1  325.21  299.94  296.54  295.70  296.41 
             298.31  301.20  304.97  309.53  314.83 
             320.82  327.48  334.77  342.66  351.33 
             360.68  370.45  414.85  525.78 
/
 7  7  6  1  309.45  274.31  270.47  270.00  271.65 
             274.94  279.58  285.39  292.27  300.12 
             308.85  318.42  328.77  339.85  351.62 
             364.06  377.12  435.25  580.09 
/
 7  7  7  1  244.36  237.44  233.93  235.93  240.56 
             247.49  256.46  267.10  279.28  292.91 
             308.14  324.37  341.78  359.83  379.34 
             399.30  420.61  512.87  732.69 
/
 7  7  8  1  209.65  207.93  210.46  218.37  230.46 
             245.93  264.22  284.85  307.48  331.87 
             357.88  385.40  414.35  444.70  476.41 
             509.45  547.34  707.74 1085.11 
/
 7  8  1  1  353.17  350.34  349.02  348.96  349.64 
             350.88  352.62  354.81  357.43  360.47 
             363.91  367.76  371.99  376.62  381.63 
             387.03  392.81  419.74  491.71 
/
 7  8  2  1  349.15  345.25  343.20  342.78  343.25 
             344.41  346.15  348.41  351.16  354.38 
             358.04  362.15  366.68  371.64  377.02 
             382.81  389.01  417.87  494.70 
/
 7  8  3  1  345.18  339.56  336.19  335.05  335.18 
             336.17  337.89  340.33  343.33  346.79 
             350.83  355.37  360.37  365.84  371.77 
             378.13  384.93  416.42  499.53 
/
 7  8  4  1  341.91  334.24  327.41  325.95  326.03 
             327.20  329.19  331.83  335.19  339.09 
             343.55  348.55  354.08  360.06  366.62 
             373.55  380.94  415.31  504.75 
/
 7  8  5  1  335.59  323.98  309.48  308.69  309.27 
             310.91  313.42  316.71  320.80  325.57 
             330.98  337.00  343.63  350.81  358.57 
             366.87  375.69  415.79  518.09 
/
 7  8  6  1  323.05  289.55  285.70  284.87  285.94 
             288.43  292.09  296.78  302.40  308.87 
             316.15  324.17  332.90  342.32  352.38 
             363.06  374.34  425.07  553.68 
/
 7  8  7  1  293.19  252.95  249.52  250.08  253.33 
             258.57  265.64  274.17  283.97  295.15 
             307.48  320.87  334.87  350.13  366.28 
             383.23  400.43  477.55  662.26 
/
 7  8  8  1  220.51  218.08  218.59  223.55  231.94 
             243.13  256.68  272.28  289.66  308.63 
             329.02  350.72  373.65  397.73  423.93 
             452.67  482.29  609.65  912.71 
/
 7  9  1  1  357.41  354.97  353.74  353.70  354.39 
             355.65  357.39  359.59  362.22  365.27 
             368.72  372.57  376.81  381.45  386.47 
             391.88  397.67  424.65  496.76 
/
 7  9  2  1  354.97  351.63  349.79  349.45  349.98 
             351.15  352.89  355.12  357.83  360.99 
             364.58  368.60  373.04  377.89  383.16 
             388.83  394.90  423.16  498.51 
/
 7  9  3  1  352.37  347.73  344.88  344.05  344.33 
             345.41  347.15  349.47  352.32  355.68 
             359.52  363.83  368.59  373.80  379.44 
             385.51  392.00  422.17  501.93 
/
 7  9  4  1  350.09  343.96  339.97  338.34  338.33 
             339.29  341.11  343.50  346.56  350.17 
             354.29  358.92  364.03  369.60  375.64 
             382.12  389.04  421.06  505.25 
/
 7  9  5  1  345.67  336.61  326.35  325.11  325.42 
             326.74  328.88  331.73  335.23  339.40 
             344.09  349.41  355.18  361.57  368.36 
             375.76  383.53  419.72  512.75 
/
 7  9  6  1  336.86  311.61  305.07  304.15  304.81 
             306.65  309.47  313.14  317.58  322.75 
             328.61  335.12  342.25  349.98  358.30 
             367.18  376.61  419.56  532.00 
/
 7  9  7  1  315.31  275.16  270.92  270.52  272.45 
             276.10  281.18  287.49  294.92  303.37 
             312.75  323.00  334.07  345.90  358.46 
             371.71  385.61  447.36  597.76 
/
 7  9  8  1  245.72  236.11  234.45  236.72  241.68 
             248.81  257.80  268.42  280.51  295.01 
             310.61  327.61  345.50  364.53  384.66 
             405.86  427.45  523.90  751.95 
/
 7 10  1  1  363.49  362.85  362.48  362.79  363.67 
             365.04  366.87  369.13  371.81  374.89 
             378.38  382.26  386.53  391.19  396.24 
             401.67  407.48  434.55  506.87 
/
 7 10  2  1  363.49  362.85  362.48  362.79  363.67 
             365.04  366.87  369.13  371.81  374.89 
             378.38  382.26  386.53  391.19  396.24 
             401.67  407.48  434.55  506.87 
/
 7 10  3  1  363.49  362.85  362.48  362.79  363.67 
             365.04  366.87  369.13  371.81  374.89 
             378.38  382.26  386.53  391.19  396.24 
             401.67  407.48  434.55  506.87 
/
 7 10  4  1  363.49  362.85  362.48  362.79  363.67 
             365.04  366.87  369.13  371.81  374.89 
             378.38  382.26  386.53  391.19  396.24 
             401.67  407.48  434.55  506.87 
/
 7 10  5  1  363.49  362.85  362.48  362.79  363.67 
             365.04  366.87  369.13  371.81  374.89 
             378.38  382.26  386.53  391.19  396.24 
             401.67  407.48  434.55  506.87 
/
 7 10  6  1  363.49  362.85  362.48  362.79  363.67 
             365.04  366.87  369.13  371.81  374.89 
             378.38  382.26  386.53  391.19  396.24 
             401.67  407.48  434.55  506.87 
/
 7 10  7  1  363.49  362.85  362.48  362.79  363.67 
             365.04  366.87  369.13  371.81  374.89 
             378.38  382.26  386.53  391.19  396.24 
             401.67  407.48  434.55  506.87 
/
 7 10  8  1  363.49  362.85  362.48  362.79  363.67 
             365.04  366.87  369.13  371.81  374.89 
             378.38  382.26  386.53  391.19  396.24 
             401.67  407.48  434.55  506.87 
/
 8  1  1  1  337.74  337.46  337.40  337.81  338.70 
             340.03  341.80  343.98  346.56  349.55 
             352.92  356.69  360.83  365.36  370.27 
             375.55  381.20  407.54  477.90 
/
 8  1  2  1  325.08  324.59  324.24  324.48  325.32 
             326.74  328.73  331.25  334.30  337.87 
             341.92  346.45  351.47  356.96  362.89 
             369.30  376.14  407.98  492.34 
/
 8  1  3  1  315.72  312.68  308.77  308.43  309.13 
             310.76  313.20  316.39  320.27  324.86 
             330.02  335.76  342.16  349.12  356.53 
             364.54  373.08  412.29  513.54 
/
 8  1  4  1  309.12  295.82  294.01  293.80  294.88 
             297.08  300.28  304.41  309.49  315.36 
             321.95  329.25  337.21  345.89  355.09 
             364.86  375.16  422.26  541.81 
/
 8  1  5  1  296.34  275.77  273.63  273.95  276.12 
             279.87  285.01  291.40  298.93  307.49 
             317.01  327.42  338.66  350.69  363.45 
             376.92  391.07  455.22  611.40 
/
 8  1  6  1  255.94  251.74  249.90  252.17  257.04 
             264.14  273.19  284.12  296.68  310.75 
             326.21  342.98  360.45  379.28  399.39 
             420.05  441.67  536.67  770.99 
/
 8  1  7  1  227.32  226.52  229.95  238.75  252.03 
             269.06  289.25  312.11  337.29  364.56 
             393.78  424.85  460.32  496.52  534.53 
             574.36  616.17  798.50 1240.62 
/
 8  1  8  1  212.81  216.30  232.26  257.81  291.37 
             331.37  376.87  427.28  482.20  541.46 
             604.99  672.82  747.98  826.45  908.19 
             993.50 1081.87 1481.63 2517.10 
/
 8  2  1  1  341.93  341.61  341.49  341.88  342.75 
             344.09  345.86  348.06  350.65  353.65 
             357.05  360.83  365.00  369.55  374.47 
             379.78  385.46  411.91  482.56 
/
 8  2  2  1  329.90  329.36  328.95  329.16  329.97 
             331.37  333.34  335.84  338.86  342.38 
             346.39  350.88  355.84  361.26  367.12 
             373.44  380.21  411.62  494.97 
/
 8  2  3  1  320.83  317.93  314.26  313.80  314.43 
             316.00  318.36  321.44  325.20  329.59 
             334.58  340.22  346.35  353.08  360.34 
             368.10  376.35  414.38  513.40 
/
 8  2  4  1  314.59  301.62  299.69  299.37  300.33 
             302.41  305.49  309.45  314.23  319.80 
             326.08  333.05  340.66  348.88  357.70 
             367.06  376.97  422.37  537.68 
/
 8  2  5  1  302.50  281.63  279.24  279.30  281.17 
             284.56  289.28  295.19  302.17  310.15 
             319.06  328.81  339.37  350.69  362.73 
             375.46  388.85  449.79  598.46 
/
 8  2  6  1  269.66  256.85  255.33  256.65  260.90 
             267.36  275.74  285.78  297.33  310.25 
             324.54  339.80  356.56  374.03  392.48 
             411.85  431.56  520.64  738.47 
/
 8  2  7  1  230.71  229.58  232.12  239.61  251.24 
             266.32  284.34  304.90  327.69  352.44 
             379.00  407.26  439.35  472.84  507.61 
             544.04  581.47  747.25 1149.38 
/
 8  2  8  1  214.67  216.38  230.27  252.74  282.35 
             317.80  358.20  402.98  451.76  504.34 
             560.61  620.56  685.26  755.40  828.86 
             904.90  984.17 1332.38 2233.30 
/
 8  3  1  1  346.20  345.84  345.67  346.04  346.91 
             348.25  350.03  352.23  354.84  357.86 
             361.27  365.07  369.25  373.82  378.77 
             384.09  389.80  416.35  487.27 
/
 8  3  2  1  334.90  334.33  333.88  334.06  334.85 
             336.24  338.19  340.67  343.65  347.13 
             351.09  355.52  360.41  365.76  371.56 
             377.79  384.47  415.50  497.79 
/
 8  3  3  1  326.22  323.49  320.11  319.60  320.15 
             321.63  323.90  326.88  330.51  334.76 
             339.63  345.03  350.99  357.49  364.56 
             372.04  380.13  416.98  513.16 
/
 8  3  4  1  320.37  308.25  306.04  305.60  306.45 
             308.38  311.28  314.98  319.52  324.79 
             330.76  337.39  344.64  352.49  360.91 
             369.88  379.39  422.68  533.86 
/
 8  3  5  1  309.07  288.16  285.56  285.39  286.98 
             290.02  294.32  299.74  306.19  313.58 
             321.85  330.93  340.79  351.39  362.69 
             374.65  387.25  444.87  585.97 
/
 8  3  6  1  288.07  262.80  260.76  262.25  265.86 
             271.63  279.08  288.23  298.92  310.70 
             323.87  338.16  353.13  369.38  386.56 
             404.15  423.15  505.15  707.92 
/
 8  3  7  1  234.79  233.33  235.02  241.25  251.25 
             264.43  280.33  298.59  318.93  341.13 
             365.03  390.51  419.99  450.03  481.60 
             514.70  548.66  698.61 1062.08 
/
 8  3  8  1  217.00  217.72  228.61  248.10  273.99 
             305.09  340.61  379.99  422.91  469.13 
             518.55  571.08  626.75  687.45  752.54 
             819.45  889.32 1192.95 1966.59 
/
 8  4  1  1  351.66  350.60  350.17  350.44  351.27 
             352.60  354.37  356.57  359.19  362.21 
             365.63  369.44  373.64  378.22  383.19 
             388.53  394.25  420.89  492.06 
/
 8  4  2  1  341.23  339.96  339.25  339.34  340.09 
             341.45  343.37  345.80  348.75  352.18 
             356.08  360.44  365.26  370.53  376.24 
             382.38  388.96  419.54  500.77 
/
 8  4  3  1  332.88  329.77  326.49  325.88  326.35 
             327.80  329.94  332.81  336.32  340.42 
             345.08  350.36  356.11  362.36  369.12 
             376.46  384.20  420.13  513.54 
/
 8  4  4  1  327.43  316.62  313.01  312.47  313.21 
             314.98  317.70  321.19  325.47  330.41 
             336.05  342.34  349.22  356.69  364.72 
             373.16  382.24  423.92  530.66 
/
 8  4  5  1  316.99  295.47  292.72  292.35  293.68 
             296.38  300.26  305.21  311.11  317.91 
             325.53  333.94  343.09  352.95  363.48 
             374.65  386.45  440.82  574.01 
/
 8  4  6  1  297.22  269.78  267.25  268.17  271.53 
             276.86  283.61  291.88  301.39  312.22 
             324.15  337.06  350.89  365.58  381.08 
             397.93  415.01  491.26  678.64 
/
 8  4  7  1  239.80  238.02  238.87  243.88  252.31 
             263.64  277.45  293.43  311.35  330.99 
             352.22  375.87  401.79  428.75  457.18 
             486.41  517.69  651.74  977.32 
/
 8  4  8  1  219.95  219.96  227.91  244.22  266.46 
             293.34  324.14  358.36  395.68  435.87 
             478.78  524.35  572.54  623.36  679.88 
             738.27  799.08 1063.41 1721.13 
/
 8  5  1  1  357.40  355.56  354.82  354.99  355.77 
             357.07  358.83  361.03  363.65  366.67 
             370.10  373.92  378.13  382.73  387.70 
             393.06  398.80  425.52  496.91 
/
 8  5  2  1  348.42  346.12  345.02  344.98  345.67 
             346.98  348.85  351.25  354.14  357.52 
             361.35  365.65  370.39  375.57  381.19 
             387.23  393.71  423.82  503.89 
/
 8  5  3  1  340.86  336.83  333.56  332.75  333.18 
             334.49  336.53  339.29  342.66  346.61 
             351.11  356.14  361.68  367.72  374.35 
             381.36  388.84  423.50  514.30 
/
 8  5  4  1  335.80  328.89  320.90  320.13  320.73 
             322.36  324.85  328.12  332.15  336.79 
             342.13  348.07  354.51  361.59  369.21 
             377.23  385.91  425.56  527.95 
/
 8  5  5  1  326.26  303.68  300.85  300.32  301.41 
             303.79  307.28  311.75  317.12  323.32 
             330.30  338.03  346.45  355.55  365.30 
             375.67  386.98  437.61  562.75 
/
 8  5  6  1  307.94  278.04  275.07  275.46  278.14 
             282.66  288.75  296.20  304.90  314.72 
             325.57  337.28  349.96  363.35  377.63 
             392.66  408.40  478.12  650.25 
/
 8  5  7  1  250.58  243.97  244.01  247.85  254.78 
             264.29  276.06  289.80  305.31  322.42 
             341.71  363.18  385.83  409.84  434.68 
             460.76  488.07  607.29  897.34 
/
 8  5  8  1  223.80  223.13  228.88  241.67  260.09 
             282.81  309.02  338.25  370.18  404.60 
             441.35  480.34  521.52  564.87  611.03 
             661.60  714.51  942.11 1494.36 
/
 8  6  1  1  363.04  360.57  359.56  359.63  360.37 
             361.64  363.39  365.59  368.20  371.24 
             374.67  378.49  382.71  387.32  392.31 
             397.68  403.44  430.22  501.81 
/
 8  6  2  1  355.67  352.50  351.04  350.88  351.51 
             352.78  354.61  356.96  359.81  363.12 
             366.89  371.11  375.77  380.87  386.39 
             392.33  398.70  428.33  507.19 
/
 8  6  3  1  349.11  344.30  341.19  340.21  340.52 
             341.72  343.71  346.36  349.53  353.32 
             357.65  362.49  367.83  373.65  379.95 
             386.72  394.08  427.50  515.41 
/
 8  6  4  1  344.54  337.19  329.60  328.66  329.06 
             330.54  332.85  335.90  339.69  344.05 
             349.00  354.60  360.67  367.37  374.48 
             382.20  390.46  428.03  525.77 
/
 8  6  5  1  336.07  312.93  310.11  309.48  310.38 
             312.46  315.57  319.58  324.42  330.04 
             336.38  343.42  351.12  359.45  368.49 
             378.36  388.75  435.46  552.75 
/
 8  6  6  1  319.61  287.89  284.58  284.49  286.54 
             290.26  295.40  301.79  309.32  317.88 
             327.40  337.80  349.06  361.10  373.89 
             387.40  401.59  464.80  622.23 
/
 8  6  7  1  259.49  251.71  250.97  253.70  259.17 
             266.95  276.71  288.25  301.94  317.52 
             334.50  352.62  372.41  393.11  414.98 
             438.03  461.54  566.41  819.81 
/
 8  6  8  1  229.00  227.69  231.39  241.11  255.60 
             273.98  295.63  319.99  346.73  375.61 
             406.49  439.25  473.84  510.21  548.32 
             590.22  634.78  827.95 1286.17 
/
 8  7  1  1  368.40  365.58  364.35  364.34  365.04 
             366.30  368.04  370.23  372.85  375.88 
             379.32  383.15  387.38  392.00  397.00 
             402.38  408.15  435.00  506.76 
/
 8  7  2  1  362.72  359.02  357.29  357.03  357.62 
             358.85  360.65  362.95  365.74  369.00 
             372.70  376.85  381.43  386.43  391.86 
             397.70  403.96  433.08  510.70 
/
 8  7  3  1  357.37  352.12  349.17  348.30  348.51 
             349.61  351.43  353.95  357.05  360.61 
             364.77  369.42  374.55  380.16  386.23 
             392.76  399.72  432.00  517.26 
/
 8  7  4  1  353.43  346.01  339.30  338.14  338.43 
             339.68  341.81  344.64  348.12  352.19 
             356.91  362.09  367.87  374.09  380.88 
             388.13  395.86  431.59  524.56 
/
 8  7  5  1  346.22  326.62  320.72  320.06  320.80 
             322.63  325.38  328.96  333.29  338.33 
             344.04  350.52  357.69  365.40  373.70 
             382.55  392.11  435.04  543.80 
/
 8  7  6  1  332.08  299.76  296.26  295.78  297.26 
             300.23  304.48  309.84  316.21  323.52 
             331.70  340.70  350.48  361.01  372.23 
             384.13  396.69  453.02  595.26 
/
 8  7  7  1  299.73  264.65  261.25  262.75  266.98 
             273.32  281.56  291.57  302.97  315.97 
             330.35  345.66  362.49  380.02  398.77 
             418.11  438.49  528.95  746.19 
/
 8  7  8  1  236.36  234.43  236.22  243.08  253.93 
             268.10  285.06  304.47  326.02  349.48 
             374.67  401.48  429.80  459.59  490.81 
             525.19  562.17  720.64 1095.72 
/
 8  8  1  1  373.29  370.46  369.14  369.09  369.77 
             371.02  372.76  374.95  377.57  380.61 
             384.05  387.89  392.13  396.75  401.76 
             407.15  412.93  439.84  511.76 
/
 8  8  2  1  369.30  365.54  363.70  363.40  363.96 
             365.17  366.94  369.21  371.95  375.15 
             378.79  382.86  387.35  392.27  397.59 
             403.33  409.48  438.09  514.42 
/
 8  8  3  1  365.32  360.16  357.27  356.44  356.75 
             357.87  359.68  362.08  365.04  368.51 
             372.49  376.94  381.87  387.23  393.07 
             399.34  406.06  437.17  519.43 
/
 8  8  4  1  362.17  355.24  350.30  348.80  348.81 
             349.99  351.88  354.51  357.69  361.49 
             365.84  370.77  376.14  382.00  388.34 
             395.14  402.39  436.06  524.32 
/
 8  8  5  1  356.43  345.94  333.34  332.62  333.21 
             334.80  337.30  340.49  344.43  348.95 
             354.16  359.98  366.38  373.24  380.74 
             388.78  397.35  436.45  536.91 
/
 8  8  6  1  345.10  314.23  310.79  310.05  311.05 
             313.36  316.78  321.16  326.43  332.53 
             339.39  347.00  355.30  364.28  373.91 
             384.16  395.02  444.20  570.81 
/
 8  8  7  1  318.19  279.58  276.15  276.75  279.92 
             284.92  291.45  299.44  308.85  319.18 
             330.79  343.40  357.34  371.80  387.08 
             403.14  419.94  495.09  676.95 
/
 8  8  8  1  248.00  244.93  244.96  249.18  256.66 
             266.82  279.30  293.81  310.15  328.13 
             347.61  368.47  390.62  414.01  441.03 
             468.91  497.31  623.14  923.01 
/
 8  9  1  1  377.52  375.09  373.85  373.82  374.52 
             375.77  377.52  379.72  382.35  385.39 
             388.84  392.69  396.93  401.57  406.59 
             411.99  417.78  444.74  516.80 
/
 8  9  2  1  375.12  371.88  370.17  369.92  370.50 
             371.71  373.47  375.70  378.41  381.56 
             385.13  389.13  393.54  398.37  403.60 
             409.23  415.26  443.36  518.37 
/
 8  9  3  1  372.57  368.21  365.67  365.01  365.39 
             366.52  368.28  370.59  373.42  376.73 
             380.52  384.76  389.45  394.58  400.14 
             406.12  412.53  442.31  521.34 
/
 8  9  4  1  370.37  364.70  361.16  360.04  360.20 
             361.26  363.02  365.44  368.42  371.97 
             375.94  380.49  385.51  391.00  396.95 
             403.34  410.17  441.84  525.17 
/
 8  9  5  1  366.33  358.01  349.68  348.38  348.54 
             349.82  351.88  354.66  358.06  362.07 
             366.63  371.83  377.46  383.61  390.36 
             397.49  405.24  440.58  532.23 
/
 8  9  6  1  358.31  342.95  329.07  328.29  328.97 
             330.75  333.44  336.95  341.20  346.14 
             351.75  358.00  364.85  372.31  380.33 
             388.91  398.05  440.57  550.64 
/
 8  9  7  1  338.77  300.92  296.94  296.47  298.17 
             301.46  306.11  311.93  318.82  326.70 
             335.50  345.15  355.63  366.89  378.89 
             391.59  404.98  464.88  612.66 
/
 8  9  8  1  272.62  265.52  261.37  263.12  267.51 
             273.96  282.57  292.91  304.82  318.19 
             332.94  349.00  366.31  384.37  403.98 
             424.71  445.89  539.89  766.63 
/
 8 10  1  1  383.60  382.96  382.58  382.89  383.76 
             385.14  386.96  389.22  391.90  394.99 
             398.47  402.35  406.62  411.28  416.32 
             421.75  427.56  454.62  526.90 
/
 8 10  2  1  383.60  382.96  382.58  382.89  383.76 
             385.14  386.96  389.22  391.90  394.99 
             398.47  402.35  406.62  411.28  416.32 
             421.75  427.56  454.62  526.90 
/
 8 10  3  1  383.60  382.96  382.58  382.89  383.76 
             385.14  386.96  389.22  391.90  394.99 
             398.47  402.35  406.62  411.28  416.32 
             421.75  427.56  454.62  526.90 
/
 8 10  4  1  383.60  382.96  382.58  382.89  383.76 
             385.14  386.96  389.22  391.90  394.99 
             398.47  402.35  406.62  411.28  416.32 
             421.75  427.56  454.62  526.90 
/
 8 10  5  1  383.60  382.96  382.58  382.89  383.76 
             385.14  386.96  389.22  391.90  394.99 
             398.47  402.35  406.62  411.28  416.32 
             421.75  427.56  454.62  526.90 
/
 8 10  6  1  383.60  382.96  382.58  382.89  383.76 
             385.14  386.96  389.22  391.90  394.99 
             398.47  402.35  406.62  411.28  416.32 
             421.75  427.56  454.62  526.90 
/
 8 10  7  1  383.60  382.96  382.58  382.89  383.76 
             385.14  386.96  389.22  391.90  394.99 
             398.47  402.35  406.62  411.28  416.32 
             421.75  427.56  454.62  526.90 
/
 8 10  8  1  383.60  382.96  382.58  382.89  383.76 
             385.14  386.96  389.22  391.90  394.99 
             398.47  402.35  406.62  411.28  416.32 
             421.75  427.56  454.62  526.90 
/
 9  1  1  1  357.84  357.58  357.53  357.96  358.85 
             360.20  361.97  364.15  366.74  369.73 
             373.10  376.87  381.01  385.54  390.44 
             395.71  401.37  427.68  497.98 
/
 9  1  2  1  345.30  344.94  344.81  345.24  346.21 
             347.73  349.77  352.32  355.36  358.90 
             362.90  367.38  372.32  377.72  383.57 
             389.87  396.62  428.01  511.54 
/
 9  1  3  1  335.24  333.41  331.50  331.29  332.12 
             333.73  336.14  339.26  342.98  347.37 
             352.40  357.97  364.10  370.85  378.06 
             385.78  394.15  432.31  532.44 
/
 9  1  4  1  329.17  319.29  317.79  317.70  318.82 
             321.00  324.07  328.04  332.82  338.36 
             344.62  351.56  359.16  367.37  376.17 
             385.59  395.61  441.46  559.03 
/
 9  1  5  1  317.84  300.16  298.33  298.66  300.67 
             304.12  308.87  314.80  321.81  329.83 
             338.78  348.63  359.29  370.76  382.99 
             395.95  409.75  472.04  626.43 
/
 9  1  6  1  285.09  277.03  275.97  278.11  282.32 
             288.96  297.45  307.76  319.69  333.11 
             347.80  363.73  380.83  399.03  417.83 
             438.02  459.22  552.71  784.89 
/
 9  1  7  1  252.59  251.68  254.55  262.44  274.60 
             290.43  309.40  331.14  355.35  381.78 
             410.26  441.89  476.39  512.07  549.62 
             589.16  629.94  811.41 1252.24 
/
 9  1  8  1  237.58  239.31  253.99  278.28  310.49 
             349.24  393.64  443.08  497.18  555.75 
             618.71  686.52  761.09  838.59  920.61 
            1005.52 1092.76 1492.15 2526.21 
/
 9  2  1  1  362.04  361.72  361.62  362.02  362.91 
             364.25  366.03  368.23  370.83  373.83 
             377.22  381.00  385.17  389.71  394.64 
             399.94  405.62  432.04  502.64 
/
 9  2  2  1  350.10  349.69  349.50  349.88  350.84 
             352.33  354.35  356.87  359.88  363.38 
             367.34  371.77  376.65  381.99  387.78 
             394.01  400.68  431.70  514.27 
/
 9  2  3  1  340.35  338.58  336.74  336.49  337.26 
             338.81  341.15  344.14  347.79  352.06 
             356.91  362.32  368.35  374.84  381.86 
             389.38  397.52  434.72  532.19 
/
 9  2  4  1  334.52  325.17  323.41  323.23  324.23 
             326.24  329.19  332.93  337.49  342.78 
             348.77  355.35  362.62  370.49  378.95 
             388.01  397.65  441.65  555.48 
/
 9  2  5  1  323.76  305.87  303.83  303.94  305.70 
             308.84  313.22  318.72  325.25  332.73 
             341.12  350.35  360.38  371.18  382.72 
             394.96  408.13  467.14  613.52 
/
 9  2  6  1  304.05  282.12  280.60  282.34  286.57 
             292.54  300.36  309.81  320.80  333.08 
             346.57  361.44  377.11  393.74  411.80 
             430.29  450.27  537.10  752.67 
/
 9  2  7  1  256.06  254.86  256.93  263.62  274.24 
             288.22  305.11  324.58  346.34  370.18 
             395.94  424.67  456.15  488.69  522.96 
             558.38  596.22  760.03 1161.74 
/
 9  2  8  1  239.55  240.57  252.26  273.50  301.88 
             336.13  375.44  419.24  467.19  519.05 
             574.73  634.16  699.05  768.76  840.95 
             916.58  995.38 1344.14 2243.08 
/
 9  3  1  1  366.31  365.95  365.80  366.18  367.06 
             368.41  370.19  372.40  375.01  378.03 
             381.44  385.23  389.42  393.98  398.93 
             404.25  409.95  436.48  507.35 
/
 9  3  2  1  355.09  354.64  354.39  354.75  355.68 
             357.15  359.15  361.64  364.62  368.08 
             372.00  376.37  381.20  386.47  392.19 
             398.34  404.93  435.56  517.14 
/
 9  3  3  1  345.75  344.06  342.40  342.09  342.79 
             344.30  346.54  349.43  352.98  357.12 
             361.83  367.09  372.88  379.18  386.09 
             393.41  401.22  437.43  532.55 
/
 9  3  4  1  340.19  331.59  329.57  329.28  330.16 
             332.04  334.79  338.38  342.68  347.72 
             353.42  359.70  366.65  374.19  382.31 
             391.02  400.15  442.46  551.87 
/
 9  3  5  1  330.10  312.22  310.00  309.92  311.44 
             314.28  318.29  323.36  329.41  336.36 
             344.17  352.79  362.16  372.28  383.11 
             394.62  407.18  463.01  601.54 
/
 9  3  6  1  311.29  288.01  286.04  287.28  290.90 
             296.50  303.83  312.46  322.45  333.85 
             346.10  359.65  374.20  389.68  406.05 
             423.26  441.92  522.11  722.87 
/
 9  3  7  1  260.22  258.73  260.04  265.58  274.70 
             286.89  301.75  318.97  338.33  359.61 
             382.68  409.10  436.92  466.32  497.34 
             530.04  563.67  711.53 1074.40 
/
 9  3  8  1  242.00  242.34  251.36  269.38  294.01 
             323.92  358.34  396.76  438.83  484.33 
             533.11  585.11  640.32  701.49  765.81 
             832.37  901.95 1205.19 1978.44 
/
 9  4  1  1  371.77  370.71  370.30  370.58  371.42 
             372.75  374.53  376.73  379.35  382.37 
             385.79  389.60  393.80  398.38  403.34 
             408.68  414.40  441.02  512.13 
/
 9  4  2  1  361.41  360.25  359.73  359.99  360.86 
             362.30  364.26  366.71  369.65  373.06 
             376.93  381.25  386.01  391.21  396.85 
             402.92  409.42  439.65  520.19 
/
 9  4  3  1  352.42  350.25  348.67  348.19  348.76 
             350.20  352.39  355.17  358.61  362.62 
             367.18  372.28  377.89  384.01  390.62 
             397.73  405.30  440.52  532.81 
/
 9  4  4  1  347.09  342.26  336.38  335.90  336.68 
             338.43  341.02  344.38  348.50  353.23 
             358.66  364.63  371.26  378.46  386.13 
             394.45  403.32  443.90  549.03 
/
 9  4  5  1  337.73  319.29  316.95  316.71  318.00 
             320.55  324.21  328.86  334.42  340.84 
             348.07  356.06  364.79  374.21  384.31 
             395.35  407.07  459.30  590.16 
/
 9  4  6  1  320.00  294.87  292.50  293.26  296.26 
             301.11  307.56  315.44  324.62  334.98 
             346.43  358.91  372.33  386.54  401.70 
             417.68  434.27  508.68  693.51 
/
 9  4  7  1  265.73  263.53  264.09  268.53  276.21 
             286.65  299.53  314.56  331.55  350.32 
             371.29  394.95  419.87  446.25  473.61 
             502.39  532.55  665.73  989.80 
/
 9  4  8  1  245.09  244.80  251.69  266.28  287.09 
             312.76  342.47  375.72  412.17  451.60 
             493.86  538.85  586.56  637.53  693.81 
             751.65  812.13 1075.48 1733.03 
/
 9  5  1  1  377.50  375.67  374.94  375.12  375.91 
             377.22  378.98  381.19  383.80  386.83 
             390.26  394.07  398.28  402.87  407.85 
             413.20  418.94  445.64  516.98 
/
 9  5  2  1  368.60  366.39  365.47  365.57  366.37 
             367.75  369.67  372.08  374.97  378.33 
             382.14  386.39  391.08  396.21  401.77 
             407.75  414.16  443.97  523.42 
/
 9  5  3  1  360.53  357.27  355.39  354.88  355.40 
             356.74  358.77  361.50  364.75  368.63 
             373.03  377.96  383.40  389.32  395.74 
             402.63  409.99  444.01  533.78 
/
 9  5  4  1  355.49  349.86  343.95  343.31  343.90 
             345.52  347.95  351.11  355.01  359.49 
             364.64  370.31  376.61  383.39  390.81 
             398.64  407.12  445.87  546.68 
/
 9  5  5  1  346.89  327.20  324.81  324.43  325.53 
             327.81  331.12  335.35  340.44  346.33 
             352.97  360.34  368.40  377.13  386.80 
             397.02  407.88  456.65  579.94 
/
 9  5  6  1  330.38  302.94  300.20  300.51  302.94 
             307.06  312.65  319.56  327.66  336.86 
             347.08  358.25  370.33  383.26  397.00 
             411.52  426.78  494.89  664.96 
/
 9  5  7  1  276.15  269.58  269.42  272.81  279.10 
             287.87  298.81  311.71  326.37  343.56 
             362.36  382.76  404.71  427.68  452.51 
             478.18  504.44  621.94  908.60 
/
 9  5  8  1  249.09  248.20  253.10  264.66  281.57 
             302.93  328.01  356.25  387.31  420.94 
             457.01  495.40  536.06  578.97  625.70 
             676.00  728.08  954.57 1504.31 
/
 9  6  1  1  383.14  380.69  379.68  379.76  380.50 
             381.78  383.54  385.73  388.35  391.38 
             394.81  398.64  402.85  407.46  412.44 
             417.81  423.56  450.33  521.87 
/
 9  6  2  1  375.83  372.75  371.45  371.42  372.14 
             373.47  375.34  377.70  380.55  383.85 
             387.60  391.78  396.41  401.45  406.93 
             412.82  419.13  448.50  526.84 
/
 9  6  3  1  368.91  364.72  362.49  361.97  362.47 
             363.74  365.71  368.26  371.45  375.12 
             379.37  384.12  389.37  395.10  401.30 
             407.97  415.10  448.11  535.07 
/
 9  6  4  1  364.30  358.02  352.49  351.53  352.00 
             353.41  355.67  358.64  362.26  366.55 
             371.35  376.71  382.68  389.12  396.14 
             403.64  411.63  448.56  544.86 
/
 9  6  5  1  356.61  336.09  333.72  333.26  334.19 
             336.22  339.20  343.03  347.65  353.02 
             359.09  365.83  373.50  381.65  390.49 
             399.88  409.82  455.23  570.19 
/
 9  6  6  1  341.70  312.49  309.49  309.40  311.28 
             314.71  319.48  325.43  332.47  340.51 
             349.50  359.37  370.08  381.59  393.87 
             406.88  420.59  482.12  637.51 
/
 9  6  7  1  284.96  279.49  276.53  278.92  283.89 
             291.05  300.60  311.88  325.03  339.65 
             355.76  373.63  392.56  412.32  433.72 
             455.75  479.30  582.32  833.47 
/
 9  6  8  1  254.45  253.00  256.05  264.77  278.07 
             295.19  315.59  338.85  364.65  392.71 
             422.86  454.99  489.01  524.89  562.58 
             605.24  649.10  839.74 1296.82 
/
 9  7  1  1  388.51  385.69  384.47  384.47  385.17 
             386.43  388.18  390.37  392.99  396.02 
             399.46  403.29  407.51  412.13  417.12 
             422.50  428.27  455.10  526.82 
/
 9  7  2  1  382.88  379.25  377.65  377.50  378.16 
             379.44  381.27  383.59  386.38  389.63 
             393.32  397.44  401.98  406.95  412.34 
             418.14  424.35  453.27  530.45 
/
 9  7  3  1  377.30  372.51  370.03  369.43  369.88 
             371.11  373.02  375.51  378.57  382.15 
             386.24  390.81  395.85  401.38  407.37 
             413.81  420.70  452.62  537.06 
/
 9  7  4  1  373.29  366.71  361.91  360.73  360.95 
             362.22  364.32  367.09  370.49  374.47 
             379.01  384.09  389.68  395.78  402.37 
             409.56  417.11  452.15  543.90 
/
 9  7  5  1  366.71  356.23  343.88  343.40  344.19 
             346.00  348.69  352.22  356.47  361.40 
             367.01  373.26  380.12  387.59  395.64 
             404.24  413.39  455.27  562.29 
/
 9  7  6  1  353.82  323.94  320.81  320.40  321.79 
             324.57  328.55  333.59  339.59  346.50 
             354.26  362.83  372.17  382.24  393.03 
             404.50  416.63  471.42  611.29 
/
 9  7  7  1  324.29  290.24  287.75  288.84  292.56 
             298.54  306.34  315.70  326.67  339.02 
             352.78  367.57  383.55  400.62  418.73 
             437.84  457.92  545.67  760.58 
/
 9  7  8  1  261.96  259.98  261.32  267.43  277.34 
             290.46  306.35  324.69  345.23  367.76 
             392.11  418.16  445.83  475.04  505.75 
             540.90  577.04  734.05 1108.10 
/
 9  8  1  1  393.40  390.57  389.26  389.21  389.90 
             391.15  392.89  395.08  397.70  400.74 
             404.18  408.02  412.25  416.87  421.88 
             427.27  433.04  459.93  531.82 
/
 9  8  2  1  389.45  385.74  384.00  383.79  384.41 
             385.66  387.45  389.73  392.47  395.67 
             399.29  403.34  407.82  412.70  418.00 
             423.71  429.82  458.28  534.27 
/
 9  8  3  1  385.36  380.52  377.97  377.36  377.78 
             378.96  380.79  383.18  386.11  389.54 
             393.46  397.84  402.69  407.98  413.73 
             419.91  426.52  457.26  538.77 
/
 9  8  4  1  382.16  375.82  372.13  370.87  370.90 
             372.07  373.92  376.43  379.61  383.35 
             387.62  392.41  397.69  403.45  409.69 
             416.40  423.57  456.70  544.05 
/
 9  8  5  1  376.88  367.28  356.61  355.86  356.42 
             357.96  360.32  363.48  367.24  371.71 
             376.71  382.37  388.51  395.29  402.62 
             410.35  418.72  457.04  555.96 
/
 9  8  6  1  366.48  337.80  334.75  334.14  335.13 
             337.35  340.60  344.77  349.79  355.60 
             362.17  369.45  377.43  386.06  395.35 
             405.26  415.78  463.68  588.15 
/
 9  8  7  1  341.83  304.85  301.56  302.00  304.83 
             309.53  315.83  323.53  332.51  342.68 
             353.92  366.10  379.21  393.31  408.26 
             424.03  440.58  514.13  693.94 
/
 9  8  8  1  278.20  270.68  270.47  274.19  280.98 
             290.36  301.98  315.62  331.09  348.23 
             366.90  387.01  408.47  432.99  458.76 
             485.95  513.90  638.47  935.62 
/
 9  9  1  1  397.63  395.19  393.96  393.94  394.63 
             395.89  397.64  399.84  402.46  405.51 
             408.96  412.80  417.04  421.67  426.69 
             432.09  437.88  464.82  536.85 
/
 9  9  2  1  395.25  392.05  390.41  390.22  390.85 
             392.08  393.85  396.10  398.80  401.95 
             405.52  409.50  413.90  418.71  423.91 
             429.53  435.54  463.53  538.30 
/
 9  9  3  1  392.69  388.51  386.21  385.69  386.14 
             387.32  389.09  391.40  394.21  397.51 
             401.26  405.46  410.10  415.17  420.67 
             426.59  432.93  462.43  540.89 
/
 9  9  4  1  390.49  385.17  381.99  381.07  381.33 
             382.44  384.24  386.65  389.61  393.10 
             397.09  401.56  406.50  411.91  417.77 
             424.07  430.82  462.12  544.84 
/
 9  9  5  1  386.74  378.99  372.51  370.93  371.00 
             372.22  374.22  376.94  380.28  384.21 
             388.69  393.73  399.30  405.34  411.98 
             419.00  426.50  461.34  552.14 
/
 9  9  6  1  379.33  367.18  352.16  351.53  352.25 
             354.00  356.62  360.02  364.13  368.91 
             374.34  380.39  387.04  394.27  402.07 
             410.42  419.33  461.46  569.61 
/
 9  9  7  1  361.32  325.43  321.75  321.31  322.87 
             325.94  330.28  335.74  342.23  349.68 
             358.03  367.23  377.24  388.03  399.57 
             411.82  424.77  483.09  628.48 
/
 9  9  8  1  328.85  291.29  287.78  289.01  293.13 
             299.32  307.37  317.07  328.29  341.12 
             355.39  370.66  387.51  405.14  423.85 
             444.01  464.85  556.90  780.99 
/
 9 10  1  1  403.71  403.06  402.68  402.99  403.86 
             405.23  407.06  409.32  411.99  415.08 
             418.56  422.44  426.71  431.36  436.40 
             441.83  447.64  474.68  546.94 
/
 9 10  2  1  403.71  403.06  402.68  402.99  403.86 
             405.23  407.06  409.32  411.99  415.08 
             418.56  422.44  426.71  431.36  436.40 
             441.83  447.64  474.68  546.94 
/
 9 10  3  1  403.71  403.06  402.68  402.99  403.86 
             405.23  407.06  409.32  411.99  415.08 
             418.56  422.44  426.71  431.36  436.40 
             441.83  447.64  474.68  546.94 
/
 9 10  4  1  403.71  403.06  402.68  402.99  403.86 
             405.23  407.06  409.32  411.99  415.08 
             418.56  422.44  426.71  431.36  436.40 
             441.83  447.64  474.68  546.94 
/
 9 10  5  1  403.71  403.06  402.68  402.99  403.86 
             405.23  407.06  409.32  411.99  415.08 
             418.56  422.44  426.71  431.36  436.40 
             441.83  447.64  474.68  546.94 
/
 9 10  6  1  403.71  403.06  402.68  402.99  403.86 
             405.23  407.06  409.32  411.99  415.08 
             418.56  422.44  426.71  431.36  436.40 
             441.83  447.64  474.68  546.94 
/
 9 10  7  1  403.71  403.06  402.68  402.99  403.86 
             405.23  407.06  409.32  411.99  415.08 
             418.56  422.44  426.71  431.36  436.40 
             441.83  447.64  474.68  546.94 
/
 9 10  8  1  403.71  403.06  402.68  402.99  403.86 
             405.23  407.06  409.32  411.99  415.08 
             418.56  422.44  426.71  431.36  436.40 
             441.83  447.64  474.68  546.94 
/
10  1  1  1  377.93  377.68  377.64  378.08  378.99 
             380.34  382.11  384.30  386.89  389.88 
             393.26  397.02  401.16  405.69  410.59 
             415.86  421.51  447.81  518.05 
/
10  1  2  1  365.59  365.25  365.16  365.64  366.69 
             368.27  370.36  372.93  375.99  379.52 
             383.51  387.96  392.87  398.22  404.03 
             410.27  416.96  448.09  531.07 
/
10  1  3  1  354.70  353.71  353.03  353.20  354.08 
             355.78  358.17  361.25  364.92  369.22 
             374.11  379.57  385.57  392.12  399.19 
             406.79  414.90  452.56  551.47 
/
10  1  4  1  348.71  342.11  340.66  340.69  341.86 
             343.97  346.96  350.79  355.35  360.67 
             366.69  373.37  380.61  388.57  397.15 
             406.34  416.13  460.89  577.34 
/
10  1  5  1  338.54  323.47  321.96  322.38  324.32 
             327.59  332.08  337.67  344.31  351.91 
             360.43  369.83  380.04  391.07  402.86 
             415.76  429.35  489.70  641.93 
/
10  1  6  1  320.17  301.27  300.25  302.29  306.75 
             313.31  321.46  331.33  342.63  355.46 
             369.56  384.85  401.24  418.69  437.15 
             457.14  477.57  569.71  799.53 
/
10  1  7  1  276.99  276.07  278.60  285.82  297.13 
             311.98  329.95  350.71  373.98  399.56 
             427.29  459.22  492.82  527.98  565.15 
             603.69  644.17  824.81 1265.00 
/
10  1  8  1  261.71  263.10  275.75  298.89  329.92 
             367.53  410.89  459.41  512.73  570.64 
             633.05  700.98  774.52  852.01  933.63 
            1018.11 1105.19 1503.06 2536.89 
/
10  2  1  1  382.13  381.82  381.73  382.15  383.04 
             384.39  386.18  388.38  390.98  393.98 
             397.37  401.15  405.32  409.86  414.78 
             420.08  425.75  452.17  522.71 
/
10  2  2  1  370.38  369.99  369.83  370.28  371.30 
             372.86  374.92  377.47  380.49  383.98 
             387.93  392.34  397.19  402.49  408.23 
             414.41  421.02  451.80  533.87 
/
10  2  3  1  359.83  358.84  358.12  358.28  359.12 
             360.75  363.07  366.07  369.63  373.83 
             378.59  383.90  389.75  396.13  403.03 
             410.43  418.34  454.90  551.38 
/
10  2  4  1  353.97  347.82  346.20  346.11  347.12 
             349.11  351.95  355.61  359.97  365.07 
             370.84  377.18  384.23  391.89  400.05 
             408.89  418.33  461.44  573.66 
/
10  2  5  1  344.28  329.06  327.37  327.60  329.31 
             332.31  336.46  341.67  347.86  354.98 
             362.97  371.80  381.42  391.80  402.93 
             415.19  428.07  485.23  629.87 
/
10  2  6  1  326.48  306.32  304.90  306.48  310.36 
             316.23  323.85  333.05  343.70  355.54 
             368.43  382.69  398.01  414.35  431.16 
             449.87  468.99  554.20  767.58 
/
10  2  7  1  280.52  279.34  281.14  287.26  297.11 
             310.21  326.18  344.71  365.58  388.59 
             413.89  442.88  473.08  505.04  538.86 
             573.90  610.70  774.03 1172.78 
/
10  2  8  1  263.77  264.51  274.71  294.54  321.71 
             354.84  393.12  436.01  483.16  534.33 
             589.42  648.37  713.59  782.54  854.35 
             929.65 1008.03 1355.03 2252.98 
/
10  3  1  1  386.40  386.05  385.91  386.31  387.19 
             388.54  390.33  392.54  395.16  398.17 
             401.58  405.38  409.56  414.13  419.07 
             424.39  430.08  456.60  527.41 
/
10  3  2  1  375.37  374.93  374.72  375.13  376.13 
             377.66  379.70  382.22  385.21  388.66 
             392.57  396.92  401.72  406.95  412.63 
             418.73  425.27  455.69  536.80 
/
10  3  3  1  365.27  364.28  363.54  363.65  364.55 
             366.08  368.38  371.25  374.70  378.78 
             383.41  388.57  394.27  400.47  407.18 
             414.40  422.10  457.73  551.89 
/
10  3  4  1  359.57  356.24  352.19  351.99  352.90 
             354.77  357.47  360.92  365.08  369.95 
             375.41  381.55  388.31  395.58  403.52 
             411.91  420.96  462.40  570.71 
/
10  3  5  1  350.45  335.25  333.42  333.47  334.98 
             337.71  341.53  346.36  352.11  358.74 
             366.20  374.45  383.46  393.20  403.95 
             415.41  427.33  481.31  618.34 
/
10  3  6  1  333.42  312.14  310.34  311.47  314.79 
             319.97  326.78  335.07  344.71  355.59 
             367.64  380.76  394.90  410.01  426.04 
             442.96  460.74  539.82  738.45 
/
10  3  7  1  284.73  283.29  284.39  289.45  297.91 
             309.31  323.33  339.70  358.22  378.70 
             401.95  427.84  454.96  483.81  513.84 
             545.46  578.68  725.83 1085.01 
/
10  3  8  1  266.30  266.43  274.54  291.01  314.33 
             343.10  376.49  414.00  455.25  500.03 
             548.21  599.69  654.46  715.84  779.65 
             845.83  915.13 1216.20 1988.74 
/
10  4  1  1  391.87  390.81  390.41  390.71  391.55 
             392.89  394.67  396.88  399.49  402.52 
             405.94  409.74  413.94  418.52  423.47 
             428.81  434.53  461.13  532.20 
/
10  4  2  1  381.67  380.52  380.04  380.36  381.29 
             382.78  384.78  387.26  390.21  393.61 
             397.47  401.77  406.50  411.67  417.27 
             423.30  429.76  459.80  539.91 
/
10  4  3  1  371.95  370.43  369.49  369.52  370.36 
             371.91  374.08  376.85  380.26  384.21 
             388.64  393.66  399.18  405.21  411.73 
             418.74  426.23  460.90  552.31 
/
10  4  4  1  366.35  362.76  358.83  358.46  359.25 
             361.01  363.56  366.84  370.79  375.39 
             380.66  386.48  392.86  399.90  407.47 
             415.51  424.16  464.06  567.77 
/
10  4  5  1  357.86  342.14  340.20  340.11  341.42 
             343.89  347.40  351.84  357.16  363.30 
             370.23  377.90  386.30  395.65  405.61 
             416.25  427.55  478.27  607.43 
/
10  4  6  1  341.78  318.89  316.74  317.45  320.23 
             324.73  330.75  338.14  346.77  356.57 
             367.45  379.35  392.21  405.99  420.65 
             436.14  452.44  525.40  708.86 
/
10  4  7  1  293.69  288.16  288.59  292.64  299.75 
             309.52  321.64  335.91  352.11  370.63 
             391.75  414.32  438.55  463.93  491.35 
             519.76  548.92  680.77 1002.33 
/
10  4  8  1  269.48  269.04  275.19  288.63  308.05 
             332.49  361.14  393.47  429.10  467.80 
             509.42  553.88  601.11  652.45  708.05 
             765.59  825.71 1088.07 1744.27 
/
10  5  1  1  397.60  395.77  395.06  395.25  396.04 
             397.35  399.12  401.32  403.94  406.97 
             410.39  414.21  418.41  423.00  427.98 
             433.33  439.06  465.74  537.04 
/
10  5  2  1  388.83  386.63  385.75  385.92  386.78 
             388.21  390.15  392.59  395.48  398.84 
             402.64  406.87  411.54  416.64  422.17 
             428.12  434.48  464.13  543.21 
/
10  5  3  1  380.18  377.46  376.08  375.96  376.70 
             378.16  380.28  382.99  386.27  390.07 
             394.41  399.27  404.63  410.48  416.70 
             423.50  430.77  464.45  553.41 
/
10  5  4  1  374.82  370.28  366.34  365.70  366.34 
             367.91  370.31  373.40  377.15  381.52 
             386.53  392.07  398.19  404.86  412.12 
             419.81  428.13  466.10  565.67 
/
10  5  5  1  366.98  349.83  347.83  347.63  348.76 
             351.00  354.19  358.26  363.15  368.81 
             375.20  382.41  390.40  398.97  408.28 
             418.10  428.53  476.07  597.31 
/
10  5  6  1  351.93  326.78  324.33  324.64  326.92 
             330.77  336.02  342.51  350.16  358.87 
             368.60  379.27  390.84  403.27  416.53 
             430.58  445.40  511.95  680.18 
/
10  5  7  1  300.65  294.25  294.03  297.13  302.95 
             311.15  321.45  333.67  348.69  365.20 
             383.17  403.02  424.08  447.03  470.43 
             495.65  522.22  637.84  922.15 
/
10  5  8  1  273.59  272.61  276.94  287.55  303.32 
             323.47  347.40  374.65  404.85  437.74 
             473.14  510.95  551.11  593.57  640.76 
             690.65  742.16  967.56 1517.53 
/
10  6  1  1  403.25  400.79  399.79  399.88  400.63 
             401.91  403.67  405.87  408.48  411.51 
             414.94  418.77  422.98  427.58  432.57 
             437.93  443.68  470.43  541.93 
/
10  6  2  1  396.04  392.97  391.71  391.74  392.51 
             393.88  395.78  398.16  401.01  404.31 
             408.05  412.22  416.83  421.85  427.30 
             433.16  439.44  468.67  546.69 
/
10  6  3  1  388.69  384.91  383.12  382.85  383.49 
             384.87  386.89  389.49  392.64  396.33 
             400.51  405.20  410.37  416.02  422.14 
             428.72  435.76  468.44  554.88 
/
10  6  4  1  383.76  378.37  374.63  373.76  374.20 
             375.62  377.82  380.74  384.29  388.44 
             393.16  398.42  404.22  410.63  417.47 
             424.81  432.64  469.10  564.46 
/
10  6  5  1  376.69  358.45  356.47  356.19  357.17 
             359.18  362.08  365.79  370.35  375.64 
             381.60  388.24  395.52  403.42  411.94 
             421.04  430.86  475.07  588.49 
/
10  6  6  1  363.03  336.09  333.42  333.39  335.18 
             338.42  342.92  348.55  355.22  362.87 
             371.44  380.89  391.16  402.24  414.09 
             426.68  439.99  500.06  653.09 
/
10  6  7  1  310.18  304.16  301.63  303.72  308.50 
             315.50  324.44  335.29  347.85  361.79 
             377.45  394.56  412.65  432.42  453.18 
             474.70  497.42  598.94  848.04 
/
10  6  8  1  279.06  277.58  280.21  288.19  300.55 
             316.64  335.99  358.23  383.07  410.29 
             439.71  471.19  504.66  540.06  578.48 
             620.30  663.62  853.18 1309.32 
/
10  7  1  1  408.61  405.79  404.58  404.58  405.29 
             406.55  408.30  410.50  413.11  416.14 
             419.58  423.41  427.63  432.24  437.24 
             442.62  448.38  475.19  546.87 
/
10  7  2  1  403.06  399.45  397.88  397.79  398.49 
             399.81  401.66  403.99  406.79  410.03 
             413.71  417.82  422.35  427.30  432.67 
             438.44  444.63  473.43  550.35 
/
10  7  3  1  397.20  392.72  390.59  390.19  390.76 
             392.06  393.99  396.48  399.51  403.05 
             407.08  411.59  416.57  422.01  427.91 
             434.26  441.05  472.61  556.34 
/
10  7  4  1  392.94  387.02  383.77  382.65  382.88 
             384.13  386.21  388.89  392.23  396.16 
             400.63  405.62  411.13  417.15  423.65 
             430.64  438.10  472.59  563.48 
/
10  7  5  1  386.82  377.32  366.75  366.31  367.12 
             368.90  371.58  374.96  379.11  383.86 
             389.32  395.40  402.09  409.37  417.11 
             425.51  434.45  475.26  581.02 
/
10  7  6  1  374.93  347.18  344.41  344.11  345.47 
             348.14  351.93  356.74  362.47  369.07 
             376.51  384.74  393.73  403.44  413.87 
             424.99  436.77  490.27  628.34 
/
10  7  7  1  347.67  314.79  312.38  313.75  317.67 
             323.31  330.76  339.81  350.23  362.08 
             375.39  389.64  404.96  421.68  439.03 
             457.87  477.09  563.26  776.17 
/
10  7  8  1  286.66  284.72  285.80  291.36  300.55 
             312.83  327.85  345.30  364.97  386.67 
             410.25  435.59  462.60  491.22  522.93 
             557.27  592.23  747.93 1118.84 
/
10  8  1  1  413.50  410.67  409.36  409.32  410.01 
             411.26  413.01  415.20  417.82  420.85 
             424.29  428.13  432.36  436.98  441.98 
             447.37  453.14  480.02  551.86 
/
10  8  2  1  409.61  405.92  404.21  404.04  404.70 
             405.97  407.78  410.07  412.81  416.01 
             419.63  423.67  428.13  433.00  438.28 
             443.97  450.06  478.43  554.22 
/
10  8  3  1  405.37  400.73  398.44  397.98  398.50 
             399.74  401.59  403.99  406.90  410.30 
             414.17  418.51  423.30  428.53  434.21 
             440.32  446.86  477.29  558.20 
/
10  8  4  1  402.02  396.12  392.88  391.98  392.30 
             393.50  395.42  397.94  401.08  404.75 
             408.97  413.70  418.82  424.51  430.68 
             437.31  444.40  477.24  563.84 
/
10  8  5  1  397.05  388.17  379.33  378.43  378.96 
             380.47  382.78  385.80  389.48  393.85 
             398.75  404.29  410.30  416.96  424.03 
             431.74  439.83  477.50  575.36 
/
10  8  6  1  387.40  360.56  357.88  357.40  358.41 
             360.58  363.72  367.74  372.58  378.18 
             384.52  391.56  399.27  407.65  416.66 
             426.30  436.54  483.57  606.27 
/
10  8  7  1  364.55  329.09  326.01  326.39  329.00 
             333.38  339.26  346.51  354.99  364.62 
             375.34  387.06  399.75  413.35  427.83 
             443.14  459.27  531.33  709.24 
/
10  8  8  1  302.97  295.52  295.21  298.59  304.88 
             313.65  324.60  337.53  352.26  368.68 
             386.66  406.11  428.16  452.20  477.49 
             503.67  531.19  653.60  948.99 
/
10  9  1  1  417.74  415.30  414.07  414.04  414.74 
             416.00  417.75  419.95  422.57  425.62 
             429.06  432.91  437.15  441.78  446.79 
             452.19  457.97  484.90  556.89 
/
10  9  2  1  415.39  412.20  410.59  410.43  411.08 
             412.33  414.11  416.37  419.07  422.21 
             425.78  429.76  434.15  438.94  444.14 
             449.74  455.74  483.66  558.29 
/
10  9  3  1  412.77  408.72  406.58  406.16  406.68 
             407.89  409.69  412.00  414.80  418.08 
             421.81  425.97  430.58  435.61  441.07 
             446.94  453.24  482.52  560.57 
/
10  9  4  1  410.52  405.45  402.57  401.80  402.16 
             403.31  405.13  407.53  410.47  413.92 
             417.86  422.27  427.15  432.49  438.27 
             444.49  451.16  482.10  564.13 
/
10  9  5  1  406.96  399.66  394.81  393.06  393.04 
             394.18  396.11  398.79  402.09  405.90 
             410.32  415.27  420.81  426.78  433.24 
             440.17  447.57  481.84  571.80 
/
10  9  6  1  400.03  388.64  374.59  374.10  374.87 
             376.62  379.19  382.51  386.52  391.19 
             396.48  402.38  408.86  415.92  423.55 
             432.14  441.04  482.26  588.78 
/
10  9  7  1  383.25  349.03  345.66  345.28  346.77 
             349.68  353.80  359.00  365.19  372.31 
             380.31  389.15  398.79  409.20  420.36 
             432.24  444.82  501.76  645.03 
/
10  9  8  1  352.94  316.04  313.40  314.37  318.04 
             323.87  331.56  340.96  351.87  364.19 
             377.84  392.77  408.79  426.25  444.62 
             464.05  484.52  575.33  796.09 
/
10 10  1  1  423.82  423.16  422.78  423.09  423.96 
             425.33  427.16  429.42  432.09  435.17 
             438.65  442.53  446.79  451.45  456.49 
             461.91  467.72  494.75  566.97 
/
10 10  2  1  423.82  423.16  422.78  423.09  423.96 
             425.33  427.16  429.42  432.09  435.17 
             438.65  442.53  446.79  451.45  456.49 
             461.91  467.72  494.75  566.97 
/
10 10  3  1  423.82  423.16  422.78  423.09  423.96 
             425.33  427.16  429.42  432.09  435.17 
             438.65  442.53  446.79  451.45  456.49 
             461.91  467.72  494.75  566.97 
/
10 10  4  1  423.82  423.16  422.78  423.09  423.96 
             425.33  427.16  429.42  432.09  435.17 
             438.65  442.53  446.79  451.45  456.49 
             461.91  467.72  494.75  566.97 
/
10 10  5  1  423.82  423.16  422.78  423.09  423.96 
             425.33  427.16  429.42  432.09  435.17 
             438.65  442.53  446.79  451.45  456.49 
             461.91  467.72  494.75  566.97 
/
10 10  6  1  423.82  423.16  422.78  423.09  423.96 
             425.33  427.16  429.42  432.09  435.17 
             438.65  442.53  446.79  451.45  456.49 
             461.91  467.72  494.75  566.97 
/
10 10  7  1  423.82  423.16  422.78  423.09  423.96 
             425.33  427.16  429.42  432.09  435.17 
             438.65  442.53  446.79  451.45  456.49 
             461.91  467.72  494.75  566.97 
/
10 10  8  1  423.82  423.16  422.78  423.09  423.96 
             425.33  427.16  429.42  432.09  435.17 
             438.65  442.53  446.79  451.45  456.49 
             461.91  467.72  494.75  566.97 
/
