% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_model.R
\name{as.list.glmGamPoi}
\alias{as.list.glmGamPoi}
\title{Convert glmGamPoi object to a list}
\usage{
\method{as.list}{glmGamPoi}(x, ...)
}
\arguments{
\item{x}{an object with class glmGamPoi}

\item{...}{not used}
}
\value{
The method returns a list with the following elements:
\describe{
\item{\code{Beta}}{a matrix with dimensions \verb{nrow(data) x n_coefficients} where \code{n_coefficients} is
based on the \code{design} argument. It contains the estimated coefficients for each gene.}
\item{\code{overdispersions}}{a vector with length \code{nrow(data)}. The overdispersion parameter for each
gene. It describes how much more the counts vary than one would expect according to the Poisson
model.}
\item{\code{Mu}}{a matrix with the same dimensions as \code{dim(data)}. If the calculation happened on
disk, than \code{Mu} is a \code{HDF5Matrix}. It contains the estimated mean value for each gene and
sample.}
\item{\code{size_factors}}{a vector with length \code{ncol(data)}. The size factors are the inferred
correction factors for different sizes of each sample. They are also sometimes called the
exposure factor.}
\item{\code{model_matrix}}{a matrix with dimensions \verb{ncol(data) x n_coefficients}. It is build based
on the \code{design} argument.}
}
}
\description{
Convert glmGamPoi object to a list
}
