% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numDetectedAcrossFeatures.R
\name{numDetectedAcrossFeatures}
\alias{numDetectedAcrossFeatures}
\alias{numDetectedAcrossFeatures,ANY-method}
\alias{numDetectedAcrossFeatures,SummarizedExperiment-method}
\title{Number of detected expression values per group of features}
\usage{
numDetectedAcrossFeatures(x, ...)

\S4method{numDetectedAcrossFeatures}{ANY}(
  x,
  ids,
  subset.row = NULL,
  subset.col = NULL,
  average = FALSE,
  threshold = 0,
  BPPARAM = SerialParam(),
  subset_row = NULL,
  subset_col = NULL,
  detection_limit = NULL
)

\S4method{numDetectedAcrossFeatures}{SummarizedExperiment}(x, ..., assay.type = "counts", exprs_values = NULL)
}
\arguments{
\item{x}{A numeric matrix of counts containing features in rows and cells in columns.
Alternatively, a \linkS4class{SummarizedExperiment} object containing such a count matrix.}

\item{...}{For the generic, further arguments to pass to specific methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.}

\item{ids}{A factor of length \code{nrow(x)}, specifying the set to which each feature in \code{x} belongs.

Alternatively, a list of integer or character vectors, where each vector specifies the indices or names of features in a set.
Logical vectors are also supported.}

\item{subset.row}{An integer, logical or character vector specifying the features to use.
Defaults to all features.}

\item{subset.col}{An integer, logical or character vector specifying the cells to use.
Defaults to all cells with non-\code{NA} entries of \code{ids}.}

\item{average}{Logical scalar indicating whether the proportion of non-zero counts in each group should be computed instead.}

\item{threshold}{A numeric scalar specifying the threshold above which a gene is considered to be detected.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether summation should be parallelized.}

\item{subset_row, subset_col, detection_limit, exprs_values}{Soft-deprecated equivalents of the arguments above.}

\item{assay.type}{A string or integer scalar specifying the assay of \code{x} containing the matrix of counts
(or any other expression quantity that can be meaningfully summed).}
}
\value{
An integer matrix containing the number of detected expression values in each group of features (row) and cell (column).
If \code{average=TRUE}, this is instead a numeric matrix containing the proportion of detected values.
}
\description{
Computes the number of detected expression values (by default, defined as non-zero counts) 
for each group of features in each cell.
}
\examples{
example_sce <- mockSCE()

ids <- sample(paste0("GENE_", 1:100), nrow(example_sce), replace=TRUE)
byrow <- numDetectedAcrossFeatures(example_sce, ids)
head(byrow[,1:10])

}
\seealso{
\code{\link{sumCountsAcrossFeatures}}, on which this function is based.
}
\author{
Aaron Lun
}
