\name{TitanCNA trained dataset}
\docType{data}

\alias{TitanCNA-dataset}
\alias{EMresults}
\alias{convergeParams}
\alias{data}
\title{TITAN EM trained results for an example dataset}
\usage{
  data(EMresults)
}

\description{
  Data for chromosome 2 for a triple-negative breast cancer dataset and the expectation-maximization (EM) trained results. Only 20,000 datapoints are included and the data has been scrambled to anonymize patient SNPs.
  \describe{
    \item{data}{Processed input data that is first generated by
      \code{\link{loadAlleleCounts}}, and includes log ratios that 
      have been GC content and mappability corrected using 
      \code{\link{correctReadDepth}}}.
    \item{convergeParams}{EM results that are generated by 
      \code{\link{runEMclonalCN}}}
  }
}


\format{
  \sQuote{data} is a list.
  \sQuote{convergeParams} is a list.
}

\references{
Shah SP et al. (2012). The clonal and mutational evolution spectrum of primary triple-negative breast cancers. Nature, 486(7403): 395-399. (PMID: 22495314)

Ha, G., Roth, A., Lai, D., Bashashati, A., Ding, J., Goya, R., Giuliany, R., Rosner, J., Oloumi, A., Shumansky, K., Chin, S.F., Turashvili, G., Hirst, M., Caldas, C., Marra, M. A., Aparicio, S., and Shah, S. P. (2012). Integrative analysis of genome wide loss of heterozygosity and monoallelic expression at nucleotide resolution reveals disrupted pathways in triple negative breast cancer. Genome Research, 22(10):1995,2007. (PMID: 22637570)

Ha, G., Roth, A., Khattra, J., Ho, J., Yap, D., Prentice, L. M., Melnyk, N., McPherson, A., Bashashati, A., Laks, E., Biele, J., Ding, J., Le, A., Rosner, J., Shumansky, K., Marra, M. A., Huntsman, D. G., McAlpine, J. N., Aparicio, S. A. J. R., and Shah, S. P. (2014). TITAN: Inference of copy number architectures in clonal cell populations from tumour whole genome sequence data. Genome Research, 24: 1881-1893. (PMID: 25060187)
}

\keyword{datasets}

