% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_metric.R
\name{maximize_metric}
\alias{maximize_metric}
\alias{minimize_metric}
\title{Optimize a metric function in binary classification}
\usage{
maximize_metric(
  data,
  x,
  class,
  metric_func = youden,
  pos_class = NULL,
  neg_class = NULL,
  direction,
  tol_metric,
  use_midpoints,
  ...
)

minimize_metric(
  data,
  x,
  class,
  metric_func = youden,
  pos_class = NULL,
  neg_class = NULL,
  direction,
  tol_metric,
  use_midpoints,
  ...
)
}
\arguments{
\item{data}{A data frame or tibble in which the columns that are given in x
and class can be found.}

\item{x}{(character) The variable name to be used for classification,
e.g. predictions or test values.}

\item{class}{(character) The variable name indicating class membership.}

\item{metric_func}{(function) A function that computes a
metric to be maximized. See description.}

\item{pos_class}{The value of class that indicates the positive class.}

\item{neg_class}{The value of class that indicates the negative class.}

\item{direction}{(character) Use ">=" or "<=" to select whether an x value
>= or <= the cutoff predicts the positive class.}

\item{tol_metric}{All cutpoints will be returned that lead to a metric
value in the interval [m_max - tol_metric, m_max + tol_metric] where
m_max is the maximum achievable metric value. This can be used to return
multiple decent cutpoints and to avoid floating-point problems.}

\item{use_midpoints}{(logical) If TRUE (default FALSE) the returned optimal
cutpoint will be the mean of the optimal cutpoint and the next highest
observation (for direction = ">") or the next lowest observation
(for direction = "<") which avoids biasing the optimal cutpoint.}

\item{...}{Further arguments that will be passed to \code{metric_func}.}
}
\value{
A tibble with the columns \code{optimal_cutpoint}, the corresponding metric
value and \code{roc_curve}, a nested tibble that includes all possible cutoffs
and the corresponding numbers of true and false positives / negatives and
all corresponding metric values.
}
\description{
Given a function for computing a metric in \code{metric_func}, these functions
maximize or minimize that metric by selecting an optimal cutpoint.
The metric function should accept the following inputs:
\itemize{
 \item \code{tp}: vector of number of true positives
 \item \code{fp}: vector of number of false positives
 \item \code{tn}: vector of number of true negatives
 \item \code{fn}: vector of number of false negatives
}
}
\details{
The above inputs are arrived at by using all unique values in \code{x}, Inf, or
-Inf as possible cutpoints for classifying the variable in class.
}
\examples{
cutpointr(suicide, dsi, suicide, method = maximize_metric, metric = accuracy)
cutpointr(suicide, dsi, suicide, method = minimize_metric, metric = abs_d_sens_spec)
}
\seealso{
Other method functions: 
\code{\link{maximize_boot_metric}()},
\code{\link{maximize_gam_metric}()},
\code{\link{maximize_loess_metric}()},
\code{\link{oc_manual}()},
\code{\link{oc_mean}()},
\code{\link{oc_median}()},
\code{\link{oc_youden_kernel}()},
\code{\link{oc_youden_normal}()}
}
\concept{method functions}
