% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeX.R
\name{na.replace}
\alias{na.replace}
\title{Replace the missing entries in a matrix columnwise with the entries in a
supplied vector}
\usage{
na.replace(x, m = rowSums(x, na.rm = TRUE))
}
\arguments{
\item{x}{A matrix with potentially missing values, and also potentially in
sparse matrix format (i.e. inherits from "sparseMatrix")}

\item{m}{Optional argument. A vector of values used to replace the missing
entries, columnwise. If missing, the column means of 'x' are used}
}
\value{
A version of 'x' is returned with the missing values replaced.
}
\description{
Missing entries in any given column of the matrix are replaced by the column
means or the values in a supplied vector.
}
\details{
This is a simple imputation scheme. This function is called by \code{makeX}
if the \code{na.impute=TRUE} option is used, but of course can be used on
its own. If 'x' is sparse, the result is sparse, and the replacements are
done so as to maintain sparsity.
}
\examples{

set.seed(101)
### Single data frame
X = matrix(rnorm(20), 10, 2)
X[3, 1] = NA
X[5, 2] = NA
X3 = sample(letters[1:3], 10, replace = TRUE)
X3[6] = NA
X4 = sample(LETTERS[1:3], 10, replace = TRUE)
X4[9] = NA
dfn = data.frame(X, X3, X4)

x = makeX(dfn)
m = rowSums(x, na.rm = TRUE)
na.replace(x, m)

x = makeX(dfn, sparse = TRUE)
na.replace(x, m)

}
\seealso{
\code{makeX} and \code{glmnet}
}
\author{
Trevor Hastie\cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{models}
