% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp-body.R
\name{resp_body_raw}
\alias{resp_body_raw}
\alias{resp_has_body}
\alias{resp_body_string}
\alias{resp_body_json}
\alias{resp_body_html}
\alias{resp_body_xml}
\title{Extract body from response}
\usage{
resp_body_raw(resp)

resp_has_body(resp)

resp_body_string(resp, encoding = NULL)

resp_body_json(resp, check_type = TRUE, simplifyVector = FALSE, ...)

resp_body_html(resp, check_type = TRUE, ...)

resp_body_xml(resp, check_type = TRUE, ...)
}
\arguments{
\item{resp}{A httr2 \link{response} object, created by \code{\link[=req_perform]{req_perform()}}.}

\item{encoding}{Character encoding of the body text. If not specified,
will use the encoding specified by the content-type, falling back to
UTF-8 with a warning if it cannot be found. The resulting string is
always re-encoded to UTF-8.}

\item{check_type}{Check that response has expected content type? Set to
\code{FALSE} to suppress the automated check}

\item{simplifyVector}{Should JSON arrays containing only primitives (i.e.
booleans, numbers, and strings) be caused to atomic vectors?}

\item{...}{Other arguments passed on to \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} and
\code{\link[xml2:read_xml]{xml2::read_xml()}} respectively.}
}
\value{
\itemize{
\item \code{resp_body_raw()} returns a raw vector.
\item \code{resp_body_string()} returns a string.
\item \code{resp_body_json()} returns NULL, an atomic vector, or list.
\item \code{resp_body_html()} and \code{resp_body_xml()} return an \code{xml2::xml_document}
}
}
\description{
\itemize{
\item \code{resp_body_raw()} returns the raw bytes.
\item \code{resp_body_string()} returns a UTF-8 string.
\item \code{resp_body_json()} returns parsed JSON.
\item \code{resp_body_html()} returns parsed HTML.
\item \code{resp_body_xml()} returns parsed XML.
\item \code{resp_has_body()} returns \code{TRUE} if the response has a body.
}

\code{resp_body_json()} and \code{resp_body_xml()} check that the content-type header
is correct; if the server returns an incorrect type you can suppress the
check with \code{check_type = FALSE}. These two functions also cache the parsed
object so the second and subsequent calls are low-cost.
}
\examples{
resp <- request("https://httr2.r-lib.org") |> req_perform()
resp

resp |> resp_has_body()
resp |> resp_body_raw()
resp |> resp_body_string()

if (requireNamespace("xml2", quietly = TRUE)) {
  resp |> resp_body_html()
}
}
