% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{f_rhs}
\alias{f_rhs}
\alias{f_rhs<-}
\alias{f_lhs}
\alias{f_lhs<-}
\alias{f_env}
\alias{f_env<-}
\title{Get or set formula components}
\usage{
f_rhs(f)

f_rhs(x) <- value

f_lhs(f)

f_lhs(x) <- value

f_env(f)

f_env(x) <- value
}
\arguments{
\item{f, x}{A formula}

\item{value}{The value to replace with.}
}
\value{
\code{f_rhs} and \code{f_lhs} return language objects (i.e.  atomic
vectors of length 1, a name, or a call). \code{f_env} returns an
environment.
}
\description{
\code{f_rhs} extracts the righthand side, \code{f_lhs} extracts the lefthand
side, and \code{f_env} extracts the environment. All functions throw an
error if \code{f} is not a formula.
}
\examples{
f_rhs(~ 1 + 2 + 3)
f_rhs(~ x)
f_rhs(~ "A")
f_rhs(1 ~ 2)

f_lhs(~ y)
f_lhs(x ~ y)

f_env(~ x)
}
