
# taxize

[![Project Status: Active – The project has reached a stable, usable
state and is being actively
developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![cran
checks](https://cranchecks.info/badges/worst/taxize)](https://cranchecks.info/pkgs/taxize)
[![R-CMD-check](https://github.com/ropensci/taxize/workflows/R-CMD-check/badge.svg)](https://github.com/ropensci/taxize/actions/)
[![codecov](https://codecov.io/gh/ropensci/taxize/branch/master/graph/badge.svg)](https://app.codecov.io/gh/ropensci/taxize)
[![rstudio mirror
downloads](https://cranlogs.r-pkg.org/badges/taxize)](https://github.com/r-hub/cranlogs.app)
[![cran
version](https://www.r-pkg.org/badges/version/taxize)](https://cran.r-project.org/package=taxize)

`taxize` allows users to search over many taxonomic data sources for
species names (scientific and common) and download up and downstream
taxonomic hierarchical information - among other things.

The taxize book: <https://taxize.dev>

Package documentation: <https://docs.ropensci.org/taxize/>

## Installation

### Stable version from CRAN

``` r
install.packages("taxize")
```

### Development version from GitHub

Windows users install Rtools first.

``` r
install.packages("remotes")
remotes::install_github("ropensci/taxize")
```

``` r
library('taxize')
```

## Screencast

<a href="https://vimeo.com/92883063"><img src="man/figures/screencast.png" width="400"></a>

## Contributing

See our
[CONTRIBUTING](https://github.com/ropensci/taxize/blob/master/.github/CONTRIBUTING.md)
document.

## Contributors

Collected via GitHub Issues: honors all contributors in alphabetical
order. Code contributors are in bold.

[afkoeppel](https://github.com/afkoeppel) -
[ahhurlbert](https://github.com/ahhurlbert) -
[albnd](https://github.com/albnd) -
[Alectoria](https://github.com/Alectoria) -
[andzandz11](https://github.com/andzandz11) -
**[anirvan](https://github.com/anirvan)** -
[antagomir](https://github.com/antagomir) -
**[arendsee](https://github.com/arendsee)** -
[ArielGreiner](https://github.com/ArielGreiner) -
[arw36](https://github.com/arw36) -
[ashenkin](https://github.com/ashenkin) -
**[ashiklom](https://github.com/ashiklom)** -
[benjaminschwetz](https://github.com/benjaminschwetz) -
**[benmarwick](https://github.com/benmarwick)** -
[bienflorencia](https://github.com/bienflorencia) -
[binkySallly](https://github.com/binkySallly) -
[bomeara](https://github.com/bomeara) -
[BridgettCollis](https://github.com/BridgettCollis) -
[bw4sz](https://github.com/bw4sz) -
**[cboettig](https://github.com/cboettig)** -
[cdeterman](https://github.com/cdeterman) -
[ChrKoenig](https://github.com/ChrKoenig) -
[chuckrp](https://github.com/chuckrp) -
[clarson2191](https://github.com/clarson2191) -
[claudenozeres](https://github.com/claudenozeres) -
[cmzambranat](https://github.com/cmzambranat) -
[cparsania](https://github.com/cparsania) -
[daattali](https://github.com/daattali) -
[DanielGMead](https://github.com/DanielGMead) -
[DarrenObbard](https://github.com/DarrenObbard) -
[davharris](https://github.com/davharris) -
[davidvilanova](https://github.com/davidvilanova) -
[diogoprov](https://github.com/diogoprov) -
**[dlebauer](https://github.com/dlebauer)** -
[dlenz1](https://github.com/dlenz1) -
[dougwyu](https://github.com/dougwyu) -
[dschlaep](https://github.com/dschlaep) -
**[EDiLD](https://github.com/EDiLD)** -
[edwbaker](https://github.com/edwbaker) -
[emhart](https://github.com/emhart) -
[eregenyi](https://github.com/eregenyi) -
[fdschneider](https://github.com/fdschneider) -
[fgabriel1891](https://github.com/fgabriel1891) -
[fischhoff](https://github.com/fischhoff) -
**[fmichonneau](https://github.com/fmichonneau)** -
**[fozy81](https://github.com/fozy81)** -
**[gedankenstuecke](https://github.com/gedankenstuecke)** -
[gimoya](https://github.com/gimoya) -
[git-og](https://github.com/git-og) -
[glaroc](https://github.com/glaroc) -
**[gpli](https://github.com/gpli)** -
[gustavobio](https://github.com/gustavobio) -
[hlapp](https://github.com/hlapp) -
**[ibartomeus](https://github.com/ibartomeus)** -
**[Ironholds](https://github.com/Ironholds)** -
[jabard89](https://github.com/jabard89) -
[jangorecki](https://github.com/jangorecki) -
**[jarioksa](https://github.com/jarioksa)** -
[jebyrnes](https://github.com/jebyrnes) -
**[jeroen](https://github.com/jeroen)** -
**[jimmyodonnell](https://github.com/jimmyodonnell)** -
[joelnitta](https://github.com/joelnitta) -
[johnbaums](https://github.com/johnbaums) -
[jonmcalder](https://github.com/jonmcalder) -
[jordancasey](https://github.com/jordancasey) -
**[josephwb](https://github.com/josephwb)** -
[jsgosnell](https://github.com/jsgosnell) -
[JulietteLgls](https://github.com/JulietteLgls) -
**[jwilk](https://github.com/jwilk)** -
[kamapu](https://github.com/kamapu) -
**[karthik](https://github.com/karthik)** -
**[katrinleinweber](https://github.com/katrinleinweber)** -
[KevCaz](https://github.com/KevCaz) -
[kgturner](https://github.com/kgturner) -
[kmeverson](https://github.com/kmeverson) -
[Koalha](https://github.com/Koalha) -
**[ljvillanueva](https://github.com/ljvillanueva)** -
**[maelle](https://github.com/maelle)** -
[Markus2015](https://github.com/Markus2015) -
[matutosi](https://github.com/matutosi) -
[mcsiple](https://github.com/mcsiple) -
[MikkoVihtakari](https://github.com/MikkoVihtakari) -
[millerjef](https://github.com/millerjef) -
[miriamgrace](https://github.com/miriamgrace) -
[mpnelsen](https://github.com/mpnelsen) -
[MUSEZOOLVERT](https://github.com/MUSEZOOLVERT) -
[nate-d-olson](https://github.com/nate-d-olson) -
[nmatzke](https://github.com/nmatzke) -
[npch](https://github.com/npch) -
[ocstringham](https://github.com/ocstringham) -
[p-neves](https://github.com/p-neves) -
[p-schaefer](https://github.com/p-schaefer) -
[padpadpadpad](https://github.com/padpadpadpad) -
[paternogbc](https://github.com/paternogbc) -
**[patperu](https://github.com/patperu)** -
[pederengelstad](https://github.com/pederengelstad) -
[philippi](https://github.com/philippi) -
[Phylloxera](https://github.com/Phylloxera) -
**[pmarchand1](https://github.com/pmarchand1)** -
[pozsgaig](https://github.com/pozsgaig) -
[pssguy](https://github.com/pssguy) -
**[raredd](https://github.com/raredd)** -
[rec3141](https://github.com/rec3141) -
**[Rekyt](https://github.com/Rekyt)** -
[RodgerG](https://github.com/RodgerG) -
[rossmounce](https://github.com/rossmounce) -
[sariya](https://github.com/sariya) -
[sastoudt](https://github.com/sastoudt) -
[scelmendorf](https://github.com/scelmendorf) -
**[sckott](https://github.com/sckott)** -
[SimonGoring](https://github.com/SimonGoring) -
[snsheth](https://github.com/snsheth) -
[snubian](https://github.com/snubian) -
[Squiercg](https://github.com/Squiercg) -
[sunray1](https://github.com/sunray1) -
**[taddallas](https://github.com/taddallas)** -
[tdjames1](https://github.com/tdjames1) -
[tmkurobe](https://github.com/tmkurobe) -
[toczydlowski](https://github.com/toczydlowski) -
[tpaulson1](https://github.com/tpaulson1) -
[tpoisot](https://github.com/tpoisot) -
**[TrashBirdEcology](https://github.com/TrashBirdEcology)** -
**[trvinh](https://github.com/trvinh)** -
**[vijaybarve](https://github.com/vijaybarve)** -
[wcornwell](https://github.com/wcornwell) -
[willpearse](https://github.com/willpearse) -
[wpetry](https://github.com/wpetry) -
[yhg926](https://github.com/yhg926) -
**[zachary-foster](https://github.com/zachary-foster)**

## Road map

Check out our
[milestones](https://github.com/ropensci/taxize/milestones) to see what
we plan to get done for each version.

## Meta

-   Please [report any issues or
    bugs](https://github.com/ropensci/taxize/issues).
-   License: MIT
-   Get citation information for `taxize` in R doing
    `citation(package = 'taxize')`
-   Please note that this package is released with a [Contributor Code
    of Conduct](https://ropensci.org/code-of-conduct/). By contributing
    to this project, you agree to abide by its terms.

[![rofooter](https://ropensci.org/public_images/github_footer.png)](https://ropensci.org)
