# 宮保拼音鍵盤佈局

## 七指禪

七指禪／大衆式／g·i·a 佈局

    --------------------------------------
    指法  左4 左3 左2 左2 右2 右2 右3 右4
    --------------------------------------
    上排    c   l   d   t       u  -i   o
    中排    s   h   g*  k   er  i* -n   e
    下排    z   f   b   p   er' ü  -u   e'
    拇指                    a*
    --------------------------------------
    指法                  右1
    --------------------------------------

標「*」的按鍵爲拇指、食指的基準鍵位，可幫助定位其他按鍵。
本文及輸入方案配置中，通過列舉定位鍵指稱鍵盤佈局。

e' 是 e 的活用鍵位，只用於組合韻母。
er' 和 er 等效，分別爲直列鍵盤和錯列鍵盤優化設計。

組合鍵：

### 組合聲母

    b+f = ⟨m⟩, d+l = ⟨n⟩, g+h = ⟨r⟩,
    z+f = ⟨zh⟩, c+l = ⟨ch⟩, s+h = ⟨sh⟩,

### 組合韻母及活用

括弧內爲活用組合

    a-i = ⟨ai⟩, e-i (o-i) = ⟨ei⟩,
    a-u = ⟨ao⟩, -u (e'-u) = ⟨ou⟩,
    u-i = ⟨uei⟩, u+a-i = ⟨uai⟩,
    i-u (ü-u) = ⟨iou⟩, i+a-u (ü+a-u) = ⟨iao⟩,
    -n = ⟨en⟩, -n+e = ⟨eng⟩,
    a-n = ⟨an⟩, a-n+e = ⟨ang⟩,
    i-n = ⟨in⟩, u-n = ⟨uen⟩, ü-n = ⟨ün⟩,
    i-n+e = ⟨ing⟩, u-n+e (u-i+o) = ⟨ong⟩, ü-n+e (ü-u+e') = ⟨iong⟩,
    u+a-n+e (u+a-i+o) = ⟨uang⟩


## 八指禪

八指禪／執鍵人式／z·h·i·a 佈局

佈局專爲拆分空格鍵盤優化，左右手拇指各司一鍵以利並擊。
略改換指法，亦可兼容具備全鍵並擊或任意6鍵並擊性能的標準電腦鍵盤。

    --------------------------------------
    指法  左4 左3 左2 左2 右2 右2 右3 右4
    --------------------------------------
    上排        l   d           u  -u   o
    中排    s   c   z*  g   er  i* -n   e
    下排        f   b       er' ü  -u   e'
    拇指                h*  a*
    --------------------------------------
    指法              左1 右1
    --------------------------------------

組合鍵：

### 組合聲母

    b+h = ⟨p⟩, d+h = ⟨t⟩, g+h = ⟨k⟩,
    b+f = ⟨m⟩, d+l = ⟨n⟩, z+c = ⟨r⟩,
    z+h = ⟨zh⟩, c+h = ⟨ch⟩, s+h = ⟨sh⟩

### 組合韻母及活用

同「七指禪」

### 適用鍵盤型號及鍵位設定

支持自定義鍵位、分裂空格的鍵盤，如Ergodox、Corne、Alice等等。
可通過VIA、QMK Configurator等工具將右手拇指大鍵編程爲空格，
左手拇指大鍵編程爲Control或其他可選鍵位。

## 八指禪兼容佈局

八指禪兼容佈局／z·i·a 佈局

兼容通用電腦鍵盤。
以「八指禪」佈局爲基礎，兼收「七指禪」的部分聲母鍵及組合聲母。

    ------------------------------------------
    指法  左5 左4 左3 左2 左2 右2 右2 右3 右4
    ------------------------------------------
    上排       (c') l   d  (t')     u  -i   o
    中排    h'  s   c   z*  g       i* -n   e
    下排       (z') f   b  (p') er  ü  -u   e'
    拇指                        a*
    ------------------------------------------
    指法                      右1
    ------------------------------------------

h' 可用字母鍵 A 或設定爲用分號、左Control/Alt/Shift鍵擊發。
加 () 的冗餘按鍵，是爲方便用家從「大衆式」過渡到本式而增設。

組合鍵增補：

### 組合聲母及活用

在組合聲母中設置 s, c 等爲 h' 的通借鍵以分擔左手小指的壓力。
若大量打字或長時間練習，請務必習用通借鍵，謹防小指過度疲勞。

    b+h' (b+z') = ⟨p⟩, d+h' (d+c') = ⟨t⟩, g+h' (g+c, g+s) = ⟨k⟩,
    b+f = ⟨m⟩, d+l = ⟨n⟩, z+c = ⟨r⟩,
    z+h' (z+s) = ⟨zh⟩, c+h' = ⟨ch⟩, s+h' = ⟨sh⟩,

### 兼容「七指禪」聲母

    p' = ⟨p⟩, t' = ⟨t⟩, z'+f = ⟨zh⟩, c'+l = ⟨ch⟩, s+c = ⟨sh⟩

## 左式

左式／z·h·-n 佈局

記錄一種設計思路。

    ------------------------------------------
    指法  左4 左3 左2 左2 右2 右2 右3 右4 右5
    ------------------------------------------
    上排        l   d      ai  ei  u   o   er
    中排    s   c   z*  g -ng  -n* i   a
    下排        f   b      ao  ou  ü   e
    拇指                h*
    ------------------------------------------
    指法              左1
    ------------------------------------------

組合鍵：

### 組合聲母

    b+h = ⟨p⟩, d+h = ⟨t⟩, g+h = ⟨k⟩,
    b+f = ⟨m⟩, d+l = ⟨n⟩, z+c = ⟨r⟩,
    z+h = ⟨zh⟩, c+h = ⟨ch⟩, s+h = ⟨sh⟩

### 組合韻母及活用

    u+a-n (u+o-n) = ⟨uan⟩
    u+a-ng (u+o-ng) = ⟨uang⟩
    u-n = ⟨uen⟩
    u-ng, o-ng (o+ai) = ⟨ong⟩
    ü+a-n (ü+e+ou) = ⟨üan⟩
    ü-n (ü+ou) = ⟨ün⟩
    ü-ng (ü+ao) = ⟨iong⟩

## 十指禪

十指禪／g·y·w·a 佈局

用兩顆拇指鍵的組合表記四呼。

在鍵盤固件裏，將左1指位編程爲空格鍵，右1指位編程爲單引號鍵。

若左、右拇指鍵編程爲不同按鍵，須相應地修改並擊規則。
如Emacs用家可將左1指位設爲Control，右1指位設爲空格鍵。

    --------------------------------------------
    指法  左5 左4 左3 左2 左2 右2 右2 右3 右4 右5
    --------------------------------------------
    上排  q   c   l   d   t       u  -i   o  -u
    中排  x   s   h   g*  k   er  a* -n   e  -u
    下排  j   z   f   b   p
    拇指                  y*  w*
    --------------------------------------------
    指法                 左1 右1
    --------------------------------------------

標「*」的按鍵爲拇指、食指的基準鍵位，可幫助定位其他按鍵。
本文及輸入方案配置中，通過列舉定位鍵指稱鍵盤佈局。

y 和 w 表示介音⟨i⟩⟨u⟩，兩者並擊爲⟨ü⟩。對應地，-i, -u 用於韻尾。
惟 y 和 w 不可單擊；音節⟨yi⟩⟨wu⟩可拼作 y-i, w+u 或簡作 -i, u。

與 j, q, x 拼合時，y 鍵即元音⟨i⟩可省略，元音⟨ü⟩可略爲⟨u⟩。

在合口呼中，e 鍵可活用爲⟨o⟩，如 w+o = ⟨uo⟩；
類似地，o, e 在雙元音中可相互代用： o-i = ⟨ei⟩, e-u = ⟨ou⟩。

組合鍵：

### 組合聲母

    b+f = ⟨m⟩, d+l = ⟨n⟩, g+h = ⟨r⟩,
    z+f = ⟨zh⟩, c+l = ⟨ch⟩, s+h = ⟨sh⟩

### 組合韻母

    y+w (y+u) = ⟨ü⟩
    a-i = ⟨ai⟩
    o-i (e-i) = ⟨ei⟩
    w-i (u-i) = ⟨uei⟩
    a-o (a-u) = ⟨ao⟩
    o-u (e-u) = ⟨ou⟩
    y-u (y+o-u, y+e-u) = ⟨iou⟩
    a-n = ⟨an⟩
    -n = ⟨en⟩
    y-n = ⟨in⟩
    w-n = ⟨uen⟩
    y+w-n = ⟨ün⟩
    a-n+e  = ⟨ang⟩
    -n+e = ⟨eng⟩
    y-n+e = ⟨ing⟩
    w-n+e = ⟨ong⟩
    y+w-n+e = ⟨iong⟩

### 活用組合

不發生混淆的情況下，o, e 兩鍵可相互代用。通過與介音的有效搭配區分。

    w+e = u+o = ⟨uo⟩
    y+w+e = y+u+o = ⟨üe⟩

下列組合 -i+o 通借爲 -n+e ⟨ng⟩ 以利右手2、3、4指在同一行上並擊。

    w-n+e = u-i+o = ⟨ong⟩
    y+w-n+e = y+u-i+o = ⟨iong⟩

## 九指禪

九指禪／g·y·a 佈局

對十指禪佈局做少許調整，兼容通用鍵盤（單空格鍵）。

    --------------------------------------------
    指法  左5 左4 左3 左2 左2 右2 右2 右3 右4 右5
    --------------------------------------------
    上排  q   c   l   d   t   ua  u  -i   o  -u
    中排  x   s   h   g*  k   er  a* -n   e  -u
    下排  j   z   f   b   p   ua  u
    拇指                  y*
    --------------------------------------------
    指法                 左1
    --------------------------------------------

標「*」的按鍵爲拇指、食指的基準鍵位，可幫助定位其他按鍵。
本文及輸入方案配置中，通過列舉定位鍵指稱鍵盤佈局。

左手拇指管 y 鍵即空格鍵。
十指禪中的 w 鍵由 u 代替。增設 ua 鍵，代表雙元音⟨ua⟩。

### 組合聲母

同「十指禪」

### 組合韻母及活用

與「十指禪」略同，更動、增設下列包含 u, ua 的組合鍵。
除獨用外，er 鍵可活用爲 ua 形成組合韻母，以下不再專門列出。

    y+u = ⟨ü⟩
    u+e = u+o = ⟨uo⟩
    y+u+e = y+u+o = ⟨üe⟩
    u-i = ⟨uei⟩
    ua-i = ⟨uai⟩
    u-n = ⟨uen⟩
    ua-n = ⟨uan⟩
    y+u-n = ⟨ün⟩
    y+ua-n = ⟨üan⟩
    u-n+e = u-i+o = ⟨ong⟩
    y+u-n+e = y+u-i+o = ⟨iong⟩
    ua-n+e = ua-i+o = ⟨iong⟩
