//vio_stdvios.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2019
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include "libroar.h"

static struct roar_vio_calls _libroar_vio_stdvios[3] = {
 { .inst     = (void*)(ROAR_INSTINT)(ROAR_STDIN  + 1),
   .flags    = 0x00000000,
   .refc     = 1,
   .read     = roar_vio_basic_read,
   .write    = roar_vio_basic_write,
   .lseek    = roar_vio_basic_lseek,
   .sync     = roar_vio_basic_sync,
   .ctl      = roar_vio_basic_ctl,
   .close    = roar_vio_basic_close
 },
 { .inst     = (void*)(ROAR_INSTINT)(ROAR_STDOUT + 1),
   .flags    = 0x00000000,
   .refc     = 1,
   .read     = roar_vio_basic_read,
   .write    = roar_vio_basic_write,
   .lseek    = roar_vio_basic_lseek,
   .sync     = roar_vio_basic_sync,
   .ctl      = roar_vio_basic_ctl,
   .close    = roar_vio_basic_close
 },
 { .inst     = (void*)(ROAR_INSTINT)(ROAR_STDERR + 1),
   .flags    = 0x00000000,
   .refc     = 1,
   .read     = roar_vio_basic_read,
   .write    = roar_vio_basic_write,
   .lseek    = roar_vio_basic_lseek,
   .sync     = roar_vio_basic_sync,
   .ctl      = roar_vio_basic_ctl,
   .close    = roar_vio_basic_close
 }
};

#ifndef ROAR_TARGET_WIN32
struct roar_vio_calls * roar_stdin  = &(_libroar_vio_stdvios[0]);
struct roar_vio_calls * roar_stdout = &(_libroar_vio_stdvios[1]);
struct roar_vio_calls * roar_stderr = &(_libroar_vio_stdvios[2]);
#else
struct roar_vio_calls ** libroar_stdvio_win32workaround(int fh) {
 static struct roar_vio_calls * vios[3] = {
  &(_libroar_vio_stdvios[0]),
  &(_libroar_vio_stdvios[1]),
  &(_libroar_vio_stdvios[2])
 };

 if ( fh >= 0 && fh <= 2) {
  return &(vios[fh]);
 } else {
  roar_strap(ROAR_TRAP_GROUP_LIBROAR, "libroar_stdvio_win32workaround.bad-fh");
  roar_err_set(ROAR_ERROR_BADFH); // just in case somebody uses a debugger.
  return NULL;
 }
}
#endif

//ll
