# 2022-09-06 Triage Log

A relatively quiet week where regressions unfortunately outweighed improvements. What's more, many of the regressions that were found seemed somewhat mysterious requiring some deeper investigations.

Triage done by **@rylev**.
Revision range: [0631ea5d73..09fb0bc6e](https://perf.rust-lang.org/?start=0631ea5d73f4a3199c776687b12c20c50a91f0d2&end=09fb0bc6ecef62201d7c662db24b984d03245ac6&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | [0.2%, 4.5%] | 85    |
| Regressions ❌ <br /> (secondary) | 1.0% | [0.3%, 5.4%] | 87    |
| Improvements ✅ <br /> (primary) | -0.7% | [-1.0%, -0.5%] | 9     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-2.7%, -0.5%] | 22    |
| All ❌✅ (primary) | 0.5% | [-1.0%, 4.5%] | 94    |


2 Regressions, 3 Improvements, 2 Mixed; 3 of them in rollups
40 artifact comparisons made in total

#### Regressions

Replace `rustc_data_structures::thin_vec::ThinVec` with `thin_vec::ThinVec` [#100869](https://github.com/rust-lang/rust/pull/100869) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b32223fec10743af93913c41ec60645d741b0cb6&end=eac6c33bc6338f40e66975dd6f65dab27765067b&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | [0.2%, 0.5%] | 37    |
| Regressions ❌ <br /> (secondary) | 0.5% | [0.2%, 0.9%] | 12    |
| Improvements ✅ <br /> (primary) | -0.5% | [-0.6%, -0.4%] | 4     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.2% | [-0.6%, 0.5%] | 41    |
- [Pre-merge results](https://github.com/rust-lang/rust/pull/100869#issuecomment-1230363162) looked much more performance neutral than this ended up being.
- [The author is looking into](https://github.com/rust-lang/rust/pull/100869#issuecomment-1234861103) whether there are any obvious follow-ups.


Rollup of 14 pull requests [#101295](https://github.com/rust-lang/rust/pull/101295) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2e35f954ada0f0c777844dc4fa66684efe90a035&end=10706d62da83c4ec215165bc72df46219536648f&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.5% | [0.4%, 4.2%] | 6     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 1.5% | [0.4%, 4.2%] | 6     |
- [#101279](https://github.com/rust-lang/rust/pull/101279) is responsible for these regressions.
- This was a bug fix and the [performance impact was not too surprising](https://github.com/rust-lang/rust/pull/101295#issuecomment-1235570451).


#### Improvements

Rollup of 7 pull requests [#101238](https://github.com/rust-lang/rust/pull/101238) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=12e4fd0755d7d976d4ee0f2004dc938290752ff7&end=4fd4de7ea358ad6fc28c5780533ea8ccc09e1006&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.4% | [-0.4%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary) | -0.4% | [-0.4%, -0.3%] | 3     |


interpret: fix unnecessary allocation in validation visitor [#101154](https://github.com/rust-lang/rust/pull/101154) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=92086258e30ae59610a1b1097d97227377db0ada&end=06b72b06a2734a3997abe12dded7c19d49a18cc2&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.5% | [-0.5%, -0.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.6% | [-3.3%, -0.6%] | 13    |
| All ❌✅ (primary) | -0.5% | [-0.5%, -0.5%] | 1     |


Revert "Remove deferred sized checks" [#100966](https://github.com/rust-lang/rust/pull/100966) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c6ce6b91b172f77c795a74bfeaf74b865146b3f&end=0209485578807b8084127f12d57771300edff87a&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 0.9% | [0.6%, 2.4%] | 7     |
| Improvements ✅ <br /> (primary) | -1.2% | [-1.3%, -1.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.7% | [-1.7%, -1.6%] | 2     |
| All ❌✅ (primary) | -1.2% | [-1.3%, -1.1%] | 2     |
- The regressions listed here are just noise.


#### Mixed

Rework definition of MIR phases to more closely reflect semantic concerns [#99102](https://github.com/rust-lang/rust/pull/99102) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=02654a0844f5c8d29bac318c3c6c666da3d8543d&end=f07d6e8c0a90a6b03dcf96366d0462c7c25962bd&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | [0.3%, 1.7%] | 33    |
| Regressions ❌ <br /> (secondary) | 1.4% | [0.5%, 2.0%] | 11    |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 4     |
| All ❌✅ (primary) | 0.7% | [0.3%, 1.7%] | 33    |
- A late addition to the PR to simplify some passes has [caused the regression](https://github.com/rust-lang/rust/pull/99102#issuecomment-1232458445).
- [Pinged the author](https://github.com/rust-lang/rust/pull/99102#issuecomment-1238129477) to see if there is any additional follow-up.


Rollup of 9 pull requests [#101318](https://github.com/rust-lang/rust/pull/101318) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e21d771b9c76056d20db310ce8655539045b3af5&end=9353538c7bea6edb245457712cec720305c4576e&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.2% | [0.2%, 0.2%] | 3     |
| Regressions ❌ <br /> (secondary) | 1.0% | [0.3%, 3.9%] | 5     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-0.8%, -0.8%] | 1     |
| All ❌✅ (primary) | 0.2% | [0.2%, 0.2%] | 3     |
- There doesn't seem to be a clear cause so running a few of the PRs through performance runs to see what happens.


