(defvar *config-name* (second sb-ext:*posix-argv*))
(defvar *sbcl-local-target-features-file*
  (format nil "obj/xbuild/~A/local-target-features" *config-name*))
(load "src/cold/shared.lisp")
(in-package "SB-COLD")
(let* ((build-dir (format nil "obj/xbuild/~A/" cl-user::*config-name*))
       (objroot (format nil "~A/from-xc/" build-dir)))
  (ensure-directories-exist objroot)
  (defparameter *host-obj-prefix* (format nil "~A/from-host/" build-dir))
  (defparameter *target-obj-prefix* objroot)
  (defparameter *build-dependent-generated-sources-root* objroot)
  (let ((makeflags (sb-ext:posix-getenv "MAKEFLAGS")))
    (when (search "--jobserver" makeflags)
      (setq sb-sys:*stdout* (open (format nil "~A/stdout" objroot) :direction :output
                                  :if-does-not-exist :create :if-exists :supersede)
            sb-sys:*stderr* (open (format nil "~A/stderr" objroot) :direction :output
                                  :if-does-not-exist :create :if-exists :supersede))
      (setf (sb-impl::fd-stream-buffering sb-sys:*stdout*) :line))))
(load "src/cold/set-up-cold-packages.lisp")
(load "src/cold/defun-load-or-cload-xcompiler.lisp")
(load-or-cload-xcompiler #'host-load-stem)
(preload-perfect-hash-generator (perfect-hash-generator-journal :input))

;;; Redefine STEM-SOURCE-PATH to take 'stuff-groveled-from-headers' from the
;;; configuration-dependent location, but otherwise the normal locpation.
(host-sb-int:encapsulate 'stem-source-path 'wrap
  (lambda (realfun stem)
    (if (string= stem "output/stuff-groveled-from-headers")
        (let ((arch (string-downcase (sb-cold::target-platform-keyword))))
          (flet ((try (name &optional (check-existence t))
                   (let ((fullname
                          (format nil "crossbuild-runner/backends/~a/~a.lisp" arch name)))
                     (when (or (not check-existence) (probe-file fullname))
                       fullname))))
            (or (and (member :win32 sb-xc:*features*) (try "win32-headers"))
                (and (member :linux sb-xc:*features*) (try "linux-headers"))
                (and (member :darwin sb-xc:*features*) (try "darwin-headers"))
                (try "posix-headers")
                (try "stuff-groveled-from-headers" nil))))
        (funcall realfun stem))))

(format t "~&Target features: ~S~%" sb-xc:*features*)
(let ((warnings (sb-xc:with-compilation-unit ()
                  (load "src/cold/compile-cold-sbcl.lisp")
                  sb-c::*undefined-warnings*)))
  (finish-output host-sb-sys:*stdout*)
  (finish-output host-sb-sys:*stderr*)
  (when warnings
    (error "Fail")))

(load "tools-for-build/corefile.lisp" :verbose nil)
(host-cload-stem "src/compiler/generic/genesis" nil)
(let (object-file-names)
  (do-stems-and-flags (stem flags 2)
    (unless (member :not-target flags)
      (push (stem-object-path stem flags :target-compile) object-file-names)))
  (genesis :object-file-names (nreverse object-file-names)
           :defstruct-descriptions (find-bootstrap-file "output/defstructs.lisp-expr" t)
           :tls-init (read-from-file "output/tls-init.lisp-expr" :build-dependent t)
           :core-file-name (format nil "obj/xbuild/~A.core" cl-user::*config-name*)))
