#!/usr/bin/perl
## drawcube.pl
# requires latex Color package
# command line parameters Pointname,sidelength,temp-filename
# use: system("perl drawcube.pl P s3 temp.txt")
# see mathsPIC manual
#===========================
my ($argnumber) = $#ARGV +1;
if ($argnumber != 3){
  print "============================\n";
  print "ERROR: drawcube.pl requires 3 arguments\n";
  print "USE:   drawcube.pl  <pointname> <sidelength> <filename> \n";
  print "============================\n";
  exit(1);
}
my ($point, $side, $filename)=@ARGV;
open (outfile, ">$filename")|| die "ERROR can't create file $filename\n";
print (outfile  <<EOF);
\%\%------mathsPIC code----------------
var r=$side*sqrt(2)/2
var a=30 %% angle degrees
Point*(P990){$point, polar(r/2, (a-180) deg)}
Point*(P991){P990, polar(r, 45 deg)}
Point*(P992){P991, rotate(P990, 90)}
Point*(P993){P991, rotate(P990, 180)}
Point*(P994){P991, rotate(P990, 270)}
Point*(P995){P991, polar(r, a deg)}
Point*(P996){P992, polar(r, a deg)}
Point*(P997){P993, polar(r, a deg)}
Point*(P998){P994, polar(r, a deg)}
%% draw the sides
\\color{blue}
drawline(P991 P992 P993 P994 P991, P994 P998 P995 P996 P992, P991 P995)
\\setdashes
drawline(P993 P997 P998, P997 P996)
%% draw the diagonals
\\color{red}
drawline(P991 P997, P992 P998, P996 P994, P995 P993)
%% draw the points and labels
\\setsolid\\color{black}
drawpoint($point P991 P992 P993 P994 P995 P996 P997 P998)
text(\$$point\$){$point, shift(-0.4,-0.1)}
text(\$P991\$){P991, shift(-0.3,0.3)}
text(\$P995\$){P995, shift(-0.3,0.3)}
%%----------------------------
EOF
# now delete the temp file
print (outfile  qq(system("rm $filename")\n));
close outfile
__END__
