/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import rene.gui.Global;
import rene.util.MyVector;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;

public class MoverTool
extends ObjectConstructor {
    ConstructionObject P;
    boolean Selected = false;
    boolean ShowsValue;
    boolean ShowsName;
    boolean Grab;
    boolean WasDrawable;
    boolean ChangedDrawable;
    MyVector V = null;
    double OldX;
    double OldY;
    Graphics ZCG;
    boolean IntersectionBecameInvalid = false;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        Enumeration enumeration;
        if (!this.Selected && this.V != null) {
            zirkelCanvas.clearSelected();
        }
        if (mouseEvent.isControlDown() && this.V == null) {
            this.P = zirkelCanvas.selectObject(mouseEvent.getX(), mouseEvent.getY());
            this.ChangedDrawable = false;
            if (this.P instanceof FixedCircleObject && ((FixedCircleObject)this.P).fixedByNumber()) {
                this.WasDrawable = ((FixedCircleObject)this.P).isDragable();
                this.ChangedDrawable = true;
                ((FixedCircleObject)this.P).setDragable(true);
            } else if (this.P instanceof FixedAngleObject && ((FixedAngleObject)this.P).fixedByNumber()) {
                this.WasDrawable = ((FixedAngleObject)this.P).isDragable();
                this.ChangedDrawable = true;
                ((FixedAngleObject)this.P).setDragable(true);
            } else {
                this.P = null;
            }
        }
        if (this.P == null) {
            this.P = this.V != null ? zirkelCanvas.selectMoveablePoint(mouseEvent.getX(), mouseEvent.getY()) : zirkelCanvas.selectMoveableObject(mouseEvent.getX(), mouseEvent.getY());
        }
        if (this.P != null && this.V != null) {
            enumeration = this.V.elements();
            while (enumeration.hasMoreElements()) {
                if (this.P != enumeration.nextElement()) continue;
                if (mouseEvent.isShiftDown()) {
                    this.P = null;
                    break;
                }
                this.V.removeElement(this.P);
                break;
            }
        }
        if (this.P != null) {
            this.P.setSelected(true);
            this.ShowsName = this.P.showName();
            this.ShowsValue = this.P.showValue();
            zirkelCanvas.setCursor(new Cursor(13));
        } else {
            boolean bl = this.Selected = zirkelCanvas.findSelectedObject() != null;
        }
        if (this.V != null) {
            enumeration = this.V.elements();
            while (enumeration.hasMoreElements()) {
                ((PointObject)enumeration.nextElement()).setSelected(true);
            }
        }
        if (this.P != null) {
            if (this.P instanceof PointObject) {
                if (mouseEvent.isShiftDown()) {
                    if (this.V == null) {
                        this.V = new MyVector();
                    }
                    if (this.P != null) {
                        this.V.addElement(this.P);
                    }
                    this.P = null;
                } else if (mouseEvent.isControlDown()) {
                    zirkelCanvas.grab(true);
                    this.Grab = true;
                } else {
                    this.OldX = ((PointObject)this.P).getX();
                    this.OldY = ((PointObject)this.P).getY();
                }
            } else if (this.P instanceof MoveableObject) {
                ((MoveableObject)((Object)this.P)).startDrag(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
                this.V = null;
            }
            if (this.ZCG != null) {
                this.ZCG.dispose();
                this.ZCG = null;
            }
            this.ZCG = zirkelCanvas.getGraphics();
        }
        zirkelCanvas.repaint();
        this.showStatus(zirkelCanvas);
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        zirkelCanvas.indicateMoveableObjects(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isControlDown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (this.P == null) {
            return;
        }
        zirkelCanvas.getConstruction().haveChanged();
        zirkelCanvas.getConstruction().dontAlternate(false);
        ZirkelCanvas zirkelCanvas2 = zirkelCanvas;
        synchronized (zirkelCanvas2) {
            PointObject pointObject;
            double d2 = 0.0;
            double d3 = 0.0;
            if ((Global.getParameter("restrictedmove", false) || mouseEvent.isShiftDown()) && this.P instanceof PointObject) {
                if (this.IntersectionBecameInvalid) {
                    zirkelCanvas.getConstruction().dontAlternate(true);
                    this.IntersectionBecameInvalid = false;
                }
                d2 = ((PointObject)this.P).getX();
                d3 = ((PointObject)this.P).getY();
            }
            ((MoveableObject)((Object)this.P)).dragTo(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            if (Global.getParameter("options.movename", false) && !this.P.isFixed() || Global.getParameter("options.movefixname", true) && this.P.isFixed()) {
                this.P.setShowValue(true);
                this.P.setShowName(true);
            }
            this.P.updateText();
            if (this.V != null && this.P instanceof PointObject) {
                double d4 = ((PointObject)this.P).getX() - this.OldX;
                double d5 = ((PointObject)this.P).getY() - this.OldY;
                Enumeration enumeration = this.V.elements();
                while (enumeration.hasMoreElements()) {
                    PointObject pointObject2 = (PointObject)enumeration.nextElement();
                    pointObject2.move(pointObject2.getX() + d4, pointObject2.getY() + d5);
                    pointObject2.updateText();
                }
                this.OldX = ((PointObject)this.P).getX();
                this.OldY = ((PointObject)this.P).getY();
            }
            if (this.P instanceof PointObject && (pointObject = (PointObject)this.P).dependsOnItselfOnly()) {
                pointObject.dontUpdate(true);
                zirkelCanvas.dovalidate();
                pointObject.dontUpdate(false);
            }
            zirkelCanvas.validate();
            if ((Global.getParameter("restrictedmove", false) || mouseEvent.isShiftDown()) && this.P instanceof PointObject && zirkelCanvas.getConstruction().intersectionBecameInvalid()) {
                ((PointObject)this.P).dragTo(d2, d3);
                this.IntersectionBecameInvalid = true;
                zirkelCanvas.validate();
            }
        }
        if (this.ZCG == null) {
            this.ZCG = zirkelCanvas.getGraphics();
        }
        zirkelCanvas.paint(this.ZCG);
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        if (this.P == null) {
            return;
        }
        if (this.ZCG != null) {
            this.ZCG.dispose();
            this.ZCG = null;
        }
        zirkelCanvas.setCursor(Cursor.getDefaultCursor());
        this.P.setSelected(false);
        this.P.setShowValue(this.ShowsValue);
        this.P.setShowName(this.ShowsName);
        if (zirkelCanvas.showGrid() && !bl && Global.getParameter("grid.leftsnap", false)) {
            if (this.P instanceof PointObject && this.V != null) {
                double d2 = ((PointObject)this.P).getX();
                double d3 = ((PointObject)this.P).getY();
                this.P.snap(zirkelCanvas);
                d2 = ((PointObject)this.P).getX() - d2;
                d3 = ((PointObject)this.P).getY() - d3;
                this.P.round();
                this.P.updateText();
                Enumeration enumeration = this.V.elements();
                while (enumeration.hasMoreElements()) {
                    PointObject pointObject = (PointObject)enumeration.nextElement();
                    pointObject.move(pointObject.getX() + d2, pointObject.getY() + d3);
                    pointObject.updateText();
                }
            } else {
                this.P.snap(zirkelCanvas);
                this.P.round();
                this.P.updateText();
            }
        }
        zirkelCanvas.validate();
        if (this.Grab) {
            zirkelCanvas.grab(false);
            this.Grab = false;
        }
        if (this.ChangedDrawable) {
            if (this.P instanceof FixedCircleObject) {
                ((FixedCircleObject)this.P).setDragable(this.WasDrawable);
            } else if (this.P instanceof FixedAngleObject) {
                ((FixedAngleObject)this.P).setDragable(this.WasDrawable);
            }
        }
        zirkelCanvas.clearSelected();
        zirkelCanvas.repaint();
        this.P = null;
        this.V = null;
        this.Selected = false;
        this.showStatus(zirkelCanvas);
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.mouseReleased(mouseEvent, zirkelCanvas, false);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        this.V = null;
        this.P = null;
        zirkelCanvas.clearSelected();
        zirkelCanvas.repaint();
        this.Selected = false;
    }

    public void resetFirstTime(ZirkelCanvas zirkelCanvas) {
        if (this.V != null) {
            this.V.removeAllElements();
        }
        zirkelCanvas.clearSelected();
        zirkelCanvas.selectAllMoveableVisibleObjects();
        Graphics graphics = zirkelCanvas.getGraphics();
        if (graphics != null) {
            zirkelCanvas.paint(graphics);
            graphics.dispose();
            try {
                Thread.sleep(400L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            zirkelCanvas.clearSelected();
        }
        zirkelCanvas.repaint();
        this.Selected = false;
        this.P = null;
        this.V = null;
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P == null && !this.Selected) {
            zirkelCanvas.showStatus(Zirkel.name("message.move.select", "Move: Select a point"));
        } else if (this.Selected) {
            zirkelCanvas.showStatus(Zirkel.name("message.move.move", "Move: Move the point"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.move.move", "Move: Move the point") + " (" + this.P.getName() + ")");
        }
    }

    public boolean useSmartBoard() {
        return false;
    }
}

