package ONVIF::Device::Types::DeviceIOCapabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %XAddr_of :ATTR(:get<XAddr>);
my %VideoSources_of :ATTR(:get<VideoSources>);
my %VideoOutputs_of :ATTR(:get<VideoOutputs>);
my %AudioSources_of :ATTR(:get<AudioSources>);
my %AudioOutputs_of :ATTR(:get<AudioOutputs>);
my %RelayOutputs_of :ATTR(:get<RelayOutputs>);

__PACKAGE__->_factory(
    [ qw(        XAddr
        VideoSources
        VideoOutputs
        AudioSources
        AudioOutputs
        RelayOutputs

    ) ],
    {
        'XAddr' => \%XAddr_of,
        'VideoSources' => \%VideoSources_of,
        'VideoOutputs' => \%VideoOutputs_of,
        'AudioSources' => \%AudioSources_of,
        'AudioOutputs' => \%AudioOutputs_of,
        'RelayOutputs' => \%RelayOutputs_of,
    },
    {
        'XAddr' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'VideoSources' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'VideoOutputs' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'AudioSources' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'AudioOutputs' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'RelayOutputs' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'XAddr' => 'XAddr',
        'VideoSources' => 'VideoSources',
        'VideoOutputs' => 'VideoOutputs',
        'AudioSources' => 'AudioSources',
        'AudioOutputs' => 'AudioOutputs',
        'RelayOutputs' => 'RelayOutputs',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::DeviceIOCapabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DeviceIOCapabilities from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * XAddr


=item * VideoSources


=item * VideoOutputs


=item * AudioSources


=item * AudioOutputs


=item * RelayOutputs




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::DeviceIOCapabilities
   XAddr =>  $some_value, # anyURI
   VideoSources =>  $some_value, # int
   VideoOutputs =>  $some_value, # int
   AudioSources =>  $some_value, # int
   AudioOutputs =>  $some_value, # int
   RelayOutputs =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

